/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.common;

import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.engio.mbassy.common.IConcurrentSet;
import net.engio.mbassy.common.ISetEntry;

public abstract class AbstractConcurrentSet<T>
implements IConcurrentSet<T> {
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<T, ISetEntry<T>> entries;
    protected Entry<T> head;

    protected AbstractConcurrentSet(Map<T, ISetEntry<T>> entries) {
        this.entries = entries;
    }

    protected abstract Entry<T> createEntry(T var1, Entry<T> var2);

    @Override
    public void add(T element) {
        if (element == null) {
            return;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        if (element == null || this.entries.containsKey(element)) {
            writeLock.unlock();
        } else {
            this.insert(element);
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(T element) {
        ISetEntry<T> entry;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        try {
            readLock.lock();
            entry = this.entries.get(element);
        }
        finally {
            readLock.unlock();
        }
        return entry != null && entry.getValue() != null;
    }

    private void insert(T element) {
        if (!this.entries.containsKey(element)) {
            this.head = this.createEntry(element, this.head);
            this.entries.put(element, this.head);
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(Iterable<T> elements) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            for (T element : elements) {
                if (element == null) continue;
                this.insert(element);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(T element) {
        if (!this.contains(element)) {
            return false;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            ISetEntry<T> listelement = this.entries.get(element);
            if (listelement == null) {
                boolean bl = false;
                return bl;
            }
            if (listelement != this.head) {
                listelement.remove();
            } else {
                this.head = this.head.next();
            }
            this.entries.remove(element);
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    public static abstract class Entry<T>
    implements ISetEntry<T> {
        private Entry<T> next;
        private Entry<T> predecessor;

        protected Entry(Entry<T> next) {
            this.next = next;
            next.predecessor = this;
        }

        protected Entry() {
        }

        @Override
        public void remove() {
            if (this.predecessor != null) {
                this.predecessor.next = this.next;
                if (this.next != null) {
                    this.next.predecessor = this.predecessor;
                }
            } else if (this.next != null) {
                this.next.predecessor = null;
            }
        }

        @Override
        public Entry<T> next() {
            return this.next;
        }

        @Override
        public void clear() {
            this.next = null;
        }
    }
}

