/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.engio.pips.data.DataPoint;
import net.engio.pips.data.DataProcessor;
import net.engio.pips.data.IDataCollector;
import net.engio.pips.data.IDataProcessor;

public class DataCollector<IN>
extends DataProcessor<IN, IN>
implements IDataCollector<IN> {
    private List<DataPoint<IN>> datapoints = new LinkedList<DataPoint<IN>>();
    private String id;

    public DataCollector(String id) {
        this.id = id;
    }

    @Override
    public void receive(DataPoint<IN> datapoint) {
        this.datapoints.add(datapoint);
    }

    @Override
    public void receive(IN value) {
        this.receive((IN)new DataPoint<IN>(value));
    }

    @Override
    public void feed(IDataProcessor<IN, ?> consumer) {
        for (DataPoint<IN> dataPoint : this.datapoints) {
            consumer.receive(dataPoint);
        }
    }

    @Override
    public int size() {
        return this.datapoints.size();
    }

    public String toString() {
        return this.id + ":" + this.datapoints;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<DataPoint<IN>> getDatapoints() {
        return Collections.unmodifiableList(this.datapoints);
    }

    @Override
    public Object[] getValues() {
        Object[] values = new Object[this.datapoints.size()];
        int index = 0;
        for (DataPoint<IN> dp : this.datapoints) {
            values[index++] = dp.getValue();
        }
        return values;
    }
}

