/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.engio.pips.data.IDataCollector;

public class DataCollectorManager {
    private static final String GroupDelimiter = ":";
    private Map<String, CollectorGroup> collectorsByGroup = new HashMap<String, CollectorGroup>();

    public Set<IDataCollector> getCollectorSet(String groupId) {
        TreeSet<IDataCollector> collectors = new TreeSet<IDataCollector>(new Comparator<IDataCollector>(){

            @Override
            public int compare(IDataCollector iDataCollector, IDataCollector iDataCollector2) {
                return iDataCollector.getId().compareTo(iDataCollector2.getId());
            }
        });
        for (Map.Entry<String, CollectorGroup> entry : this.collectorsByGroup.entrySet()) {
            if (!entry.getKey().startsWith(groupId) && !groupId.isEmpty()) continue;
            collectors.addAll(entry.getValue().collectors);
        }
        return collectors;
    }

    public List<IDataCollector> getCollectors(String groupId, int samples) {
        AbstractList collectors = new LinkedList<IDataCollector>();
        for (Map.Entry<String, CollectorGroup> entry : this.collectorsByGroup.entrySet()) {
            if (!entry.getKey().startsWith(groupId) && !groupId.isEmpty()) continue;
            collectors.addAll(entry.getValue().collectors);
        }
        if (samples > 0) {
            ArrayList<IDataCollector> reduced = new ArrayList<IDataCollector>();
            int total = 0;
            int modulo = collectors.size() / samples;
            for (IDataCollector collector : collectors) {
                if (++total % modulo != 0) continue;
                reduced.add(collector);
            }
            collectors = reduced;
        }
        return collectors;
    }

    public List<IDataCollector> getCollectors(String groupId) {
        return this.getCollectors(groupId, -1);
    }

    public synchronized <V> IDataCollector<V> addCollector(IDataCollector<V> collector) {
        this.addToGroup(collector.getId(), collector);
        return collector;
    }

    private void addToGroup(String groupId, IDataCollector collector) {
        CollectorGroup group = this.collectorsByGroup.get(groupId);
        if (group == null) {
            group = new CollectorGroup(groupId, collector);
            this.collectorsByGroup.put(groupId, group);
        }
        group.add(collector);
    }

    private String[] getGroups(IDataCollector collector) {
        String[] parts = collector.getId().split(GroupDelimiter);
        String[] groups = new String[parts.length - 1];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = i == 0 ? parts[i] : groups[i - 1] + GroupDelimiter + parts[i];
        }
        return groups;
    }

    public Collection<CollectorGroup> getGroups() {
        return this.collectorsByGroup.values();
    }

    public class CollectorGroup {
        private String groupId;
        private List<IDataCollector> collectors = new LinkedList<IDataCollector>();

        public CollectorGroup(String groupId, IDataCollector ... collectors) {
            this.groupId = groupId;
            for (IDataCollector col : collectors) {
                this.collectors.add(col);
            }
        }

        public String getParentGroup() {
            if (this.groupId.contains(DataCollectorManager.GroupDelimiter)) {
                return this.groupId.substring(0, this.groupId.lastIndexOf(DataCollectorManager.GroupDelimiter));
            }
            return "";
        }

        public boolean add(IDataCollector iDataCollector) {
            return this.collectors.add(iDataCollector);
        }

        public String getGroupId() {
            return this.groupId;
        }

        public List<IDataCollector> getCollectors() {
            return this.collectors;
        }

        public String toString() {
            StringBuilder collectors = new StringBuilder();
            for (IDataCollector collector : this.collectors) {
                collectors.append(collector.getId());
                collectors.append(",");
                collectors.append(collector.getDatapoints());
                collectors.append("\n");
            }
            return collectors.toString();
        }
    }
}

