/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data;

import java.util.LinkedList;
import java.util.List;
import net.engio.pips.data.DataPoint;
import net.engio.pips.data.IDataProcessor;

public abstract class DataProcessor<IN, OUT>
implements IDataProcessor<IN, OUT> {
    private List<IDataProcessor<OUT, ?>> receivers = new LinkedList();

    protected DataProcessor() {
    }

    @Override
    public <V> IDataProcessor<OUT, V> connectTo(IDataProcessor<OUT, V> consumer) {
        this.receivers.add(consumer);
        return consumer;
    }

    @Override
    public IDataProcessor<IN, OUT> connectTo(IDataProcessor<OUT, ?> ... consumer) {
        for (IDataProcessor<OUT, ?> proc : consumer) {
            this.connectTo((IDataProcessor)proc);
        }
        return this;
    }

    @Override
    public DataProcessor<IN, OUT> add(IDataProcessor<OUT, ?> destination) {
        this.receivers.add(destination);
        return this;
    }

    protected void emit(DataPoint<OUT> data) {
        for (IDataProcessor<OUT, ?> sink : this.receivers) {
            sink.receive((OUT)data);
        }
    }

    protected List<IDataProcessor<OUT, ?>> getReceivers() {
        return this.receivers;
    }

    @Override
    public void receive(IN value) {
        this.receive((IN)new DataPoint<IN>(value));
    }
}

