/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data.aggregator;

import net.engio.pips.data.DataPoint;
import net.engio.pips.data.DataProcessor;
import net.engio.pips.data.aggregator.IAggregate;

public class Average<N extends Number>
extends DataProcessor<N, Double>
implements IAggregate<N, Double> {
    private double total = 0.0;
    private int count = 0;
    private String name;

    public Average(String name) {
        this.name = name;
    }

    public Average() {
    }

    @Override
    public void reset() {
        this.total = 0.0;
        this.count = 0;
    }

    @Override
    public Double getValue() {
        return this.total / (double)this.count;
    }

    @Override
    public void receive(DataPoint<N> datapoint) {
        ++this.count;
        this.total += ((Number)datapoint.getValue()).doubleValue();
        this.emit(new DataPoint<Double>(datapoint.getTsCreated(), this.total / (double)this.count));
    }

    public String toString() {
        return this.name;
    }
}

