/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data.aggregator;

import net.engio.pips.data.DataPoint;
import net.engio.pips.data.DataProcessor;
import net.engio.pips.data.aggregator.IAggregate;
import net.engio.pips.data.filter.IDataFilter;

public class SlidingAggregator<IN, OUT>
extends DataProcessor<IN, OUT> {
    private final IAggregate<IN, OUT> aggregator;
    private IDataFilter<IN> IDataFilter;

    public SlidingAggregator(IDataFilter<IN> IDataFilter2, IAggregate<IN, OUT> aggregator) {
        this.IDataFilter = IDataFilter2;
        this.aggregator = aggregator;
    }

    @Override
    public void receive(DataPoint<IN> datapoint) {
        this.aggregator.receive(datapoint);
        if (this.IDataFilter.accepts(datapoint)) {
            this.emit(new DataPoint<OUT>(datapoint.getTsCreated(), this.aggregator.getValue()));
            this.aggregator.reset();
        }
    }
}

