/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data.filter;

import net.engio.pips.data.DataPoint;

public interface IDataFilter<V> {
    public boolean accepts(DataPoint<V> var1);

    public static class ItemCountBased<V>
    implements IDataFilter<V> {
        private int skip;
        private int skipped = 0;

        public ItemCountBased(int skip) {
            if (skip < 1) {
                throw new IllegalArgumentException("Skip at least one data point");
            }
            this.skip = skip;
            this.skipped = skip;
        }

        @Override
        public boolean accepts(DataPoint<V> vDataPoint) {
            if (this.skip == this.skipped) {
                this.skipped = 0;
                return true;
            }
            ++this.skipped;
            return false;
        }
    }

    public static class TimeBased<V>
    implements IDataFilter<V> {
        private long intervalInMs;
        private long lastSample = -1L;

        public TimeBased(long intervalInMs) {
            this.intervalInMs = intervalInMs;
        }

        @Override
        public boolean accepts(DataPoint<V> vDataPoint) {
            if (vDataPoint.getTsCreated() - this.intervalInMs >= this.lastSample) {
                this.lastSample = vDataPoint.getTsCreated();
                return true;
            }
            return false;
        }
    }
}

