/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data.filter;

import net.engio.pips.data.DataPoint;
import net.engio.pips.data.DataProcessor;
import net.engio.pips.data.filter.IDataFilter;

public class Sampler<V>
extends DataProcessor<V, V> {
    private IDataFilter strategy;

    public Sampler(IDataFilter<V> strategy) {
        this.strategy = strategy;
    }

    @Override
    public void receive(DataPoint<V> datapoint) {
        if (this.strategy.accepts(datapoint)) {
            this.emit(datapoint);
        }
    }

    public static <V> Sampler<V> timeBased(long interval) {
        return new Sampler(new IDataFilter.TimeBased(interval));
    }

    public static <V> Sampler<V> skip(int skip) {
        return new Sampler(new IDataFilter.ItemCountBased(skip));
    }
}

