/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data.utils;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import net.engio.pips.data.IDataProcessor;
import net.engio.pips.data.utils.Generator;

public class Sensor<V> {
    private int frequency;
    private TimeUnit unit;
    private IDataProcessor<V, ?> target;
    private Generator<V> generator;
    private TimerTask scheduledTask;

    private static Timer getTimer() {
        return TimerHolder.Timer;
    }

    public Sensor(int frequency, TimeUnit unit) {
        this.frequency = frequency;
        this.unit = unit;
    }

    public static Sensor Each(int frequency, TimeUnit unit) {
        return new Sensor(frequency, unit);
    }

    public Sensor<V> pipe(Generator<V> gen) {
        this.generator = gen;
        return this;
    }

    public Sensor<V> into(IDataProcessor<V, ?> target) {
        this.target = target;
        return this;
    }

    public void start() {
        this.scheduledTask = new TimerTask(){

            @Override
            public void run() {
                Sensor.this.target.receive(Sensor.this.generator.next());
            }
        };
        Sensor.getTimer().scheduleAtFixedRate(this.scheduledTask, 0L, this.unit.convert(this.frequency, TimeUnit.MILLISECONDS));
    }

    public void stop() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
        }
    }

    private static class TimerHolder {
        private static final Timer Timer = new Timer("Sensors", true);

        private TimerHolder() {
        }
    }
}

