/*
 * Decompiled with CFR 0.152.
 */
package net.engio.pips.data.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.engio.pips.data.DataCollector;
import net.engio.pips.data.DataPoint;
import net.engio.pips.data.IDataCollector;
import net.engio.pips.data.aggregator.IAggregate;

public class TimeBasedAggregator<V extends Number> {
    private Map<Long, DataCollector<V>> aggregated = new HashMap<Long, DataCollector<V>>();

    public void receive(DataPoint<V> datapoint) {
        DataCollector<Object> collector = this.aggregated.get(datapoint.getTsCreated());
        if (collector == null) {
            collector = new DataCollector("" + datapoint.getTsCreated());
            this.aggregated.put(datapoint.getTsCreated(), collector);
        }
        collector.receive((V)datapoint);
    }

    public TimeBasedAggregator<V> consume(IDataCollector<V> collector) {
        for (DataPoint<V> data : collector.getDatapoints()) {
            this.receive(data);
        }
        return this;
    }

    public TimeBasedAggregator<V> consume(IDataCollector<V> ... collectors) {
        for (IDataCollector<V> collector : collectors) {
            this.consume(collector);
        }
        return this;
    }

    public TimeBasedAggregator<V> consume(List<IDataCollector<V>> collectors) {
        for (IDataCollector<V> collector : collectors) {
            this.consume(collector);
        }
        return this;
    }

    public <A> IDataCollector<A> fold(IAggregate<V, A> aggregator, IDataCollector<A> target) {
        for (Map.Entry<Long, DataCollector<V>> entry : this.aggregated.entrySet()) {
            for (DataPoint<V> dataPoint : entry.getValue().getDatapoints()) {
                aggregator.receive((V)dataPoint);
            }
            target.receive((A)new DataPoint<A>(entry.getKey(), aggregator.getValue()));
            aggregator.reset();
        }
        return target;
    }

    public <A> IDataCollector<A> fold(IAggregate<V, A> aggregator) {
        return this.fold(aggregator, new DataCollector(aggregator.toString()));
    }
}

