/*
 * Decompiled with CFR 0.152.
 */
package org.webjars;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.webjars.CloseQuietly;
import org.webjars.WebJarExtractor;

public class FileSystemCache
implements WebJarExtractor.Cache {
    private final File cache;
    private Map<String, WebJarExtractor.Cacheable> onFile;
    private Map<String, WebJarExtractor.Cacheable> touched;
    private boolean dirty;

    public FileSystemCache(File cache) throws IOException {
        this.cache = cache;
        this.reset();
    }

    @Override
    public boolean isUpToDate(String key2, WebJarExtractor.Cacheable cacheable) {
        WebJarExtractor.Cacheable t = this.touched.get(key2);
        if (t != null) {
            return cacheable.equals(t);
        }
        WebJarExtractor.Cacheable cached = this.onFile.get(key2);
        if (cached != null) {
            this.touched.put(key2, cached);
        }
        return cacheable.equals(cached);
    }

    @Override
    public void put(String key2, WebJarExtractor.Cacheable cacheable) {
        this.touched.put(key2, cacheable);
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (this.dirty || this.onFile.size() != this.touched.size()) {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cache), "UTF-8");
            try {
                for (Map.Entry<String, WebJarExtractor.Cacheable> item2 : this.touched.entrySet()) {
                    writer.write(item2.getKey() + ":" + item2.getValue().getLastModified() + ":" + item2.getValue().getPath() + "\n");
                }
                ((Writer)writer).flush();
            }
            finally {
                CloseQuietly.closeQuietly(writer);
            }
        }
        this.onFile = this.touched;
        this.touched = new HashMap<String, WebJarExtractor.Cacheable>();
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        this.onFile = new HashMap<String, WebJarExtractor.Cacheable>();
        if (this.cache.exists()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.cache), "UTF-8"));
            try {
                String line2 = reader.readLine();
                while (line2 != null) {
                    String[] splitted;
                    if (!line2.isEmpty() && (splitted = line2.split(":", 3)).length == 3) {
                        String key2 = splitted[0];
                        String lastModified = splitted[1];
                        String path2 = splitted[2];
                        try {
                            long lm = Long.parseLong(lastModified);
                            this.onFile.put(key2, new WebJarExtractor.Cacheable(path2, lm));
                        }
                        catch (NumberFormatException e2) {
                            // empty catch block
                        }
                    }
                    line2 = reader.readLine();
                }
            }
            finally {
                CloseQuietly.closeQuietly(reader);
            }
        }
        this.touched = new HashMap<String, WebJarExtractor.Cacheable>();
        this.dirty = false;
    }
}

