/*
 * Decompiled with CFR 0.152.
 */
package org.webjars.urlprotocols;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.webjars.urlprotocols.UrlProtocolHandler;

public class FileUrlProtocolHandler
implements UrlProtocolHandler {
    private static final int MAX_DIRECTORY_DEPTH = 32;

    @Override
    public boolean accepts(String protocol) {
        return "file".equals(protocol);
    }

    @Override
    public Set<String> getAssetPaths(URL url2, Pattern filterExpr, ClassLoader ... classLoaders) {
        File file;
        HashSet<String> assetPaths = new HashSet<String>();
        try {
            String decodedPath = URLDecoder.decode(url2.getPath(), "UTF-8");
            file = new File(decodedPath);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalStateException(e2);
        }
        Set<String> paths = FileUrlProtocolHandler.listFiles(file, filterExpr);
        assetPaths.addAll(paths);
        return assetPaths;
    }

    private static Set<String> listFiles(File file, Pattern filterExpr) {
        HashSet<String> aggregatedChildren = new HashSet<String>();
        FileUrlProtocolHandler.aggregateChildren(file, file, aggregatedChildren, filterExpr, 0);
        return aggregatedChildren;
    }

    private static void aggregateChildren(File rootDirectory, File file, Set<String> aggregatedChildren, Pattern filterExpr, int level) {
        if (file.isDirectory()) {
            if (level > 32) {
                throw new IllegalStateException("Got deeper than 32 levels while searching " + rootDirectory);
            }
            for (File child : file.listFiles()) {
                FileUrlProtocolHandler.aggregateChildren(rootDirectory, child, aggregatedChildren, filterExpr, level + 1);
            }
        } else {
            FileUrlProtocolHandler.aggregateFile(file, aggregatedChildren, filterExpr);
        }
    }

    private static void aggregateFile(File file, Set<String> aggregatedChildren, Pattern filterExpr) {
        String path2 = file.getPath().replace('\\', '/');
        String relativePath = path2.substring(path2.indexOf("META-INF/resources/webjars"));
        if (filterExpr.matcher(relativePath).matches()) {
            aggregatedChildren.add(relativePath);
        }
    }
}

