/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties.komma;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class ConversionUtil {
    private static final Map<Class<?>, Class<?>> primitiveWrappers = new HashMap();

    public static Class<?> wrapperType(Class<?> type) {
        if (type.isPrimitive()) {
            return primitiveWrappers.get(type);
        }
        return type;
    }

    public static String stringValue(Object value, boolean trim) {
        String result;
        if (value == null) {
            result = "";
        } else {
            result = value.toString();
            if (trim) {
                result = result.trim();
            }
        }
        return result;
    }

    public static long longValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0L;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).longValue();
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1L : 0L;
        }
        return Long.parseLong(ConversionUtil.stringValue(value, true));
    }

    public static double doubleValue(Object value) throws NumberFormatException {
        if (value == null) {
            return 0.0;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).doubleValue();
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        String s = ConversionUtil.stringValue(value, true);
        return s.length() == 0 ? 0.0 : Double.parseDouble(s);
    }

    public static BigDecimal bigDecValue(Object value) throws NumberFormatException {
        if (value == null) {
            return new BigDecimal(0);
        }
        Class<?> c = value.getClass();
        if (c == BigDecimal.class) {
            return (BigDecimal)value;
        }
        if (c == BigInteger.class) {
            return new BigDecimal((BigInteger)value);
        }
        if (c.getSuperclass() == Number.class) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (c == Character.class) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        if (c == Boolean.class) {
            return BigDecimal.valueOf((Boolean)value != false ? 1L : 0L);
        }
        return new BigDecimal(ConversionUtil.stringValue(value, true));
    }

    public static BigInteger bigIntValue(Object value) throws NumberFormatException {
        if (value == null) {
            return new BigInteger(new byte[]{0});
        }
        Class<?> c = value.getClass();
        if (c == BigInteger.class) {
            return (BigInteger)value;
        }
        if (c == BigDecimal.class) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (c.getSuperclass() == Number.class) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (c == Character.class) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        if (c == Boolean.class) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        return new BigInteger(ConversionUtil.stringValue(value, true));
    }

    public static Boolean booleanValue(Object value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean && Boolean.FALSE.equals(value) || value instanceof Number && ((Number)value).intValue() == 0 || value instanceof String && !Boolean.parseBoolean((String)value) || value instanceof Character && ((Character)value).charValue() == '\u0000') {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Object convertValue(Class<?> toType, Object value, Object defaultValue) {
        Object result = value != null ? (toType == Integer.class || toType == Integer.TYPE ? new Integer((int)ConversionUtil.longValue(value)) : (toType == Double.class || toType == Double.TYPE ? new Double(ConversionUtil.doubleValue(value)) : (toType == Boolean.class || toType == Boolean.TYPE ? (ConversionUtil.booleanValue(value) != false ? Boolean.TRUE : Boolean.FALSE) : (toType == Byte.class || toType == Byte.TYPE ? new Byte((byte)ConversionUtil.longValue(value)) : (toType == Character.class || toType == Character.TYPE ? new Character((char)ConversionUtil.longValue(value)) : (toType == Short.class || toType == Short.TYPE ? new Short((short)ConversionUtil.longValue(value)) : (toType == Long.class || toType == Long.TYPE ? new Long(ConversionUtil.longValue(value)) : (toType == Float.class || toType == Float.TYPE ? new Float(ConversionUtil.doubleValue(value)) : (toType == BigInteger.class ? ConversionUtil.bigIntValue(value) : (toType == BigDecimal.class ? ConversionUtil.bigDecValue(value) : (toType == String.class ? ConversionUtil.stringValue(value, false) : value))))))))))) : defaultValue;
        return result;
    }

    static {
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Character.TYPE, Character.class);
        primitiveWrappers.put(Byte.TYPE, Byte.class);
        primitiveWrappers.put(Short.TYPE, Short.class);
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        primitiveWrappers.put(Float.TYPE, Float.class);
        primitiveWrappers.put(Double.TYPE, Double.class);
    }
}

