/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties.komma;

import com.google.inject.Inject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.NiceIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.composition.properties.Filterable;
import net.enilink.composition.properties.PropertySet;
import net.enilink.composition.properties.exceptions.PropertyException;
import net.enilink.composition.properties.komma.ConversionUtil;
import net.enilink.composition.properties.traits.Mergeable;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;

public class KommaPropertySet<E>
implements PropertySet<E>,
Set<E>,
Filterable<E> {
    private static final int CACHE_LIMIT = 10;
    protected static final String QUERY = "SELECT DISTINCT ?o WHERE { ?s ?p ?o }";
    protected final IReference subject;
    protected final List<WeakReference<Object>> ownerBeans = new ArrayList<WeakReference<Object>>(1);
    private volatile List<E> cache;
    @Inject
    protected IEntityManager manager;
    protected IReference property;
    protected Class<E> valueType;
    protected URI rdfValueType;

    public KommaPropertySet(IReference subject, IReference property) {
        this(subject, property, null, null);
    }

    public KommaPropertySet(IReference subject, IReference property, Class<E> valueType, URI rdfValueType) {
        assert (subject != null);
        assert (property != null);
        this.subject = subject;
        this.property = property;
        this.valueType = valueType;
        this.rdfValueType = rdfValueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOwner(Object bean) {
        List<WeakReference<Object>> list = this.ownerBeans;
        synchronized (list) {
            boolean found = false;
            Iterator<WeakReference<Object>> it = this.ownerBeans.iterator();
            while (it.hasNext()) {
                WeakReference<Object> ref = it.next();
                Object target = ref.get();
                if (target == null) {
                    it.remove();
                    continue;
                }
                if (found || !bean.equals(target)) continue;
                found = true;
            }
            if (!found) {
                this.ownerBeans.add(new WeakReference<Object>(bean));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshOwners() {
        List<WeakReference<Object>> list = this.ownerBeans;
        synchronized (list) {
            Iterator<WeakReference<Object>> it = this.ownerBeans.iterator();
            while (it.hasNext()) {
                WeakReference<Object> ref = it.next();
                Object target = ref.get();
                if (target == null) {
                    it.remove();
                    continue;
                }
                this.refresh(target);
            }
        }
    }

    @Override
    public boolean add(E o) {
        this.refresh();
        try {
            this.manager.add((Iterable)new Statement(this.subject, this.property, this.convertInstance(o)));
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
        this.refreshOwners();
        this.refresh(o);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.refresh();
        boolean modified = false;
        ITransaction transaction = this.manager.getTransaction();
        try {
            boolean active = transaction.isActive();
            if (!active) {
                transaction.begin();
            }
            try {
                for (E o : c) {
                    if (!this.add(o)) continue;
                    modified = true;
                }
                if (!active) {
                    transaction.commit();
                }
            }
            finally {
                if (!active && transaction.isActive()) {
                    transaction.rollback();
                }
            }
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
        this.refreshOwners();
        return modified;
    }

    @Override
    public void clear() {
        this.manager.remove((Iterable)new Statement(this.subject, this.property, null));
        this.refreshCache();
        this.refresh();
        this.refreshOwners();
    }

    protected boolean containsWithoutCache(Object o) {
        try {
            return ((IQuery)((IQuery)((IQuery)this.manager.createQuery("ASK { ?s ?p ?o }").setParameter("s", (Object)this.subject)).setParameter("p", (Object)this.property)).setParameter("o", this.convertInstance(o))).getBooleanResult();
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof ILiteral)) {
            List<E> cache = this.getCache();
            if (this.isCacheComplete(cache)) {
                return cache.contains(o);
            }
            if (cache != null && cache.contains(o)) {
                return true;
            }
        }
        return this.containsWithoutCache(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        List<E> cache = this.getCache();
        if (cache != null) {
            boolean allInCache = true;
            for (Object e : c) {
                if (e instanceof ILiteral) {
                    if (this.containsWithoutCache(e)) continue;
                    return false;
                }
                if (cache.contains(e)) continue;
                allInCache = false;
                break;
            }
            if (allInCache || this.isCacheComplete(cache)) {
                return allInCache;
            }
        }
        for (Object element : c) {
            if (this.containsWithoutCache(element)) continue;
            return false;
        }
        return true;
    }

    protected Collection<Class<?>> findConcepts(URI rdfType) {
        Collection roles = this.manager.rolesForType(rdfType);
        return WrappedIterator.create(roles.iterator()).filterKeep(new Filter<Class<?>>(){

            public boolean accept(Class<?> o) {
                return o.isInterface();
            }
        }).toList();
    }

    protected Object convertInstance(Object instance) {
        Collection<Class<?>> roles;
        if (!(this.rdfValueType == null || instance instanceof IReference || instance instanceof IReferenceable || (roles = this.findConcepts(this.rdfValueType)).isEmpty())) {
            boolean hasValidType = true;
            for (Class<?> role : roles) {
                if (role.isAssignableFrom(instance.getClass())) continue;
                hasValidType = false;
                break;
            }
            if (!hasValidType) {
                IEntity newEntity = this.manager.create(new IReference[]{this.rdfValueType});
                if (newEntity instanceof Mergeable) {
                    try {
                        ((Mergeable)newEntity).merge(instance);
                    }
                    catch (Exception e) {
                        throw new KommaException((Throwable)e);
                    }
                }
                return newEntity;
            }
        }
        return instance;
    }

    protected IExtendedIterator<E> evaluateQueryForTypes(IQuery<?> query) {
        Collection<Class<?>> roles;
        if (this.rdfValueType != null && !(roles = this.findConcepts(this.rdfValueType)).isEmpty()) {
            Iterator<Class<?>> it = roles.iterator();
            Class<?> role1 = it.next();
            it.remove();
            return query.evaluate(role1, roles.toArray(new Class[0]));
        }
        if (this.valueType != null) {
            return query.evaluate(this.valueType, new Class[0]);
        }
        return query.evaluate();
    }

    protected IQuery<?> createElementsQuery(String query, String filterPattern, int limit) {
        boolean useFilter;
        boolean bl = useFilter = filterPattern != null && !filterPattern.isEmpty();
        if (useFilter || limit != Integer.MAX_VALUE) {
            StringBuilder querySb = new StringBuilder(query);
            if (useFilter) {
                querySb.insert(query.lastIndexOf(125), " FILTER regex(str(?o), ?filter, \"i\")");
            }
            if (limit != Integer.MAX_VALUE) {
                querySb.append(" LIMIT " + limit);
            }
            query = querySb.toString();
        }
        IQuery result = (IQuery)((IQuery)this.manager.createQuery(query).setParameter("s", (Object)this.subject)).setParameter("p", (Object)this.property);
        if (useFilter) {
            result.setParameter("filter", (Object)(".*" + filterPattern + ".*"));
        }
        return result;
    }

    protected IExtendedIterator<E> createElementsIterator() {
        return this.createElementsIterator(null, Integer.MAX_VALUE);
    }

    protected IExtendedIterator<E> createElementsIterator(final String filterPattern, final int limit) {
        IQuery<?> query = this.createElementsQuery(QUERY, filterPattern, limit);
        return new ConvertingIterator<E, E>((Iterator)this.evaluateQueryForTypes(query)){
            private List<E> list;
            private E current;
            {
                super(x0);
                this.list = filterPattern == null && limit == Integer.MAX_VALUE ? new ArrayList(Math.min(10, KommaPropertySet.this.getCacheLimit())) : null;
            }

            public void close() {
                if (!(this.list == null || this.hasNext() && this.list.size() != KommaPropertySet.this.getCacheLimit())) {
                    KommaPropertySet.this.setCache(this.list);
                }
                try {
                    super.close();
                }
                catch (KommaException e) {
                    throw new PropertyException((Throwable)e);
                }
            }

            protected E convert(E value) {
                if (this.list != null && this.list.size() < KommaPropertySet.this.getCacheLimit()) {
                    this.list.add(value);
                }
                return value;
            }

            public boolean hasNext() {
                try {
                    return super.hasNext();
                }
                catch (KommaException e) {
                    throw new PropertyException((Throwable)e);
                }
            }

            public E next() {
                try {
                    this.current = super.next();
                    return this.current;
                }
                catch (KommaException e) {
                    throw new PropertyException((Throwable)e);
                }
            }

            public void remove() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                KommaPropertySet.this.remove(this.current);
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KommaPropertySet other = (KommaPropertySet)obj;
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.manager == null ? other.manager != null : !this.manager.equals(other.manager)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public Set<E> getAll() {
        return this;
    }

    protected final List<E> getCache() {
        return this.cache;
    }

    protected int getCacheLimit() {
        return 10;
    }

    public Class<E> getElementType() {
        return this.valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public E getSingle() {
        List<E> cache = this.getCache();
        if (cache != null) {
            if (!cache.isEmpty()) return cache.get(0);
            if (this.valueType == null) return null;
            if (!this.valueType.isPrimitive()) return null;
            return (E)ConversionUtil.convertValue(this.valueType, 0, null);
        }
        try (IExtendedIterator<E> iter = this.createElementsIterator();){
            if (iter.hasNext()) {
                Object object = iter.next();
                return (E)object;
            }
            E e = null;
            return e;
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.manager == null ? 0 : this.manager.hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    public void init(Collection<? extends E> values) {
        if (this.getCache() == null) {
            this.setCache(new ArrayList<E>(values));
        }
    }

    private boolean isCacheComplete(List<E> cache) {
        return cache != null && cache.size() < this.getCacheLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        List<E> cache = this.getCache();
        if (cache != null) {
            return cache.isEmpty();
        }
        try (IExtendedIterator<E> iter = this.createElementsIterator();){
            boolean bl = !iter.hasNext();
            return bl;
        }
    }

    @Override
    public IExtendedIterator<E> iterator() {
        List<E> cache = this.getCache();
        if (this.isCacheComplete(cache)) {
            final Iterator<E> iter = cache.iterator();
            return new NiceIterator<E>(){
                private E e;

                public boolean hasNext() {
                    return iter.hasNext();
                }

                public E next() {
                    this.e = iter.next();
                    return this.e;
                }

                public void remove() {
                    KommaPropertySet.this.remove(this.e);
                }
            };
        }
        try {
            return this.createElementsIterator();
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
    }

    public void refresh() {
        this.setCache(null);
    }

    protected void refresh(Object o) {
        this.manager.refresh(o);
    }

    protected void refreshCache() {
        List<E> cache = this.getCache();
        if (cache != null) {
            for (E e : cache) {
                this.refresh(e);
            }
        }
    }

    @Override
    public boolean remove(Object o) {
        this.refresh();
        this.manager.remove((Iterable)new Statement(this.subject, this.property, this.convertInstance(o)));
        this.refresh(o);
        this.refreshOwners();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        try {
            ITransaction transaction = this.manager.getTransaction();
            boolean active = transaction.isActive();
            if (!active) {
                transaction.begin();
            }
            try {
                for (Object o : c) {
                    if (!this.remove(o)) continue;
                    modified = true;
                }
                if (!active) {
                    transaction.commit();
                }
            }
            finally {
                if (!active && transaction.isActive()) {
                    transaction.rollback();
                }
            }
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
        this.refreshCache();
        this.refreshOwners();
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.refresh();
        boolean modified = false;
        try {
            ITransaction transaction = this.manager.getTransaction();
            boolean active = transaction.isActive();
            if (!active) {
                transaction.begin();
            }
            try {
                try (IExtendedIterator<E> e = this.createElementsIterator();){
                    while (e.hasNext()) {
                        if (c.contains(e.next())) continue;
                        this.remove(e);
                        modified = true;
                    }
                }
                if (!active) {
                    transaction.commit();
                }
            }
            finally {
                if (!active && transaction.isActive()) {
                    transaction.rollback();
                }
            }
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
        this.refreshCache();
        this.refreshOwners();
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAll(Set<E> set) {
        if (this == set) {
            return;
        }
        if (set == null) {
            this.clear();
            return;
        }
        HashSet<E> c = new HashSet<E>(set);
        ITransaction transaction = this.manager.getTransaction();
        try {
            boolean active = transaction.isActive();
            if (!active) {
                transaction.begin();
            }
            try {
                List<E> cache = this.getCache();
                if (cache == null || !cache.isEmpty()) {
                    this.clear();
                }
                this.addAll(c);
                if (!active) {
                    transaction.commit();
                }
            }
            finally {
                if (!active && transaction.isActive()) {
                    transaction.rollback();
                }
            }
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
        this.refreshCache();
    }

    protected void setCache(List<E> cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSingle(E o) {
        if (o == null) {
            this.clear();
        } else {
            ITransaction transaction = this.manager.getTransaction();
            try {
                boolean active = transaction.isActive();
                if (!active) {
                    transaction.begin();
                }
                try {
                    List<E> cache = this.getCache();
                    if (cache == null || !cache.isEmpty()) {
                        this.clear();
                    }
                    this.add(o);
                    if (!active) {
                        transaction.commit();
                    }
                }
                finally {
                    if (!active && transaction.isActive()) {
                        transaction.rollback();
                    }
                }
            }
            catch (KommaException e) {
                throw new PropertyException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<E> cache = this.getCache();
        if (this.isCacheComplete(cache)) {
            return cache.size();
        }
        try (IExtendedIterator values = ((IQuery)((IQuery)this.manager.createQuery(QUERY).setParameter("s", (Object)this.subject)).setParameter("p", (Object)this.property)).evaluateRestricted(IReference.class, new Class[0]);){
            int size = 0;
            while (values.hasNext()) {
                values.next();
                ++size;
            }
            int n = size;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        List<E> cache = this.getCache();
        if (this.isCacheComplete(cache)) {
            return cache.toArray();
        }
        try (IExtendedIterator<E> iter = this.createElementsIterator();){
            Object[] objectArray = iter.toList().toArray();
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        List<E> cache = this.getCache();
        if (this.isCacheComplete(cache)) {
            return cache.toArray(a);
        }
        try (IExtendedIterator<E> iter = this.createElementsIterator();){
            T[] TArray = iter.toList().toArray(a);
            return TArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<E> cache = this.getCache();
        StringBuilder sb = new StringBuilder();
        Iterator<E> iter = this.isCacheComplete(cache) ? cache.iterator() : this.createElementsIterator();
        try {
            if (iter.hasNext()) {
                sb.append(iter.next().toString());
            }
            while (iter.hasNext()) {
                sb.append(", ");
                sb.append(iter.next());
            }
        }
        finally {
            if (iter instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iter)).close();
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    public Iterator<E> filter(String pattern, int limit) {
        return this.createElementsIterator(pattern, limit);
    }

    public Iterator<E> filter(String pattern) {
        return this.filter(pattern, Integer.MAX_VALUE);
    }
}

