/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties.komma;

import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import net.enilink.composition.properties.PropertySet;
import net.enilink.composition.properties.PropertySetFactory;
import net.enilink.composition.properties.annotations.Localized;
import net.enilink.composition.properties.annotations.Type;
import net.enilink.composition.properties.komma.KommaPropertySet;
import net.enilink.composition.properties.komma.LocalizedKommaPropertySet;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IReferenceable;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;

public class KommaPropertySetFactory
implements PropertySetFactory {
    final ConcurrentMap<Key, PropertySet<?>> propertySetCache = new MapMaker().weakValues().makeMap();
    @Inject
    protected Injector injector;

    public <E> PropertySet<E> createPropertySet(Object bean, String uri, Class<E> elementType, Annotation ... annotations) {
        Key cacheKey = new Key(((IReferenceable)bean).getReference(), uri, elementType);
        return this.propertySetCache.computeIfAbsent(cacheKey, k -> {
            URI predicate = URIs.createURI((String)uri);
            URI rdfValueType = null;
            boolean localized = false;
            for (Annotation annotation : annotations) {
                if (Localized.class.equals(annotation.annotationType())) {
                    localized = true;
                    continue;
                }
                if (!Type.class.equals(annotation.annotationType())) continue;
                rdfValueType = URIs.createURI((String)((Type)annotation).value());
            }
            KommaPropertySet propertySet = localized ? new LocalizedKommaPropertySet((IReference)bean, (IReference)predicate) : new KommaPropertySet((IReference)bean, (IReference)predicate, elementType, rdfValueType);
            this.injector.injectMembers((Object)propertySet);
            return propertySet;
        });
    }

    public ConcurrentMap<Key, PropertySet<?>> getPropertySetCache() {
        return this.propertySetCache;
    }

    static class Key {
        IReference subject;
        String uri;
        Class<?> elementType;

        Key(IReference subject, String uri, Class<?> elementType) {
            this.subject = subject;
            this.uri = uri;
            this.elementType = elementType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
            result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.elementType == null ? other.elementType != null : !this.elementType.equals(other.elementType)) {
                return false;
            }
            if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
                return false;
            }
            return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
        }

        public String toString() {
            return this.getClass().getSimpleName() + Arrays.asList(this.subject, this.uri, this.elementType).toString();
        }
    }
}

