/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties.komma;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.enilink.commons.iterator.ConvertingIterator;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.composition.properties.exceptions.PropertyException;
import net.enilink.composition.properties.komma.KommaPropertySet;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.KommaException;

public class LocalizedKommaPropertySet
extends KommaPropertySet<String> {
    @Inject
    ILiteralFactory lf;
    Map<String, List<ILiteral>> cache;

    public LocalizedKommaPropertySet(IReference subject, IReference property) {
        super(subject, property, String.class, null);
    }

    private int addBestValues(ILiteral literal, String language, int best, Collection<ILiteral> values) {
        int score = best;
        String l = literal.getLanguage();
        if (language == l || language != null && language.equals(l)) {
            if (score < Integer.MAX_VALUE) {
                values.clear();
            }
            values.add(literal);
            score = Integer.MAX_VALUE;
        } else if (l != null && language != null && language.startsWith(l)) {
            if (score < l.length()) {
                values.clear();
            }
            values.add(literal);
            score = l.length();
        } else if (l != null && language != null && score <= 1 && l.length() > 2 && language.startsWith(l.substring(0, 2))) {
            if (score < 1) {
                values.clear();
            }
            values.add(literal);
            score = 1;
        } else if (l != null && l.startsWith("en") && score <= 1) {
            if (score < 1) {
                values.clear();
            }
            values.add(literal);
            score = 1;
        } else if (l == null) {
            if (score < 0) {
                values.clear();
            }
            values.add(literal);
            score = 0;
        } else if (score < 0) {
            values.add(literal);
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ILiteral> bestValues() {
        List<ILiteral> values;
        String language = this.manager.getLocale().getLanguage();
        List<ILiteral> list = values = this.cache != null ? this.cache.get(language) : null;
        if (values != null) {
            return values;
        }
        int score = -1;
        values = new ArrayList<ILiteral>();
        try (IExtendedIterator literals = ((IQuery)((IQuery)this.manager.createQuery("SELECT DISTINCT ?o WHERE { ?s ?p ?o }").setParameter("s", (Object)this.subject)).setParameter("p", (Object)this.property)).evaluateRestricted(ILiteral.class, new Class[0]);){
            for (ILiteral literal : literals) {
                score = this.addBestValues(literal, language, score, values);
            }
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
        if (this.cache == null) {
            this.cache = Collections.synchronizedMap(new HashMap());
        }
        this.cache.put(language, values);
        return values;
    }

    @Override
    public void clear() {
        ITransaction transaction = this.manager.getTransaction();
        try {
            boolean active = transaction.isActive();
            if (!active) {
                transaction.begin();
            }
            for (ILiteral literal : this.bestValues()) {
                this.remove(literal);
            }
            if (!active) {
                transaction.commit();
            }
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
    }

    protected ILiteral convertInstance(Object instance) {
        if (instance instanceof ILiteral) {
            return (ILiteral)instance;
        }
        String language = this.manager.getLocale().getLanguage();
        return this.lf.createLiteral(instance.toString(), null, language);
    }

    @Override
    public String getSingle() {
        Iterator<ILiteral> iter = this.bestValues().iterator();
        if (iter.hasNext()) {
            return iter.next().getLabel();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.bestValues().isEmpty();
    }

    @Override
    public IExtendedIterator<String> iterator() {
        return new ConvertingIterator<ILiteral, String>(this.bestValues().iterator()){
            ILiteral current;

            protected String convert(ILiteral value) {
                this.current = value;
                return value.getLabel();
            }

            public void remove() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                LocalizedKommaPropertySet.this.remove(this.current);
            }
        };
    }

    @Override
    public void refresh() {
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAll(Set<String> set) {
        if (this == set) {
            return;
        }
        HashSet<String> c = new HashSet<String>(set);
        ITransaction transaction = this.manager.getTransaction();
        try {
            boolean active = transaction.isActive();
            if (!active) {
                transaction.begin();
            }
            String language = this.manager.getLocale().getLanguage();
            try (IExtendedIterator literals = ((IQuery)((IQuery)this.manager.createQuery("SELECT DISTINCT ?o WHERE { ?s ?p ?o }").setParameter("s", (Object)this.subject)).setParameter("p", (Object)this.property)).evaluateRestricted(ILiteral.class, new Class[0]);){
                for (ILiteral literal : literals) {
                    String l = literal.getLanguage();
                    if (language != l && (language == null || !language.equals(l))) continue;
                    String label = literal.getLabel();
                    if (c.contains(label)) {
                        c.remove(label);
                        continue;
                    }
                    this.remove(literal);
                }
            }
            if (c.size() > 0) {
                this.addAll(c);
            }
            if (!active) {
                transaction.commit();
            }
        }
        catch (KommaException e) {
            throw new PropertyException((Throwable)e);
        }
    }

    @Override
    public void setSingle(String o) {
        if (o == null) {
            this.clear();
        } else {
            this.setAll(Collections.singleton(o));
        }
    }

    @Override
    public int size() {
        return this.bestValues().size();
    }

    @Override
    public Object[] toArray() {
        return this.bestValues().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.bestValues().toArray(a);
    }
}

