/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties.sparql;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.composition.asm.util.BehaviourMethodGenerator;
import net.enilink.composition.exceptions.ConfigException;
import net.enilink.composition.properties.PropertyMapper;
import net.enilink.composition.properties.annotations.Name;
import net.enilink.composition.properties.sparql.SparqlBehaviourMethodProcessor;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IStatement;
import org.objectweb.asm.Label;

public class SPARQLQueryOptimizer {
    private static final Pattern selectWhere = Pattern.compile("\\sSELECT\\s+([\\?\\$]\\w+)\\s+WHERE\\s*\\{", 34);
    private static final org.objectweb.asm.Type IGRAPH_TYPE = org.objectweb.asm.Type.getType(IGraph.class);
    private static final org.objectweb.asm.Type ISTATEMENT_TYPE = org.objectweb.asm.Type.getType(IStatement.class);
    private static final org.objectweb.asm.Type OBJECT_ARRAY_TYPE = org.objectweb.asm.Type.getType(Object[].class);

    public void implementQuery(String sparql, String base, PropertyMapper pm, Method method, BehaviourMethodGenerator gen) throws Exception {
        Class range = method.getReturnType();
        boolean primitive = range.isPrimitive();
        boolean functional = !range.equals(Set.class);
        Map eager = null;
        if (functional && !primitive) {
            eager = pm.findEagerProperties(range);
        } else if (!primitive) {
            Type c;
            range = Object.class;
            Type t = method.getGenericReturnType();
            if (t instanceof ParameterizedType && (c = ((ParameterizedType)t).getActualTypeArguments()[0]) instanceof Class) {
                range = (Class)c;
                eager = pm.findEagerProperties((Class)c);
            }
        }
        this.implementQuery(sparql, base, eager, range, functional, method, gen);
    }

    protected void setParameters(Method method, BehaviourMethodGenerator gen) throws Exception {
        int params = method.getParameterTypes().length;
        for (int i = 0; i < params; ++i) {
            boolean named = false;
            for (Annotation ann : method.getParameterAnnotations()[i]) {
                if (!ann.annotationType().equals(Name.class)) continue;
                for (String name : ((Name)ann).value()) {
                    named = true;
                    gen.dup();
                    gen.push(name);
                    gen.loadArg(i);
                    gen.invoke(IQuery.class.getMethod("setParameter", String.class, Object.class));
                }
            }
            if (named) continue;
            throw new ConfigException("@name annotation not found: " + method.getName());
        }
    }

    public void implementQuery(String qry, String base, Map<String, String> eager, Class<?> range, boolean functional, Method method, BehaviourMethodGenerator gen) throws Exception {
        this.prepareQuery(qry, base, range, eager, gen);
        this.setParameters(method, gen);
        this.evaluateQuery(range, functional, gen);
    }

    private void prepareQuery(String qry, String base, Class<?> range, Map<String, String> eager, BehaviourMethodGenerator gen) throws Exception {
        Method prepareMethod = IEntityManager.class.getMethod("createQuery", String.class, String.class);
        org.objectweb.asm.Type rangeType = org.objectweb.asm.Type.getType(range);
        boolean objectQuery = !IGRAPH_TYPE.equals((Object)rangeType) && !ISTATEMENT_TYPE.equals((Object)rangeType) && !OBJECT_ARRAY_TYPE.equals((Object)rangeType);
        gen.loadThis();
        gen.invokeVirtual(gen.getMethod().getOwner().getType(), SparqlBehaviourMethodProcessor.GET_MANAGER);
        if (objectQuery) {
            gen.push(this.optimizeQueryString(qry, eager));
        } else {
            gen.push(qry);
        }
        gen.push(base);
        gen.invoke(prepareMethod);
        gen.dup();
        gen.push("this");
        gen.loadBean();
        gen.invoke(IQuery.class.getMethod("setParameter", String.class, Object.class));
    }

    private String optimizeQueryString(String sparql, Map<String, String> map) {
        Matcher matcher = selectWhere.matcher(sparql);
        if (map != null && matcher.find()) {
            String var = matcher.group(1);
            int idx = sparql.lastIndexOf(125);
            StringBuilder sb = new StringBuilder(256 + sparql.length());
            sb.append(sparql, 0, matcher.start(1));
            sb.append(var).append(" ");
            sb.append(var).append("_class").append(" ");
            for (Map.Entry<String, String> e : map.entrySet()) {
                String name = e.getKey();
                if (name.equals("class")) continue;
                sb.append(var).append("_").append(name).append(" ");
            }
            sb.append(sparql, matcher.end(1), idx);
            sb.append(" OPTIONAL { ").append(var);
            sb.append(" a ").append(var).append("_class}");
            for (Map.Entry<String, String> e : map.entrySet()) {
                String pred = e.getValue();
                String name = e.getKey();
                if (name.equals("class")) continue;
                sb.append(" OPTIONAL { ").append(var).append(" <");
                sb.append(pred).append("> ");
                sb.append(var).append("_").append(name).append("}");
            }
            sb.append(sparql, idx, sparql.length());
            sparql = sb.toString();
        }
        return sparql;
    }

    private void evaluateQuery(Class<?> range, boolean functional, BehaviourMethodGenerator gen) throws Exception {
        Label tryLabel = gen.mark();
        int result = gen.newLocal(org.objectweb.asm.Type.getType(IExtendedIterator.class));
        org.objectweb.asm.Type rangeType = org.objectweb.asm.Type.getType(range);
        if (IGRAPH_TYPE.equals((Object)rangeType) || ISTATEMENT_TYPE.equals((Object)rangeType)) {
            gen.push(ISTATEMENT_TYPE);
            gen.push(0);
            gen.newArray(org.objectweb.asm.Type.getType(Class.class));
            gen.invoke(IQuery.class.getMethod("evaluate", Class.class, Class[].class));
        } else {
            gen.invoke(IQuery.class.getMethod("evaluate", new Class[0]));
        }
        gen.storeLocal(result);
        gen.loadLocal(result);
        gen.invoke(Iterator.class.getMethod("hasNext", new Class[0]));
        Label noNext = gen.newLabel();
        gen.ifZCmp(153, noNext);
        gen.loadLocal(result);
        gen.invoke(Iterator.class.getMethod("next", new Class[0]));
        gen.mark(noNext);
        gen.push((String)null);
        Label noException = gen.newLabel();
        gen.goTo(noException);
        Label catchLabel = gen.mark();
        org.objectweb.asm.Type runtimeException = org.objectweb.asm.Type.getType(Throwable.class);
        gen.catchException(tryLabel, catchLabel, runtimeException);
        gen.loadLocal(result);
        gen.invoke(IExtendedIterator.class.getMethod("close", new Class[0]));
        gen.throwException();
        gen.mark(noException);
        gen.loadLocal(result);
        gen.invoke(IExtendedIterator.class.getMethod("close", new Class[0]));
        gen.returnValue();
    }
}

