/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.composition.properties.behaviours;

import com.google.inject.Inject;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.asm.BehaviourClassNode;
import net.enilink.composition.asm.BehaviourClassProcessor;
import net.enilink.composition.asm.ExtendedClassNode;
import net.enilink.composition.asm.ExtendedMethod;
import net.enilink.composition.asm.Types;
import net.enilink.composition.asm.util.BehaviourMethodGenerator;
import net.enilink.composition.properties.PropertyMapper;
import net.enilink.composition.properties.PropertySet;
import net.enilink.composition.properties.PropertySetFactory;
import net.enilink.composition.properties.behaviours.Methods;
import net.enilink.composition.properties.traits.Mergeable;
import net.enilink.composition.properties.traits.PropertySetOwner;
import net.enilink.composition.properties.traits.Refreshable;
import net.enilink.composition.properties.util.UnmodifiablePropertySet;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.FieldNode;

public class PropertyMapperProcessor
implements BehaviourClassProcessor,
Opcodes,
Types {
    private static final String FACTORY_FIELD = "_$propertySetFactory";
    private static final String PROPERTY_SUFFIX = "Property";
    @Inject
    protected ClassDefiner definer;
    protected PropertyMapper propertyMapper;

    private void addPropertySetFactoryField(BehaviourClassNode node) {
        FieldNode factoryField = new FieldNode(2, this.getFactoryField(), org.objectweb.asm.Type.getDescriptor(PropertySetFactory.class), null, null);
        factoryField.visitAnnotation(org.objectweb.asm.Type.getDescriptor(Inject.class), true);
        node.addField(factoryField);
    }

    private String getFactoryField() {
        return FACTORY_FIELD;
    }

    private String getPropertyFieldName(String property) {
        return "_$" + property + PROPERTY_SUFFIX;
    }

    private Collection<FieldNode> getPropertySetFields(BehaviourClassNode node) {
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        for (Object field : node.fields) {
            if (!((FieldNode)field).name.endsWith(PROPERTY_SUFFIX)) continue;
            fields.add((FieldNode)field);
        }
        return fields;
    }

    private void loadPropertySet(PropertyDescriptor pd, BehaviourMethodGenerator gen) {
        this.loadPropertySet(pd, gen, false);
    }

    private void loadPropertySet(PropertyDescriptor pd, BehaviourMethodGenerator gen, boolean forceModifiable) {
        gen.loadThis();
        gen.invokeVirtual(gen.getMethod().getOwner().getType(), new Method("_$get" + pd.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(PropertySet.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0])));
        if (forceModifiable) {
            gen.dup();
            gen.instanceOf(org.objectweb.asm.Type.getType(UnmodifiablePropertySet.class));
            Label notInstanceOf = gen.newLabel();
            gen.ifZCmp(153, notInstanceOf);
            gen.checkCast(org.objectweb.asm.Type.getType(UnmodifiablePropertySet.class));
            gen.invoke(Methods.UNMODIFIABLEPROPERTYSET_GET_DELEGATE);
            gen.mark(notInstanceOf);
        }
    }

    private void createPropertySetAccessor(PropertyDescriptor pd, BehaviourClassNode node) throws Exception {
        String fieldName = this.getPropertyFieldName(pd.getName());
        FieldNode propertyField = new FieldNode(2, fieldName, org.objectweb.asm.Type.getDescriptor(PropertySet.class), null, null);
        node.addField(propertyField);
        ExtendedMethod propertyAccessor = new ExtendedMethod((ExtendedClassNode)node, 2, "_$get" + pd.getName(), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(PropertySet.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), null, null);
        node.methods.add(propertyAccessor);
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(propertyAccessor);
        this.lazyInitializePropertySet(pd, node, propertyField, gen);
        gen.returnValue();
        gen.endMethod();
    }

    private void lazyInitializePropertySet(PropertyDescriptor pd, BehaviourClassNode node, FieldNode field, BehaviourMethodGenerator gen) throws Exception {
        ParameterizedType pt;
        Type[] args;
        Type t;
        gen.loadThis();
        gen.getField(field.name, org.objectweb.asm.Type.getType((String)field.desc));
        gen.dup();
        Label exists = gen.newLabel();
        gen.ifNonNull(exists);
        gen.pop();
        java.lang.reflect.Method getter = pd.getReadMethod();
        java.lang.reflect.Method setter = pd.getWriteMethod();
        this.loadFactory(node, gen);
        gen.loadBean();
        gen.push(this.propertyMapper.findPredicate(pd));
        Class propertyType = pd.getPropertyType();
        if (Set.class.equals(propertyType) && (t = pd.getReadMethod().getGenericReturnType()) instanceof ParameterizedType && (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length == 1 && args[0] instanceof Class) {
            propertyType = (Class)args[0];
        }
        gen.push(org.objectweb.asm.Type.getType(propertyType));
        org.objectweb.asm.Type propertyDescType = org.objectweb.asm.Type.getType(PropertyDescriptor.class);
        gen.newInstance(propertyDescType);
        gen.dup();
        gen.push(pd.getName());
        this.loadMethodObject(org.objectweb.asm.Type.getType(getter.getDeclaringClass()), getter.getName(), org.objectweb.asm.Type.getReturnType((java.lang.reflect.Method)getter), org.objectweb.asm.Type.getArgumentTypes((java.lang.reflect.Method)getter), gen);
        if (setter == null) {
            gen.push((String)null);
        } else {
            this.loadMethodObject(org.objectweb.asm.Type.getType(setter.getDeclaringClass()), setter.getName(), org.objectweb.asm.Type.getReturnType((java.lang.reflect.Method)setter), org.objectweb.asm.Type.getArgumentTypes((java.lang.reflect.Method)setter), gen);
        }
        gen.invokeConstructor(propertyDescType, new Method("<init>", org.objectweb.asm.Type.VOID_TYPE, new org.objectweb.asm.Type[]{STRING_TYPE, METHOD_TYPE, METHOD_TYPE}));
        gen.invokeVirtual(propertyDescType, new Method("getReadMethod", METHOD_TYPE, new org.objectweb.asm.Type[0]));
        gen.invokeVirtual(METHOD_TYPE, new Method("getAnnotations", org.objectweb.asm.Type.getType(Annotation[].class), new org.objectweb.asm.Type[0]));
        gen.invoke(Methods.PROPERTYSETFACTORY_CREATEPROPERTYSET);
        if (setter == null) {
            gen.invoke(Methods.PROPERTYSETS_UNMODIFIABLE);
        }
        gen.dup();
        gen.loadThis();
        gen.swap();
        gen.putField(field.name, org.objectweb.asm.Type.getType((String)field.desc));
        gen.mark(exists);
    }

    private void loadMethodObject(org.objectweb.asm.Type declaringClass, String name, org.objectweb.asm.Type returnType, org.objectweb.asm.Type[] paramTypes, BehaviourMethodGenerator gen) {
        gen.push(declaringClass);
        gen.push(name);
        gen.loadArray(paramTypes);
        gen.invokeVirtual(org.objectweb.asm.Type.getType(Class.class), new Method("getDeclaredMethod", org.objectweb.asm.Type.getType(java.lang.reflect.Method.class), new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(String.class), org.objectweb.asm.Type.getType(Class[].class)}));
    }

    private void implementGetter(PropertyDescriptor pd, BehaviourClassNode node) throws Exception {
        Class<?> classType = pd.getReadMethod().getReturnType();
        org.objectweb.asm.Type type = org.objectweb.asm.Type.getType(classType);
        ExtendedMethod mn = node.addExtendedMethod(pd.getReadMethod(), this.definer);
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(mn);
        this.loadPropertySet(pd, gen);
        if (this.isCollection(classType)) {
            gen.invoke(Methods.PROPERTYSET_GET_ALL);
            gen.returnValue();
        } else if (classType.isPrimitive()) {
            gen.invoke(Methods.PROPERTYSET_GET_SINGLE);
            gen.dup();
            Label isNull = gen.newLabel();
            gen.ifNull(isNull);
            gen.unbox(type);
            gen.returnValue();
            gen.mark(isNull);
            gen.pop();
            gen.push(0);
            gen.cast(org.objectweb.asm.Type.INT_TYPE, type);
            gen.returnValue();
        } else {
            Label tryLabel = gen.mark();
            gen.invoke(Methods.PROPERTYSET_GET_SINGLE);
            gen.checkCast(type);
            gen.returnValue();
            Label catchLabel = gen.mark();
            org.objectweb.asm.Type exceptionType = org.objectweb.asm.Type.getType(ClassCastException.class);
            gen.catchException(tryLabel, catchLabel, exceptionType);
            gen.newInstance(exceptionType);
            gen.dup();
            gen.newStringBuilder();
            this.loadPropertySet(pd, gen);
            gen.invoke(Methods.PROPERTYSET_GET_SINGLE);
            gen.invokeToString();
            gen.appendToStringBuilder();
            gen.push("cannot be cast to " + classType.getName());
            gen.appendToStringBuilder();
            gen.invokeToString();
            gen.invokeConstructor(exceptionType, Method.getMethod((String)"void <init>(String)"));
            gen.throwException();
        }
        gen.endMethod();
    }

    private void implementProperty(PropertyDescriptor pd, BehaviourClassNode node) throws Exception {
        this.createPropertySetAccessor(pd, node);
        this.implementGetter(pd, node);
        java.lang.reflect.Method setter = pd.getWriteMethod();
        if (setter != null) {
            this.implementSetter(pd, node);
        }
    }

    public boolean implementsClass(Class<?> concept) {
        return !this.propertyMapper.findProperties(concept).isEmpty();
    }

    private void implementSetter(PropertyDescriptor pd, BehaviourClassNode node) throws Exception {
        Class<?> classType = pd.getWriteMethod().getParameterTypes()[0];
        org.objectweb.asm.Type type = org.objectweb.asm.Type.getType(classType);
        ExtendedMethod mn = node.addExtendedMethod(pd.getWriteMethod(), this.definer);
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(mn);
        this.loadPropertySet(pd, gen);
        gen.loadArgs();
        if (this.isCollection(classType)) {
            gen.invoke(Methods.PROPERTYSET_SET_ALL);
        } else {
            gen.box(type);
            gen.invoke(Methods.PROPERTYSET_SET_SINGLE);
        }
        Class<?> clazz = mn.getOverriddenMethod().getDeclaringClass();
        if (mn.getOverriddenMethod().getReturnType().isAssignableFrom(clazz)) {
            if (clazz.isInterface()) {
                gen.loadBean();
            } else {
                gen.loadThis();
            }
        }
        gen.returnValue();
        gen.endMethod();
    }

    private boolean isCollection(Class<?> type) throws Exception {
        return Set.class.equals(type);
    }

    private void loadFactory(BehaviourClassNode node, BehaviourMethodGenerator gen) {
        gen.loadThis();
        gen.getField(this.getFactoryField(), org.objectweb.asm.Type.getType(PropertySetFactory.class));
    }

    private void mergeProperty(PropertyDescriptor pd, BehaviourMethodGenerator gen) throws Exception {
        Class<?> type = pd.getPropertyType();
        if (type.isPrimitive()) {
            this.loadPropertySet(pd, gen, true);
            if (org.objectweb.asm.Type.getType(type).getSize() == 1) {
                gen.swap();
            } else {
                gen.dupX2();
                gen.pop();
            }
            this.persistValue(type, gen);
        } else {
            gen.dup();
            Label isNull = gen.newLabel();
            gen.ifNull(isNull);
            this.loadPropertySet(pd, gen, true);
            gen.swap();
            this.persistValue(type, gen);
            Label end = gen.newLabel();
            gen.goTo(end);
            gen.mark(isNull);
            gen.pop();
            gen.mark(end);
        }
    }

    private void overrideMergeMethod(BehaviourClassNode node) throws Exception {
        java.lang.reflect.Method merge = Mergeable.class.getMethod("merge", Object.class);
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(node.addExtendedMethod(merge, this.definer));
        this.invokeSuper(gen, merge);
        gen.loadArg(0);
        gen.instanceOf(node.getParentType());
        Label notInstanceOf = gen.newLabel();
        gen.ifZCmp(153, notInstanceOf);
        for (PropertyDescriptor pd : this.propertyMapper.findProperties(node.getParentClass())) {
            gen.loadArg(0);
            gen.checkCast(org.objectweb.asm.Type.getType(pd.getReadMethod().getDeclaringClass()));
            gen.invoke(pd.getReadMethod());
            this.mergeProperty(pd, gen);
        }
        Label end = gen.newLabel();
        gen.goTo(end);
        gen.mark(notInstanceOf);
        gen.loadArg(0);
        gen.instanceOf(org.objectweb.asm.Type.getType(PropertySetOwner.class));
        gen.ifZCmp(153, end);
        java.lang.reflect.Method getPropertySet = PropertySetOwner.class.getMethod("getPropertySet", String.class);
        for (PropertyDescriptor pd : this.propertyMapper.findProperties(node.getParentClass())) {
            gen.loadArg(0);
            gen.push(this.propertyMapper.findPredicate(pd));
            gen.invoke(getPropertySet);
            gen.dup();
            Label isNull = gen.newLabel();
            gen.ifNull(isNull);
            this.loadPropertySet(pd, gen, true);
            gen.swap();
            gen.invoke(Methods.PROPERTYSET_GET_ALL);
            gen.invoke(Methods.PROPERTYSET_ADD_ALL);
            gen.pop();
            Label endLoop = gen.newLabel();
            gen.goTo(endLoop);
            gen.mark(isNull);
            gen.pop();
            gen.mark(endLoop);
        }
        gen.mark(end);
        gen.returnValue();
        gen.endMethod();
    }

    private void overrideRefreshMethod(BehaviourClassNode node) throws Exception {
        java.lang.reflect.Method refresh = Refreshable.class.getMethod("refresh", new Class[0]);
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(node.addExtendedMethod(refresh, this.definer));
        this.invokeSuper(gen, refresh);
        for (FieldNode field : this.getPropertySetFields(node)) {
            gen.loadThis();
            gen.getField(field.name, org.objectweb.asm.Type.getType((String)field.desc));
            gen.dup();
            Label isNull = gen.newLabel();
            gen.ifNull(isNull);
            gen.invoke(refresh);
            Label end = gen.newLabel();
            gen.goTo(end);
            gen.mark(isNull);
            gen.pop();
            gen.mark(end);
        }
        gen.returnValue();
        gen.endMethod();
    }

    private void persistValue(Class<?> type, BehaviourMethodGenerator gen) throws Exception {
        if (this.isCollection(type)) {
            gen.invoke(Methods.PROPERTYSET_ADD_ALL);
        } else {
            gen.box(org.objectweb.asm.Type.getType(type));
            gen.invoke(Methods.PROPERTYSET_ADD_SINGLE);
        }
        gen.pop();
    }

    private void invokeSuper(BehaviourMethodGenerator gen, java.lang.reflect.Method method) {
        try {
            java.lang.reflect.Method implementedMethod = gen.getMethod().getOwner().getParentClass().getMethod(method.getName(), method.getParameterTypes());
            if ((implementedMethod.getModifiers() & 0x400) == 0) {
                gen.loadThis();
                gen.loadArgs();
                gen.invokeSpecial(gen.getMethod().getOwner().getParentType(), Method.getMethod((java.lang.reflect.Method)implementedMethod));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void overrideGetPropertySetMethod(BehaviourClassNode node, Collection<PropertyDescriptor> properties) throws Exception {
        java.lang.reflect.Method getPropertySet = PropertySetOwner.class.getMethod("getPropertySet", String.class);
        BehaviourMethodGenerator gen = new BehaviourMethodGenerator(node.addExtendedMethod(getPropertySet, this.definer));
        this.invokeSuper(gen, getPropertySet);
        Method equals = new Method("equals", org.objectweb.asm.Type.BOOLEAN_TYPE, new org.objectweb.asm.Type[]{OBJECT_TYPE});
        Label endLabel = gen.newLabel();
        for (PropertyDescriptor pd : properties) {
            Label notEqualsLabel = gen.newLabel();
            gen.push(this.propertyMapper.findPredicate(pd));
            gen.loadArg(0);
            gen.invokeVirtual(STRING_TYPE, equals);
            gen.ifZCmp(153, notEqualsLabel);
            this.loadPropertySet(pd, gen);
            gen.goTo(endLabel);
            gen.mark(notEqualsLabel);
        }
        gen.push((String)null);
        gen.mark(endLabel);
        gen.returnValue();
        gen.endMethod();
    }

    public void process(BehaviourClassNode classNode) throws Exception {
        classNode.addInterface(org.objectweb.asm.Type.getInternalName(Mergeable.class));
        classNode.addInterface(org.objectweb.asm.Type.getInternalName(Refreshable.class));
        classNode.addInterface(org.objectweb.asm.Type.getInternalName(PropertySetOwner.class));
        classNode.addInjectorField();
        this.addPropertySetFactoryField(classNode);
        Collection<PropertyDescriptor> properties = this.propertyMapper.findProperties(classNode.getParentClass());
        for (PropertyDescriptor pd : properties) {
            this.implementProperty(pd, classNode);
        }
        this.overrideMergeMethod(classNode);
        this.overrideRefreshMethod(classNode);
        this.overrideGetPropertySetMethod(classNode, properties);
    }

    @Inject
    public void setPropertyMapper(PropertyMapper mapper) {
        this.propertyMapper = mapper;
    }
}

