/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.model.extensions;

import net.enilink.komma.internal.model.extensions.KommaRegistryReader;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.ModelPlugin;
import org.eclipse.core.runtime.IConfigurationElement;

public class ContentFactoriesRegistryReader
extends KommaRegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_CONTENT_TYPE_IDENTIFIER = "contentTypeIdentifier";
    static final String ATT_CLASS = "class";
    private IModel.Factory.Registry modelFactoryRegistry;

    public ContentFactoriesRegistryReader(IModel.Factory.Registry ontologyFactoryRegistry) {
        super("net.enilink.komma.model", "contentFactories");
        this.modelFactoryRegistry = ontologyFactoryRegistry;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String contentTypeIdentifier = element.getAttribute(ATT_CONTENT_TYPE_IDENTIFIER);
            if (contentTypeIdentifier == null) {
                ContentFactoriesRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_CONTENT_TYPE_IDENTIFIER);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                ContentFactoriesRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_CLASS);
            } else {
                if (add) {
                    Object previous = this.modelFactoryRegistry.getContentTypeToFactoryMap().put(contentTypeIdentifier, new KommaRegistryReader.ModelFactoryDescriptor(element, ATT_CLASS));
                    if (previous instanceof KommaRegistryReader.ModelFactoryDescriptor) {
                        KommaRegistryReader.ModelFactoryDescriptor descriptor = (KommaRegistryReader.ModelFactoryDescriptor)previous;
                        ModelPlugin.logErrorMessage("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a content factory for '" + contentTypeIdentifier + "'");
                    }
                    return true;
                }
                this.modelFactoryRegistry.getContentTypeToFactoryMap().remove(contentTypeIdentifier);
                return true;
            }
        }
        return false;
    }
}

