/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.model.extensions;

import net.enilink.komma.internal.model.extensions.KommaRegistryReader;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.ModelPlugin;
import org.eclipse.core.runtime.IConfigurationElement;

public class ExtensionFactoriesRegistryReader
extends KommaRegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_TYPE = "type";
    static final String ATT_CLASS = "class";
    private IModel.Factory.Registry modelFactoryRegistry;

    public ExtensionFactoriesRegistryReader(IModel.Factory.Registry ontologyFactoryRegistry) {
        super("net.enilink.komma.model", "extensionFactories");
        this.modelFactoryRegistry = ontologyFactoryRegistry;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String type = element.getAttribute(ATT_TYPE);
            if (type == null) {
                ExtensionFactoriesRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_TYPE);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                ExtensionFactoriesRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_CLASS);
            } else {
                if (add) {
                    Object previous = this.modelFactoryRegistry.getExtensionToFactoryMap().put(type, new KommaRegistryReader.ModelFactoryDescriptor(element, ATT_CLASS));
                    if (previous instanceof KommaRegistryReader.ModelFactoryDescriptor) {
                        KommaRegistryReader.ModelFactoryDescriptor descriptor = (KommaRegistryReader.ModelFactoryDescriptor)previous;
                        ModelPlugin.logErrorMessage("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register an extension parser for '" + type + "'");
                    }
                    return true;
                }
                this.modelFactoryRegistry.getExtensionToFactoryMap().remove(type);
                return true;
            }
        }
        return false;
    }
}

