/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.enilink.commons.util.extensions.RegistryFactoryHelper;
import net.enilink.commons.util.extensions.RegistryReader;
import net.enilink.komma.common.AbstractKommaPlugin;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.internal.model.ModelModule;
import net.enilink.komma.internal.model.extensions.ContentFactoriesRegistryReader;
import net.enilink.komma.internal.model.extensions.ContentHandlerRegistryReader;
import net.enilink.komma.internal.model.extensions.ExtensionFactoriesRegistryReader;
import net.enilink.komma.internal.model.extensions.ProtocolFactoriesRegistryReader;
import net.enilink.komma.internal.model.extensions.URIMappingRegistryReader;
import net.enilink.komma.model.IContentHandler;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.MODELS;
import net.enilink.komma.model.ModelDescription;
import net.enilink.komma.model.base.ContentHandlerRegistry;
import net.enilink.komma.model.base.IURIMapRuleSet;
import net.enilink.komma.model.base.ModelFactoryRegistry;
import net.enilink.komma.model.base.ModelSetSupport;
import net.enilink.komma.model.base.ModelSupport;
import net.enilink.komma.model.base.URIMapRuleSet;
import net.enilink.komma.model.validation.Diagnostician;
import net.enilink.komma.model.validation.IValidator;
import net.enilink.komma.model.validation.ValidatorRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ModelPlugin
extends AbstractKommaPlugin {
    private IValidator.Registry validatorRegistry = new ValidatorRegistry();
    private IContentHandler.Registry contentHandlerRegistry = new ContentHandlerRegistry();
    private IModel.Factory.Registry modelFactoryRegistry = new ModelFactoryRegistry();
    private IURIMapRuleSet uriMap = new URIMapRuleSet();
    private List<RegistryReader> extensionReaders = Collections.emptyList();
    public static final String PLUGIN_ID = "net.enilink.komma.model";
    private static final ModelPlugin INSTANCE = new ModelPlugin();
    private Diagnostician diagnosticion;
    private static Implementation plugin;

    public ModelPlugin() {
        super(new IResourceLocator[0]);
    }

    public static ModelPlugin getDefault() {
        return INSTANCE;
    }

    public static void logErrorMessage(String message) {
        ModelPlugin.getDefault().log(new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            ModelPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(PLUGIN_ID, 10001, message, null);
        multi.add(status);
        ModelPlugin.getDefault().log(multi);
    }

    public static void log(Throwable e) {
        ModelPlugin.getDefault().log(new Status(4, PLUGIN_ID, 10001, "Internal error", e));
    }

    public IResourceLocator getBundleResourceLocator() {
        return plugin;
    }

    public IContentHandler.Registry getContentHandlerRegistry() {
        return this.contentHandlerRegistry;
    }

    public IModel.Factory.Registry getModelFactoryRegistry() {
        return this.modelFactoryRegistry;
    }

    public IURIMapRuleSet getURIMap() {
        return this.uriMap;
    }

    public IValidator.Registry getValidatorRegistry() {
        return this.validatorRegistry;
    }

    public IValidator getDefaultValidator() {
        if (this.diagnosticion == null) {
            this.diagnosticion = new Diagnostician(this.getValidatorRegistry());
        }
        return this.diagnosticion;
    }

    public static IContentTypeManager getContentTypeManager() {
        return plugin == null ? null : plugin.getContentTypeManager();
    }

    private void readExtensions() {
        IModel.Factory.Registry modelFactoryRegistry = ModelPlugin.getDefault().getModelFactoryRegistry();
        this.extensionReaders = Arrays.asList(new RegistryReader[]{new ExtensionFactoriesRegistryReader(modelFactoryRegistry), new ProtocolFactoriesRegistryReader(modelFactoryRegistry), new ContentFactoriesRegistryReader(modelFactoryRegistry), new ContentHandlerRegistryReader(ModelPlugin.getDefault().getContentHandlerRegistry()), new URIMappingRegistryReader(ModelPlugin.getDefault().getURIMap())});
        this.extensionReaders.forEach(reader -> {
            reader.readRegistry();
            reader.registerListener();
        });
    }

    public static Collection<ModelDescription> getBaseModels() {
        ArrayList<ModelDescription> descriptions = new ArrayList<ModelDescription>();
        IExtensionPoint extensionPoint = RegistryFactoryHelper.getRegistry().getExtensionPoint(PLUGIN_ID, "models");
        if (extensionPoint != null) {
            for (IConfigurationElement configElement : extensionPoint.getConfigurationElements()) {
                ModelDescription modelDescription = new ModelDescription(configElement);
                if (modelDescription.getNamespace() == null) {
                    ModelPlugin.logErrorMessage("Attribute namespace required for modelDescription: " + configElement);
                    continue;
                }
                descriptions.add(modelDescription);
            }
        }
        return descriptions;
    }

    public static KommaModule createModelSetModule(ClassLoader classLoader) {
        KommaModule module = new KommaModule(classLoader);
        module.addConcept(ModelSupport.class, MODELS.TYPE_MODEL.toString());
        module.addConcept(ModelSetSupport.class, MODELS.TYPE_MODELSET.toString());
        module.addConcept(IModel.IDiagnostic.class, MODELS.CLASS_DIAGNOSTIC.toString());
        for (KommaModule kommaModule : ModelPlugin.getModelModules()) {
            module.includeModule(kommaModule);
        }
        return module;
    }

    public static Collection<? extends KommaModule> getModelModules() {
        IExtensionPoint extensionPoint;
        ArrayList<KommaModule> modules = new ArrayList<KommaModule>();
        if (RegistryFactoryHelper.getRegistry() != null && (extensionPoint = RegistryFactoryHelper.getRegistry().getExtensionPoint(PLUGIN_ID, "modelModules")) != null) {
            for (IConfigurationElement configElement : extensionPoint.getConfigurationElements()) {
                String className = configElement.getAttribute("class");
                if (className == null) {
                    ModelPlugin.logErrorMessage("Attribute class required for module: " + configElement);
                    continue;
                }
                try {
                    modules.add((KommaModule)configElement.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    ModelPlugin.log(e);
                }
            }
        }
        if (modules.isEmpty()) {
            modules.add(new ModelModule());
        }
        return modules;
    }

    static {
        if (!IS_OSGI_RUNNING) {
            ModelPlugin.getDefault().readExtensions();
        }
    }

    public static class Implementation
    extends AbstractKommaPlugin.EclipsePlugin {
        private ServiceTracker<IContentTypeManager, IContentTypeManager> contentTypeManagerTracker = null;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            this.contentTypeManagerTracker = new ServiceTracker(context, IContentTypeManager.class, null);
            this.contentTypeManagerTracker.open();
            ModelPlugin.getDefault().readExtensions();
        }

        public void stop(BundleContext ctx) throws Exception {
            ModelPlugin.getDefault().extensionReaders.forEach(reader -> reader.unregisterListener());
            if (this.contentTypeManagerTracker != null) {
                this.contentTypeManagerTracker.close();
                this.contentTypeManagerTracker = null;
            }
            super.stop(ctx);
        }

        public IContentTypeManager getContentTypeManager() {
            return this.contentTypeManagerTracker == null ? null : (IContentTypeManager)this.contentTypeManagerTracker.getService();
        }
    }
}

