/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import net.enilink.komma.core.IProvider;
import net.enilink.komma.core.IUnitOfWork;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.em.EagerCachingEntityManagerModule;
import net.enilink.komma.em.EntityManagerFactoryModule;
import net.enilink.komma.em.ThreadLocalDataManager;
import net.enilink.komma.em.util.KommaUtil;
import net.enilink.komma.em.util.UnitOfWork;
import net.enilink.komma.model.IModelSetFactory;
import net.enilink.komma.model.ModelSetFactory;
import net.enilink.komma.rdf4j.RDF4JModule;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class ModelSetModule
extends AbstractModule {
    private KommaModule parentModule;

    public ModelSetModule(KommaModule module) {
        this.parentModule = module;
    }

    protected void configure() {
        this.bind(UnitOfWork.class).in(Singleton.class);
        this.bind(IUnitOfWork.class).to(UnitOfWork.class);
    }

    @Provides
    @Singleton
    public IModelSetFactory provideModelSetFactory(Injector injector) {
        KommaModule module = new KommaModule(((Object)((Object)this)).getClass().getClassLoader());
        if (this.parentModule != null) {
            module.includeModule(this.parentModule);
        }
        module.includeModule(KommaUtil.getCoreModule());
        ModelSetFactory factory = (ModelSetFactory)injector.createChildInjector(this.createFactoryModules(module)).getInstance(ModelSetFactory.class);
        return factory;
    }

    protected List<? extends Module> createFactoryModules(KommaModule kommaModule) {
        return Arrays.asList(new AbstractModule(){

            protected void configure() {
                this.bind(IDataManager.class).to(ThreadLocalDataManager.class).in(Singleton.class);
            }

            @Singleton
            @Provides
            Repository provideRepository() {
                return ModelSetModule.this.createMetaDataRepository();
            }
        }, new RDF4JModule(), new EntityManagerFactoryModule(kommaModule, this.getLocaleProvider(), this.getEntityManagerModule()));
    }

    protected IProvider<Locale> getLocaleProvider() {
        return null;
    }

    protected Module getEntityManagerModule() {
        return new EagerCachingEntityManagerModule();
    }

    protected Repository createMetaDataRepository() {
        try {
            SailRepository repository = new SailRepository((Sail)new MemoryStore());
            repository.init();
            List conceptLibraries = KommaUtil.getConceptLibraries((String)"net.enilink.komma.model").toList();
            URLClassLoader cl = new URLClassLoader(conceptLibraries.toArray(new URL[conceptLibraries.size()]));
            for (String owl : this.loadOntologyList(cl)) {
                URL url = cl.getResource(owl);
                this.loadOntology((Repository)repository, url);
            }
            return repository;
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    private RDFFormat formatForFileName(String filename) {
        Optional format = Rio.getWriterFormatForFileName((String)filename);
        if (format.isPresent()) {
            return (RDFFormat)format.get();
        }
        if (filename.endsWith(".owl")) {
            return RDFFormat.RDFXML;
        }
        throw new IllegalArgumentException("Unknow RDF format for " + filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOntology(Repository repository, URL url) throws RepositoryException, IOException, RDFParseException {
        String filename = url.toString();
        RDFFormat format = this.formatForFileName(filename);
        try (RepositoryConnection conn = repository.getConnection();){
            conn.add(url, "", format, new Resource[0]);
        }
    }

    private Collection<String> loadOntologyList(ClassLoader cl) throws IOException {
        Properties ontologies = new Properties();
        String name = "META-INF/org.openrdf.ontologies";
        Enumeration<URL> resources = cl.getResources(name);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            ontologies.load(url.openStream());
        }
        Set<Object> list = ontologies.keySet();
        return list;
    }
}

