/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.NiceIterator;
import net.enilink.komma.core.URI;
import net.enilink.komma.model.base.IURIMapRule;
import net.enilink.komma.model.base.IURIMapRuleSet;

public class CompoundURIMapRuleSet
implements IURIMapRuleSet {
    private List<IURIMapRuleSet> members;

    public CompoundURIMapRuleSet(List<IURIMapRuleSet> members) {
        this.members = new CopyOnWriteArrayList<IURIMapRuleSet>(members);
    }

    public CompoundURIMapRuleSet(IURIMapRuleSet ... members) {
        this(Arrays.asList(members));
    }

    public void addMember(IURIMapRuleSet member) {
        if (!this.members.contains(member)) {
            this.members.add(member);
        }
    }

    @Override
    public void addRule(IURIMapRule rule) {
        this.members.get(0).addRule(rule);
    }

    @Override
    public IExtendedIterator<IURIMapRule> iterator() {
        Iterator<IURIMapRuleSet> memberIt = this.members.iterator();
        if (!memberIt.hasNext()) {
            return NiceIterator.emptyIterator();
        }
        IExtendedIterator<IURIMapRule> ruleIt = memberIt.next().iterator();
        while (memberIt.hasNext()) {
            ruleIt.andThen(memberIt.next().iterator());
        }
        return ruleIt;
    }

    @Override
    public URI map(URI uri) {
        Iterator<IURIMapRuleSet> memberIt = this.members.iterator();
        while (memberIt.hasNext()) {
            URI replaced = memberIt.next().map(uri);
            if (uri.equals((Object)replaced)) continue;
            return replaced;
        }
        return uri;
    }

    public boolean removeMember(IURIMapRuleSet member) {
        return this.members.remove(member);
    }

    @Override
    public void removeRule(IURIMapRule rule) {
        this.members.get(0).removeRule(rule);
    }
}

