/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.model.IContentHandler;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.base.ReaderInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class ContentHandler
implements IContentHandler {
    public static Map<String, Object> createContentDescription(IContentHandler.Validity validity) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("net.enilink.komma.model:validity", (Object)validity);
        return result;
    }

    protected Set<String> getRequestedProperties(Map<?, ?> options) {
        return (Set)options.get("REQUESTED_PROPERTIES");
    }

    protected boolean isRequestedProperty(String property, Map<?, ?> options) {
        if ("net.enilink.komma.model:validity".equals(property) || "net.enilink.komma.model:contentType".equals(property)) {
            return true;
        }
        Set<String> requestedProperties = this.getRequestedProperties(options);
        if (requestedProperties == null) {
            return true;
        }
        return requestedProperties.contains(property);
    }

    @Override
    public boolean canHandle(URI uri) {
        return true;
    }

    public Map<String, Object> contentDescription(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        Object mimeType;
        IContentTypeManager contentTypeManager;
        Map<String, Object> result = ContentHandler.createContentDescription(IContentHandler.Validity.INDETERMINATE);
        if (this.isRequestedProperty("org.eclipse.core.runtime:bom", options)) {
            result.put("org.eclipse.core.runtime:bom", (Object)this.getByteOrderMark(uri, inputStream, options, context));
        }
        if (this.isRequestedProperty("net.enilink.komma.model:contentType", options) && (contentTypeManager = ModelPlugin.getContentTypeManager()) != null && (mimeType = context.get("mimeType")) != null) {
            for (IContentType contentType : contentTypeManager.getAllContentTypes()) {
                if (!mimeType.equals(ModelUtil.mimeType(contentType.getDefaultDescription()))) continue;
                result.put("net.enilink.komma.model:contentType", contentType.getId());
                break;
            }
        }
        return result;
    }

    protected IContentHandler.ByteOrderMark getByteOrderMark(URI uri, InputStream inputStream, Map<?, ?> options, Map<Object, Object> context) throws IOException {
        IContentHandler.ByteOrderMark result = (IContentHandler.ByteOrderMark)((Object)context.get("org.eclipse.core.runtime:bom"));
        if (result == null) {
            result = IContentHandler.ByteOrderMark.read(inputStream);
            inputStream.reset();
            context.put("org.eclipse.core.runtime:bom", (Object)result);
        }
        return result;
    }

    public static class Describer
    implements IContentDescriber,
    ITextContentDescriber,
    IExecutableExtension {
        protected IContentHandler contentHandler;
        private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
        protected static final String CONTENT_TYPE_ID = "contentTypeID";
        protected static final String EXTENSIONS = "extensions";
        protected static final String MIME_TYPE = "mimeType";

        public QualifiedName[] getSupportedOptions() {
            return SUPPORTED_OPTIONS;
        }

        protected String getProperty(QualifiedName qualifiedName) {
            return qualifiedName.toString();
        }

        protected Object getDescriptionValue(QualifiedName qualifiedName, Object value) {
            if (value == null) {
                return null;
            }
            if (IContentDescription.BYTE_ORDER_MARK.equals((Object)qualifiedName)) {
                return ((IContentHandler.ByteOrderMark)((Object)value)).bytes();
            }
            return value;
        }

        public int describe(InputStream inputStream, IContentDescription description) throws IOException {
            Map<String, ?> result;
            HashMap<String, Set<Object>> options = new HashMap<String, Set<Object>>();
            if (description != null) {
                HashMap<String, QualifiedName> requestedPropertyToQualifiedNameMap = new HashMap<String, QualifiedName>();
                HashSet<String> requestedProperties = new HashSet<String>();
                for (QualifiedName qualifiedName : this.getSupportedOptions()) {
                    String property;
                    if (!description.isRequested(qualifiedName) || (property = this.getProperty(qualifiedName)) == null) continue;
                    requestedPropertyToQualifiedNameMap.put(property, qualifiedName);
                    requestedProperties.add(property);
                }
                options.put("REQUESTED_PROPERTIES", requestedProperties);
                result = this.contentHandler.contentDescription(URIs.createURI((String)"*"), inputStream, options, new HashMap<Object, Object>());
                for (Map.Entry entry : result.entrySet()) {
                    QualifiedName qualifiedName = (QualifiedName)requestedPropertyToQualifiedNameMap.get(entry.getKey());
                    if (qualifiedName == null) continue;
                    description.setProperty(qualifiedName, this.getDescriptionValue(qualifiedName, entry.getValue()));
                }
            } else {
                options.put("REQUESTED_PROPERTIES", Collections.emptySet());
                result = this.contentHandler.contentDescription(URIs.createURI((String)"*"), inputStream, options, new HashMap<Object, Object>());
            }
            return ((IContentHandler.Validity)((Object)result.get("net.enilink.komma.model:validity"))).ordinal();
        }

        public int describe(Reader reader, IContentDescription description) throws IOException {
            return this.describe(new ReaderInputStream(reader), description);
        }

        public void setInitializationData(IConfigurationElement configurationElement, String propertyName, Object data) throws CoreException {
            Map<String, String> parameters = this.getParameters(configurationElement, propertyName, data);
            this.contentHandler = this.createContentHandler(parameters);
        }

        protected IContentHandler createContentHandler(Map<String, String> parameters) {
            return ModelPlugin.getDefault().getContentHandlerRegistry().getContentHandlers().iterator().next();
        }

        protected Map<String, String> getParameters(IConfigurationElement configurationElement, String propertyName, Object data) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (data != null) {
                Map dataMap = (Map)data;
                parameters.putAll(dataMap);
            }
            parameters.put(CONTENT_TYPE_ID, configurationElement.getAttribute("id"));
            String fileExtensions = configurationElement.getAttribute("file-extensions");
            if (fileExtensions != null) {
                parameters.put(EXTENSIONS, fileExtensions.replace(',', ' '));
            }
            for (IConfigurationElement child : configurationElement.getChildren()) {
                String mimeType;
                if (!"property".equals(child.getName()) || !MIME_TYPE.equals(child.getAttribute("name")) || (mimeType = child.getAttribute("default")) == null) continue;
                parameters.put(MIME_TYPE, mimeType);
            }
            return parameters;
        }
    }
}

