/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.commons.util.extensions.RegistryFactoryHelper;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotificationBroadcaster;
import net.enilink.komma.core.EntityVar;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityDecorator;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IEntityManagerFactory;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.StatementPattern;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.em.DelegatingEntityManager;
import net.enilink.komma.em.concepts.IOntology;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelAware;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.IURIConverter;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.ObjectSupport;
import net.enilink.komma.model.base.DiagnosticWrappedException;
import net.enilink.komma.model.base.ExtensibleURIConverter;
import net.enilink.komma.model.concepts.Model;
import net.enilink.komma.model.concepts.Namespace;
import net.enilink.komma.model.event.NamespaceNotification;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdf.RDF;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Status;

public abstract class ModelSupport
implements IModel,
IModelAware,
IModel.Internal,
INotificationBroadcaster<INotification>,
Model,
Behaviour<IModel.Internal> {
    protected EntityVar<State> state;
    @Inject
    private Injector injector;
    private volatile IModelSet.Internal modelSet;

    protected static Map<?, ?> mergeMaps(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1 == null || map1.isEmpty()) {
            return map2;
        }
        if (map2 == null || map2.isEmpty()) {
            return map1;
        }
        HashMap mergedMap = new HashMap(map2);
        mergedMap.putAll(map1);
        return mergedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State state() {
        EntityVar<State> entityVar = this.state;
        synchronized (entityVar) {
            State s = (State)this.state.get();
            if (s == null) {
                s = new State();
                this.state.set((Object)s);
            }
            return s;
        }
    }

    @Override
    public IModel getModel() {
        return this;
    }

    @Override
    public void addImport(URI uri, String prefix) {
        try {
            IEntityManager manager = this.getManager();
            boolean isActive = manager.getTransaction().isActive();
            try {
                IOntology ontology;
                if (!isActive) {
                    manager.getTransaction().begin();
                }
                if (!manager.hasMatch((IReference)(ontology = this.getOntology()), (IReference)RDF.PROPERTY_TYPE, (Object)OWL.TYPE_ONTOLOGY)) {
                    manager.add((Iterable)new Statement((IReference)ontology, (IReference)RDF.PROPERTY_TYPE, (Object)OWL.TYPE_ONTOLOGY));
                }
                if (prefix != null && prefix.trim().length() > 0) {
                    manager.setNamespace(prefix, uri.appendLocalPart(""));
                }
                manager.add((Iterable)new Statement((IReference)ontology, (IReference)OWL.PROPERTY_IMPORTS, (Object)uri));
                if (!isActive) {
                    manager.getTransaction().commit();
                    this.unloadManager();
                }
            }
            catch (Exception e) {
                if (!isActive && manager != null) {
                    manager.getTransaction().rollback();
                }
                throw e;
            }
        }
        catch (Exception e) {
            throw new KommaException((Throwable)e);
        }
    }

    @Override
    public void delete(Map<?, ?> options) throws IOException {
        this.getURIConverter().delete(this.getURI(), ModelSupport.mergeMaps(options, this.getDefaultDeleteOptions()));
        this.unload();
        this.getModelSet().getModels().remove(this);
    }

    protected void doUnload() {
        this.getErrors().clear();
        this.getWarnings().clear();
        this.unloadManager();
    }

    public void fireNotifications(Collection<? extends INotification> notifications) {
        this.getModelSet().fireNotifications(notifications);
    }

    protected Map<?, ?> getDefaultDeleteOptions() {
        return null;
    }

    protected Map<?, ?> getDefaultLoadOptions() {
        return null;
    }

    protected Map<?, ?> getDefaultSaveOptions() {
        return null;
    }

    @Override
    public Set<IModel.IDiagnostic> getErrors() {
        return this.getModelErrors();
    }

    @Override
    public IEntityManager getManager() {
        return this.state().manager();
    }

    @Override
    public IModelSet.Internal getModelSet() {
        IModelSet.Internal modelSet = this.modelSet;
        if (modelSet == null) {
            this.modelSet = modelSet = (IModelSet.Internal)((IQuery)this.getEntityManager().createQuery("SELECT DISTINCT ?ms WHERE { ?ms <http://enilink.net/vocab/komma/models#model> ?m }").setParameter("m", this.getBehaviourDelegate())).getSingleResult(IModelSet.class);
        }
        return modelSet;
    }

    @Override
    public Set<URI> getImports() {
        Set<URI> importedModels = this.state().importedModels;
        if (importedModels == null) {
            importedModels = new HashSet<URI>();
            try (IDataManager dm = (IDataManager)this.getModelSet().getDataManagerFactory().get();){
                IExtendedIterator imports = dm.createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#>  SELECT ?import WHERE { ?ontology owl:imports ?import FILTER NOT EXISTS { ?import a owl:Ontology } }", this.getURI().toString(), false, new IReference[]{this.getURI()}).evaluate().mapWith((IMap)new IMap<Object, IReference>(){

                    public IReference map(Object value) {
                        return (IReference)((IBindings)value).get("import");
                    }
                });
                while (imports.hasNext()) {
                    URI uri = ((IReference)imports.next()).getURI();
                    if (uri == null) continue;
                    importedModels.add(uri);
                }
            }
            catch (Throwable e) {
                throw new KommaException(e);
            }
            this.state().importedModels = importedModels;
        }
        return importedModels;
    }

    @Override
    public boolean demandLoadImport(URI imported) {
        return true;
    }

    @Override
    public Set<URI> getImportsClosure() {
        HashSet<URI> seen = new HashSet<URI>();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(this.getBehaviourDelegate());
        while (!queue.isEmpty()) {
            IModel model = (IModel)queue.remove();
            for (URI imported : model.getImports()) {
                if (!seen.add(imported)) continue;
                try {
                    boolean demandLoad = ((IModel.Internal)this.getBehaviourDelegate()).demandLoadImport(imported);
                    queue.add(this.getModelSet().getModel(imported, demandLoad));
                }
                catch (Throwable e) {
                    this.getErrors().add(new DiagnosticWrappedException(this.getURI().toString(), (Exception)new KommaException("Error while loading import: " + imported, e)));
                }
            }
        }
        return seen;
    }

    @Override
    public synchronized KommaModule getModuleClosure() {
        KommaModule moduleClosure = this.state().moduleClosure;
        if (moduleClosure == null) {
            IExtensionPoint extensionPoint;
            this.state().moduleClosure = moduleClosure = new KommaModule(ModelSupport.class.getClassLoader());
            moduleClosure.addWritableGraph(this.getURI());
            moduleClosure.addConcept(IObject.class);
            moduleClosure.addBehaviour(ObjectSupport.class);
            KommaModule modelSetModule = this.getModelSet().getModule();
            if (modelSetModule != null) {
                moduleClosure.includeModule(modelSetModule);
            }
            if ((extensionPoint = RegistryFactoryHelper.getRegistry().getExtensionPoint("net.enilink.komma.model", "modules")) != null) {
                for (IConfigurationElement cfgElement : extensionPoint.getConfigurationElements()) {
                    String namespace;
                    if (!cfgElement.isValid() || (namespace = cfgElement.getAttribute("uri")) != null && !namespace.trim().isEmpty()) continue;
                    try {
                        KommaModule extensionModule = (KommaModule)cfgElement.createExecutableExtension("class");
                        moduleClosure.includeModule(extensionModule);
                    }
                    catch (CoreException e) {
                        throw new KommaException("Unable to instantiate extension module", (Throwable)e);
                    }
                }
            }
            HashSet<URI> seen = new HashSet<URI>();
            seen.add(this.getURI());
            LinkedList<Object> queue = new LinkedList<Object>();
            queue.add(this.getBehaviourDelegate());
            while (!queue.isEmpty()) {
                IModel model = (IModel)queue.remove();
                moduleClosure.includeModule(((IModel.Internal)model).getModule());
                for (URI imported : model.getImports()) {
                    if (!seen.add(imported)) continue;
                    boolean demandLoad = ((IModel.Internal)this.getBehaviourDelegate()).demandLoadImport(imported);
                    IModel importedModel = null;
                    try {
                        importedModel = this.getModelSet().getModel(imported, demandLoad);
                    }
                    catch (Throwable e) {
                        this.getErrors().add(new DiagnosticWrappedException(this.getURI().toString(), (Exception)new KommaException("Error while loading import: " + imported, e)));
                    }
                    if (demandLoad && importedModel == null) {
                        importedModel = this.getModelSet().getModel(imported, false);
                    }
                    if (importedModel == null) continue;
                    queue.add(importedModel);
                }
            }
        }
        return moduleClosure;
    }

    @Override
    public synchronized KommaModule getModule() {
        KommaModule module = this.state().module;
        if (module == null) {
            this.state().module = module = new KommaModule(ModelSupport.class.getClassLoader());
            module.addWritableGraph(this.getURI());
            for (Namespace ns : this.getModelNamespaces()) {
                module.addNamespace(ns.getPrefix(), ns.getURI());
            }
            String modelUri = this.getURI().toString();
            IExtensionPoint extensionPoint = RegistryFactoryHelper.getRegistry().getExtensionPoint("net.enilink.komma.model", "modules");
            if (extensionPoint != null) {
                for (IConfigurationElement cfgElement : extensionPoint.getConfigurationElements()) {
                    String namespace;
                    if (!cfgElement.isValid() || !modelUri.equals(namespace = cfgElement.getAttribute("uri"))) continue;
                    try {
                        KommaModule extensionModule = (KommaModule)cfgElement.createExecutableExtension("class");
                        module.includeModule(extensionModule);
                    }
                    catch (CoreException e) {
                        throw new KommaException("Unable to instantiate extension module", (Throwable)e);
                    }
                }
            }
            try {
                for (KommaModule extensionModule : (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<KommaModule>>(){}, (Annotation)Names.named((String)modelUri)))) {
                    module.includeModule(extensionModule);
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return module;
    }

    @Override
    public URI resolveURI(String localPart) {
        return this.getManager().getNamespace("").appendLocalPart(localPart);
    }

    @Override
    public IOntology getOntology() {
        return (IOntology)this.getManager().find((IReference)this.getManager().getNamespace("").trimFragment(), IOntology.class, new Class[0]);
    }

    IURIConverter getURIConverter() {
        return this.getModelSet().getURIConverter();
    }

    @Override
    public Set<IModel.IDiagnostic> getWarnings() {
        return this.getModelWarnings();
    }

    @Override
    public boolean isLoaded() {
        if (!this.isModelLoaded()) {
            try (IDataManager ds = (IDataManager)this.getModelSet().getDataManagerFactory().get();){
                if (ds.hasMatch(null, null, null, false, new IReference[]{this.getURI()})) {
                    ((Model)this.getBehaviourDelegate()).setModelLoaded(true);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @Override
    public boolean isLoading() {
        return this.isModelLoading();
    }

    @Override
    public boolean isModified() {
        return this.isModelModified();
    }

    @Override
    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded()) {
            this.loadInternal(this.getURI(), options);
        }
    }

    @Override
    public void load(URI uri, Map<?, ?> options) throws IOException {
        this.loadInternal(uri, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInternal(URI uri, Map<?, ?> options) throws IOException {
        HashMap response;
        IURIConverter uriConverter = this.getURIConverter();
        HashMap hashMap = response = options == null ? null : (HashMap)options.get("RESPONSE");
        if (response == null) {
            response = new HashMap();
        }
        InputStream inputStream = null;
        try {
            inputStream = uriConverter.createInputStream(uri, new ExtensibleURIConverter.OptionsMap("RESPONSE", response, options));
        }
        catch (IOException exception) {
            this.setModelLoaded(true);
            this.setModelLoading(true);
            this.getErrors().clear();
            this.getWarnings().clear();
            this.setModelLoading(false);
            this.setModified(false);
            if (exception instanceof MalformedURLException) {
                ModelPlugin.getDefault().log(new Status(2, "net.enilink.komma.model", 10002, "Unable to load model '" + uri + "': " + exception.getMessage(), null));
                return;
            }
            throw exception;
        }
        try {
            ((IModel.Internal)this.getBehaviourDelegate()).load(inputStream, options);
        }
        finally {
            inputStream.close();
            Long timeStamp = (Long)response.get("TIME_STAMP");
            if (timeStamp != null) {
                // empty if block
            }
        }
    }

    @Override
    public void removeImport(URI importedOnt) {
        try {
            IEntityManager manager = this.getManager();
            boolean isActive = manager.getTransaction().isActive();
            try {
                if (!isActive) {
                    manager.getTransaction().begin();
                }
                for (INamespace namespace : manager.getNamespaces().toList()) {
                    if (!importedOnt.equals((Object)namespace.getURI())) continue;
                    manager.removeNamespace(namespace.getPrefix());
                }
                manager.remove((Iterable)new Statement((IReference)this.getURI(), (IReference)OWL.PROPERTY_IMPORTS, (Object)importedOnt));
                if (!isActive) {
                    manager.getTransaction().commit();
                    this.unloadManager();
                }
            }
            catch (Exception e) {
                if (!isActive && manager != null) {
                    manager.getTransaction().rollback();
                }
                throw e;
            }
        }
        catch (Exception e) {
            if (e instanceof KommaException) {
                throw (KommaException)e;
            }
            throw new KommaException((Throwable)e);
        }
    }

    @Override
    public IObject resolve(IReference reference) {
        if (reference == null) {
            return null;
        }
        if (reference instanceof IObject && ((IModel.Internal)this.getBehaviourDelegate()).equals(((IObject)reference).getModel())) {
            return (IObject)reference;
        }
        return (IObject)this.getManager().find(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Map<?, ?> options) throws IOException {
        Object saveOnlyIfChanged;
        Object v0 = options != null && options.containsKey("SAVE_ONLY_IF_CHANGED") ? options.get("SAVE_ONLY_IF_CHANGED") : (saveOnlyIfChanged = this.getDefaultSaveOptions() != null ? this.getDefaultSaveOptions().get("SAVE_ONLY_IF_CHANGED") : null);
        if (saveOnlyIfChanged != null && options.get("CONTENT_DESCRIPTION") == null) {
            HashMap newOptions = new HashMap(options != null ? options : Collections.emptyMap());
            newOptions.put("CONTENT_DESCRIPTION", ModelUtil.determineContentDescription(this.getURI(), this.getModelSet().getURIConverter(), options));
            options = newOptions;
        }
        if ("FILE_BUFFER".equals(saveOnlyIfChanged)) {
            this.saveOnlyIfChangedWithFileBuffer(options);
        } else if ("MEMORY_BUFFER".equals(saveOnlyIfChanged)) {
            this.saveOnlyIfChangedWithMemoryBuffer(options);
        } else {
            HashMap response;
            HashMap hashMap = response = options == null ? null : (HashMap)options.get("RESPONSE");
            if (response == null) {
                response = new HashMap();
            }
            IURIConverter uriConverter = this.getURIConverter();
            OutputStream outputStream = uriConverter.createOutputStream(this.getURI(), new ExtensibleURIConverter.OptionsMap("RESPONSE", response, options));
            try {
                ((IModel.Internal)this.getBehaviourDelegate()).save(outputStream, options);
            }
            finally {
                outputStream.close();
                Long timeStamp = (Long)response.get("TIME_STAMP");
                if (timeStamp != null) {
                    // empty if block
                }
            }
        }
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveOnlyIfChangedWithFileBuffer(Map<?, ?> options) throws IOException {
        block28: {
            File temporaryFile = File.createTempFile("ModelSaveHelper", null);
            try {
                HashMap response;
                byte[] newContentBuffer;
                boolean equal;
                IURIConverter uriConverter;
                URI temporaryFileURI;
                block27: {
                    temporaryFileURI = URIs.createFileURI((String)temporaryFile.getPath());
                    uriConverter = this.getURIConverter();
                    try (OutputStream temporaryFileOutputStream = uriConverter.createOutputStream(temporaryFileURI, null);){
                        this.save(temporaryFileOutputStream, options);
                    }
                    equal = true;
                    InputStream oldContents = null;
                    try {
                        oldContents = uriConverter.createInputStream(this.getURI(), this.getDefaultDeleteOptions());
                    }
                    catch (IOException exception) {
                        equal = false;
                    }
                    newContentBuffer = new byte[4000];
                    if (oldContents != null) {
                        try (InputStream newContents = uriConverter.createInputStream(temporaryFileURI, null);){
                            byte[] oldContentBuffer = new byte[4000];
                            int oldLength = oldContents.read(oldContentBuffer);
                            int newLength = newContents.read(newContentBuffer);
                            while ((equal = oldLength == newLength) && oldLength > 0) {
                                for (int i = 0; i < oldLength; ++i) {
                                    if (oldContentBuffer[i] == newContentBuffer[i]) continue;
                                    equal = false;
                                    break block27;
                                }
                                oldLength = oldContents.read(oldContentBuffer);
                                newLength = newContents.read(newContentBuffer);
                            }
                        }
                        finally {
                            oldContents.close();
                        }
                    }
                }
                if (equal) break block28;
                HashMap hashMap = response = options == null ? null : (HashMap)options.get("RESPONSE");
                if (response == null) {
                    response = new HashMap();
                }
                OutputStream newContents = uriConverter.createOutputStream(this.getURI(), new ExtensibleURIConverter.OptionsMap("RESPONSE", response, options));
                try (InputStream temporaryFileContents = uriConverter.createInputStream(temporaryFileURI, null);){
                    int length = temporaryFileContents.read(newContentBuffer);
                    while (length > 0) {
                        newContents.write(newContentBuffer, 0, length);
                        length = temporaryFileContents.read(newContentBuffer);
                    }
                }
                finally {
                    newContents.close();
                    Long timeStamp = (Long)response.get("TIME_STAMP");
                    if (timeStamp != null) {
                        // empty if block
                    }
                }
            }
            finally {
                temporaryFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveOnlyIfChangedWithMemoryBuffer(Map<?, ?> options) throws IOException {
        boolean equal;
        int length;
        byte[] newContentBuffer;
        IURIConverter uriConverter;
        block18: {
            class MyByteArrayOutputStream
            extends ByteArrayOutputStream {
                MyByteArrayOutputStream() {
                }

                public byte[] buffer() {
                    return this.buf;
                }

                public int length() {
                    return this.count;
                }
            }
            uriConverter = this.getURIConverter();
            try (MyByteArrayOutputStream memoryBuffer = new MyByteArrayOutputStream();){
                this.save(memoryBuffer, options);
            }
            newContentBuffer = memoryBuffer.buffer();
            length = memoryBuffer.length();
            equal = true;
            InputStream oldContents = null;
            try {
                oldContents = uriConverter.createInputStream(this.getURI(), this.getDefaultLoadOptions());
            }
            catch (IOException exception) {
                equal = false;
            }
            if (oldContents != null) {
                try {
                    byte[] oldContentBuffer = new byte[length];
                    if (oldContents.read(oldContentBuffer) == length && oldContents.read() == -1) {
                        for (int i = 0; i < length; ++i) {
                            if (oldContentBuffer[i] == newContentBuffer[i]) continue;
                            equal = false;
                            break block18;
                        }
                        break block18;
                    }
                    equal = false;
                }
                finally {
                    oldContents.close();
                }
            }
        }
        if (!equal) {
            HashMap response;
            HashMap hashMap = response = options == null ? null : (HashMap)options.get("RESPONSE");
            if (response == null) {
                response = new HashMap();
            }
            OutputStream newContents = uriConverter.createOutputStream(this.getURI(), new ExtensibleURIConverter.OptionsMap("RESPONSE", response, options));
            try {
                newContents.write(newContentBuffer, 0, length);
            }
            finally {
                newContents.close();
                Long timeStamp = (Long)response.get("TIME_STAMP");
                if (timeStamp != null) {
                    // empty if block
                }
            }
        }
    }

    @Override
    public void setLoaded(boolean isLoaded) {
        this.setModelLoaded(isLoaded);
    }

    @Override
    public void setModified(boolean isModified) {
        this.setModelModified(isModified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURI(URI uri) {
        if (uri != null && !uri.equals((Object)this.getURI())) {
            URI oldURI = this.getURI();
            this.getManager().rename((Object)oldURI, uri);
            IDataManager dm = (IDataManager)this.getModelSet().getDataManagerFactory().get();
            try {
                dm.getTransaction().begin();
                this.getModelSet().getDataChangeSupport().setEnabled(dm, false);
                dm.add((Iterable)dm.match(null, null, null, false, new IReference[]{oldURI}), new IReference[]{uri});
                dm.remove(Collections.singleton(new StatementPattern(null, null, null)), new IReference[]{oldURI});
                dm.getTransaction().commit();
            }
            finally {
                if (dm.getTransaction() != null && dm.getTransaction().isActive()) {
                    dm.getTransaction().rollback();
                }
                dm.close();
            }
            this.getEntityManager().rename((Object)this, uri);
            this.setModified(true);
            this.unloadManager();
        }
    }

    @Override
    public void unload() {
        if (this.isLoaded()) {
            this.setModelLoaded(false);
            this.doUnload();
        }
        this.state.remove();
    }

    @Override
    public synchronized void unloadManager() {
        this.state().reset();
    }

    class State {
        KommaModule module;
        KommaModule moduleClosure;
        Set<URI> importedModels;
        WeakReference<IEntityManagerFactory> factoryRef;
        WeakReference<IEntityManager> managerRef;

        State() {
        }

        void reset() {
            IEntityManager manager;
            this.module = null;
            this.moduleClosure = null;
            this.importedModels = null;
            if (this.managerRef != null && (manager = (IEntityManager)this.managerRef.get()) != null) {
                manager.close();
            }
            this.factoryRef = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IEntityManager manager() {
            Object manager;
            IEntityManager iEntityManager = manager = this.managerRef != null ? (IEntityManager)this.managerRef.get() : null;
            if (manager == null) {
                State state = this;
                synchronized (state) {
                    IEntityManager iEntityManager2 = manager = this.managerRef != null ? (IEntityManager)this.managerRef.get() : null;
                    if (manager == null) {
                        manager = new DelegatingEntityManager(){
                            IEntityManager delegate;
                            final Map<URI, String> uriToPrefix = new ConcurrentHashMap<URI, String>();
                            final Map<String, URI> prefixToUri = new ConcurrentHashMap<String, URI>();

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public IEntityManager getDelegate() {
                                State state = State.this;
                                synchronized (state) {
                                    if (this.delegate == null) {
                                        IEntityManagerFactory factory;
                                        IEntityManagerFactory iEntityManagerFactory = factory = State.this.factoryRef != null ? (IEntityManagerFactory)State.this.factoryRef.get() : null;
                                        if (factory == null) {
                                            factory = ModelSupport.this.getModelSet().getEntityManagerFactory().createChildFactory(new KommaModule[]{((IModel.Internal)ModelSupport.this.getBehaviourDelegate()).getModuleClosure()});
                                            State.this.factoryRef = new WeakReference<IEntityManagerFactory>(factory);
                                        }
                                        this.delegate = factory.create((IEntityManager)State.this.managerRef.get());
                                        this.delegate.addDecorator((IEntityDecorator)new ModelInjector());
                                    }
                                }
                                return this.delegate;
                            }

                            public void removeNamespace(String prefix) {
                                if (prefix == null) {
                                    prefix = "";
                                }
                                for (Namespace ns : new ArrayList(ModelSupport.this.getModelNamespaces())) {
                                    if (!prefix.equals(ns.getPrefix())) continue;
                                    ModelSupport.this.getModelNamespaces().remove(ns);
                                    ModelSupport.this.fireNotifications(Arrays.asList(new NamespaceNotification(prefix, ns.getURI(), null)));
                                    break;
                                }
                                this.clearNamespaceCache();
                            }

                            public void setNamespace(String prefix, URI uri) {
                                if (prefix == null) {
                                    prefix = "";
                                }
                                URI oldUri = null;
                                if (uri.equals((Object)super.getNamespace(prefix))) {
                                    oldUri = uri;
                                }
                                if (oldUri == null) {
                                    for (Namespace ns : new ArrayList(ModelSupport.this.getModelNamespaces())) {
                                        if (!prefix.equals(ns.getPrefix())) continue;
                                        ns.setPrefix(prefix);
                                        oldUri = ns.getURI();
                                        break;
                                    }
                                }
                                if (oldUri == null) {
                                    Namespace ns = (Namespace)ModelSupport.this.getEntityManager().create(Namespace.class, new Class[0]);
                                    ns.setPrefix(prefix);
                                    ns.setURI(uri);
                                    ModelSupport.this.getModelNamespaces().add(ns);
                                }
                                ModelSupport.this.fireNotifications(Arrays.asList(new NamespaceNotification(prefix, oldUri, uri)));
                                this.clearNamespaceCache();
                            }

                            public IExtendedIterator<INamespace> getNamespaces() {
                                LinkedHashMap<String, net.enilink.komma.core.Namespace> prefixMap = new LinkedHashMap<String, net.enilink.komma.core.Namespace>();
                                for (INamespace ns : WrappedIterator.create(this.getAllModelNamespaces().iterator()).andThen((Iterator)super.getNamespaces().mapWith((IMap)new IMap<INamespace, INamespace>(){

                                    public INamespace map(INamespace ns) {
                                        return new net.enilink.komma.core.Namespace(ns.getPrefix(), ns.getURI(), true);
                                    }
                                }))) {
                                    if (prefixMap.containsKey(ns.getPrefix())) continue;
                                    prefixMap.put(ns.getPrefix(), new net.enilink.komma.core.Namespace(ns.getPrefix(), ns.getURI(), ns.isDerived()));
                                }
                                return WrappedIterator.create(prefixMap.values().iterator());
                            }

                            List<INamespace> getAllModelNamespaces() {
                                KommaModule module;
                                ArrayList<INamespace> nsList = new ArrayList<INamespace>(ModelSupport.this.getModelNamespaces());
                                boolean emptyPrefix = false;
                                for (INamespace ns : nsList) {
                                    if (!ns.getPrefix().isEmpty()) continue;
                                    emptyPrefix = true;
                                    break;
                                }
                                if (!emptyPrefix) {
                                    nsList.add((INamespace)new net.enilink.komma.core.Namespace("", ModelSupport.this.getURI().appendLocalPart("")));
                                }
                                if ((module = State.this.moduleClosure) != null) {
                                    for (INamespace ns : module.getNamespaces()) {
                                        nsList.add((INamespace)new net.enilink.komma.core.Namespace(ns.getPrefix(), ns.getURI(), true));
                                    }
                                }
                                return nsList;
                            }

                            public URI getNamespace(String prefix) {
                                URI uri;
                                if (prefix == null || prefix.length() == 0) {
                                    return ModelSupport.this.getURI().appendLocalPart("");
                                }
                                if (this.prefixToUri.isEmpty()) {
                                    this.cacheNamespaces();
                                }
                                return (uri = this.prefixToUri.get(prefix)) != null ? uri : super.getNamespace(prefix);
                            }

                            public String getPrefix(URI namespace) {
                                String prefix;
                                if (namespace.equals((Object)ModelSupport.this.getURI().appendLocalPart(""))) {
                                    return "";
                                }
                                if (this.uriToPrefix.isEmpty()) {
                                    this.cacheNamespaces();
                                }
                                return (prefix = this.uriToPrefix.get(namespace)) != null ? prefix : super.getPrefix(namespace);
                            }

                            protected void clearNamespaceCache() {
                                this.uriToPrefix.clear();
                                this.prefixToUri.clear();
                            }

                            protected void cacheNamespaces() {
                                for (INamespace ns : this.getAllModelNamespaces()) {
                                    String prefix = this.uriToPrefix.get(ns.getURI());
                                    if (prefix == null || prefix.compareTo(ns.getPrefix()) > 0) {
                                        this.uriToPrefix.put(ns.getURI(), ns.getPrefix());
                                    }
                                    this.prefixToUri.put(ns.getPrefix(), ns.getURI());
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void close() {
                                State state = State.this;
                                synchronized (state) {
                                    if (this.delegate != null) {
                                        this.delegate.close();
                                        this.delegate = null;
                                    }
                                }
                            }

                            protected void finalize() throws Throwable {
                                this.close();
                                ModelSupport.this.state.remove();
                                this.delegate = null;
                                super.finalize();
                            }
                        };
                        ModelSupport.this.injector.injectMembers(manager);
                        this.managerRef = new WeakReference<IEntityManager>((IEntityManager)manager);
                    }
                }
            }
            return manager;
        }
    }

    class ModelInjector
    implements IEntityDecorator {
        ModelInjector() {
        }

        public void decorate(IEntity entity) {
            ((net.enilink.komma.internal.model.IModelAware)entity).initModel((IModel)ModelSupport.this.getBehaviourDelegate());
        }
    }
}

