/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReaderInputStream
extends InputStream {
    private static final Pattern XML_HEADER = Pattern.compile("<\\?xml\\s+(?:version\\s*=\\s*\"[^\"]*\"\\s+)encoding\\s*=\\s*\"\\s*([^\\s\"]*)\"\\s*\\?>");
    protected String encoding;
    protected Reader reader;
    protected Buffer buffer;

    public static String getEncoding(String xmlString) {
        Matcher matcher = XML_HEADER.matcher(xmlString);
        return matcher.lookingAt() ? matcher.group(1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncoding(Reader xmlReader) {
        try {
            xmlReader.mark(100);
            char[] buffer = new char[100];
            int length = xmlReader.read(buffer);
            if (length > -1) {
                Matcher matcher = XML_HEADER.matcher(new String(buffer, 0, length));
                String string = matcher.lookingAt() ? matcher.group(1) : null;
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException exception) {
            String string = null;
            return string;
        }
        finally {
            try {
                xmlReader.reset();
            }
            catch (IOException iOException) {}
        }
    }

    public ReaderInputStream(Reader reader, String encoding) {
        this.reader = reader;
        this.encoding = encoding;
    }

    public ReaderInputStream(Reader xmlReader) {
        this.reader = xmlReader.markSupported() ? xmlReader : new BufferedReader(xmlReader);
        this.encoding = ReaderInputStream.getEncoding(this.reader);
    }

    public ReaderInputStream(String string, String encoding) {
        this(new StringReader(string), encoding);
    }

    public ReaderInputStream(String xmlString) {
        this(new StringReader(xmlString), ReaderInputStream.getEncoding(xmlString));
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            this.buffer = new Buffer(100);
        }
        return this.buffer.read();
    }

    public Reader asReader() {
        return this.reader;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.reader.reset();
    }

    protected class Buffer
    extends ByteArrayOutputStream {
        protected int index;
        protected char[] characters;
        protected OutputStreamWriter writer;

        public Buffer(int size) throws IOException {
            super(size);
            this.characters = new char[size];
            this.writer = new OutputStreamWriter((OutputStream)this, ReaderInputStream.this.encoding);
        }

        public int read() throws IOException {
            if (this.index < this.count) {
                return this.buf[this.index++];
            }
            this.index = 0;
            this.reset();
            int readCount = ReaderInputStream.this.reader.read(this.characters);
            if (readCount < 0) {
                return -1;
            }
            this.writer.write(this.characters, 0, readCount);
            this.writer.flush();
            return this.buf[this.index++];
        }
    }
}

