/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.enilink.komma.model.base.IURIMapRule;

public class RegExURIMapRule
implements IURIMapRule {
    int priority;
    Pattern regexPattern;
    String replacement;
    String pattern;
    String ifPattern;
    String unlessPattern;

    public RegExURIMapRule() {
        this.replacement = null;
        this.pattern = null;
        this.priority = 0;
        this.ifPattern = null;
        this.unlessPattern = null;
    }

    public RegExURIMapRule(String pattern, String replacement, int prior) {
        this.replacement = replacement;
        this.pattern = pattern;
        this.priority = prior;
        this.ifPattern = null;
        this.unlessPattern = null;
    }

    @Override
    public String apply(String uri) {
        Matcher matcher = this.getMatcher(uri);
        if (matcher.find() && this.canApply(uri)) {
            return matcher.replaceAll(this.getReplacement());
        }
        return null;
    }

    private boolean canApply(String uri) {
        boolean canApply = this.getUnlessPattern() == null || !Pattern.compile(this.getUnlessPattern()).matcher(uri).find();
        return canApply &= this.getIfPattern() == null || Pattern.compile(this.getIfPattern()).matcher(uri).find();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegExURIMapRule)) {
            return false;
        }
        RegExURIMapRule other = (RegExURIMapRule)obj;
        if (this.ifPattern == null ? other.ifPattern != null : !this.ifPattern.equals(other.ifPattern)) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement)) {
            return false;
        }
        return !(this.unlessPattern == null ? other.unlessPattern != null : !this.unlessPattern.equals(other.unlessPattern));
    }

    public String getIfPattern() {
        return this.ifPattern;
    }

    private Matcher getMatcher(String uri) {
        if (this.regexPattern == null) {
            this.regexPattern = Pattern.compile(this.getPattern());
        }
        return this.regexPattern.matcher(uri);
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public String getUnlessPattern() {
        return this.unlessPattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ifPattern == null ? 0 : this.ifPattern.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
        result = 31 * result + (this.unlessPattern == null ? 0 : this.unlessPattern.hashCode());
        return result;
    }

    public IURIMapRule setIfPattern(String pattern) {
        this.ifPattern = pattern;
        return this;
    }

    public RegExURIMapRule setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public RegExURIMapRule setPriority(int prior) {
        this.priority = prior;
        return this;
    }

    public RegExURIMapRule setReplacement(String replacement) {
        this.replacement = replacement;
        return this;
    }

    public IURIMapRule setUnlessPattern(String pattern) {
        this.unlessPattern = pattern;
        return this;
    }
}

