/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.model.base.IURIMapRule;
import net.enilink.komma.model.base.IURIMapRuleSet;

public class URIMapRuleSet
implements IURIMapRuleSet {
    Set<IURIMapRule> rules = Collections.synchronizedSet(new HashSet());
    IURIMapRule[] sortedRules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRule(IURIMapRule rule) {
        if (this.rules.add(rule)) {
            Set<IURIMapRule> set = this.rules;
            synchronized (set) {
                this.sortedRules = null;
            }
        }
    }

    @Override
    public IExtendedIterator<IURIMapRule> iterator() {
        return WrappedIterator.create(this.rules.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI map(URI uri) {
        Set<IURIMapRule> set = this.rules;
        synchronized (set) {
            if (this.sortedRules == null) {
                this.sortedRules = this.rules.toArray(new IURIMapRule[this.rules.size()]);
                Arrays.sort(this.sortedRules, new PriorityComparator());
            }
        }
        String uriString = uri.toString();
        for (IURIMapRule rule : this.sortedRules) {
            String replaced = rule.apply(uriString);
            if (replaced == null) continue;
            return URIs.createURI((String)replaced);
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRule(IURIMapRule rule) {
        if (this.rules.remove(rule)) {
            Set<IURIMapRule> set = this.rules;
            synchronized (set) {
                this.sortedRules = null;
            }
        }
    }

    class PriorityComparator
    implements Comparator<IURIMapRule> {
        PriorityComparator() {
        }

        @Override
        public int compare(IURIMapRule o1, IURIMapRule o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

