/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.rdf4j;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.Collection;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.rdf4j.IRepositoryModelSet;
import net.enilink.komma.model.rdf4j.RepositoryUtil;
import net.enilink.komma.rdf4j.RDF4JModule;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

@Iri(value="http://enilink.net/vocab/komma/models#MemoryModelSet")
public abstract class MemoryModelSetSupport
implements IModelSet,
IModelSet.Internal,
IRepositoryModelSet,
Behaviour<IRepositoryModelSet> {
    @Override
    public Repository createRepository() throws RepositoryException {
        MemoryStore store = new MemoryStore();
        if (!Boolean.FALSE.equals(this.getInference())) {
            store = new SchemaCachingRDFSInferencer((NotifyingSail)store);
        }
        SailRepository repository = new SailRepository((Sail)store);
        repository.init();
        this.addBasicKnowledge((Repository)repository);
        return repository;
    }

    protected void addBasicKnowledge(Repository repository) throws RepositoryException {
        RepositoryUtil.addBasicKnowledge(repository, this.getDefaultGraph(), this.importRdfAndRdfsVocabulary());
    }

    protected boolean importRdfAndRdfsVocabulary() {
        return true;
    }

    @Iri(value="http://enilink.net/vocab/komma/models#inference")
    public abstract Boolean getInference();

    @Override
    public void collectInjectionModules(Collection<Module> modules) {
        modules.add((Module)new RDF4JModule());
        modules.add((Module)new AbstractModule(){

            protected void configure() {
            }

            @Singleton
            @Provides
            protected Repository provideRepository() {
                try {
                    return ((IRepositoryModelSet)MemoryModelSetSupport.this.getBehaviourDelegate()).createRepository();
                }
                catch (RepositoryException e) {
                    throw new KommaException("Unable to create repository.", (Throwable)e);
                }
            }
        });
    }

    @Override
    public boolean isPersistent() {
        return false;
    }
}

