/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.rdf4j;

import java.io.File;
import java.net.URL;
import net.enilink.composition.annotations.Iri;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.model.rdf4j.MemoryModelSetSupport;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.nativerdf.NativeStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Iri(value="http://enilink.net/vocab/komma/models#PersistentModelSet")
public abstract class PersistentModelSetSupport
extends MemoryModelSetSupport {
    @Iri(value="http://enilink.net/vocab/komma/models#repository")
    public abstract URI getRepository();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Repository createRepository() throws RepositoryException {
        URI repo = this.getRepository();
        if (repo.scheme() != "workspace") throw new RepositoryException("Location service for workspace scheme not found");
        try {
            String instanceFilter = "(type=osgi.instance.area)";
            BundleContext context = FrameworkUtil.getBundle(PersistentModelSetSupport.class).getBundleContext();
            ServiceReference[] refs = context.getServiceReferences("org.eclipse.osgi.service.datalocation.Location", instanceFilter);
            if (refs.length > 0) {
                Object location = context.getService(refs[0]);
                URL loc = (URL)location.getClass().getMethod("getURL", new Class[0]).invoke(location, new Object[0]);
                URI workspace = URIs.createURI((String)FileLocator.resolve((URL)loc).toString());
                if (workspace.lastSegment() == "") {
                    workspace = workspace.trimSegments(1);
                }
                repo = workspace.appendSegments(repo.segments());
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        NativeStore store = new NativeStore(new File(repo.toFileString()));
        if (!Boolean.FALSE.equals(this.getInference())) {
            store = new SchemaCachingRDFSInferencer((NotifyingSail)store);
        }
        SailRepository repository = new SailRepository((Sail)store);
        repository.init();
        this.addBasicKnowledge((Repository)repository);
        return repository;
    }
}

