/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.rdf4j;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.util.Modules;
import java.util.Collection;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.composition.annotations.Iri;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.InferencingCapability;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerFactory;
import net.enilink.komma.dm.IDataManagerQuery;
import net.enilink.komma.dm.change.IDataChangeSupport;
import net.enilink.komma.internal.rdf4j.RDF4JRepositoryDataManager;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.rdf4j.RepositoryUtil;
import net.enilink.komma.rdf4j.RDF4JDataManagerFactory;
import net.enilink.komma.rdf4j.RDF4JModule;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepository;

@Iri(value="http://enilink.net/vocab/komma/models#RemoteModelSet")
public abstract class RemoteModelSetSupport
implements IModelSet.Internal {
    public static final String USERNAME = null;
    public static final String PASSWORD = null;

    protected <T> T valueOrDefault(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    @Iri(value="http://enilink.net/vocab/komma/models#server")
    public abstract URI getServer();

    @Iri(value="http://enilink.net/vocab/komma/models#repository")
    public abstract String getRepository();

    @Iri(value="http://enilink.net/vocab/komma/models#username")
    public abstract String getUsername();

    @Iri(value="http://enilink.net/vocab/komma/models#password")
    public abstract String getPassword();

    @Override
    public void collectInjectionModules(Collection<Module> modules) {
        modules.add(Modules.override((Module[])new Module[]{new RDF4JModule()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(RemoteRepositoryDataManagerFactory.class).in(Singleton.class);
                this.bind(IDataManagerFactory.class).to(RemoteRepositoryDataManagerFactory.class);
            }
        }}));
        modules.add((Module)new AbstractModule(){

            protected void configure() {
                this.bind(InferencingCapability.class).toInstance((Object)new InferencingCapability(){

                    public boolean doesRDFS() {
                        return true;
                    }

                    public boolean doesOWL() {
                        return true;
                    }

                    public boolean inDefaultGraph() {
                        return true;
                    }
                });
            }

            @Singleton
            @Provides
            protected Repository provideRepository() {
                try {
                    HTTPRepository repo = new HTTPRepository(RemoteModelSetSupport.this.getServer().toString(), RemoteModelSetSupport.this.valueOrDefault(RemoteModelSetSupport.this.getRepository(), "enilink"));
                    String username = RemoteModelSetSupport.this.getUsername();
                    if (username != null) {
                        String password = RemoteModelSetSupport.this.getPassword();
                        repo.setUsernameAndPassword(username, password);
                    }
                    repo.init();
                    RemoteModelSetSupport.this.addBasicKnowledge((Repository)repo);
                    return repo;
                }
                catch (Exception e) {
                    throw new KommaException("Unable to initialize repository", (Throwable)e);
                }
            }
        });
    }

    protected void addBasicKnowledge(Repository repository) throws RepositoryException {
        RepositoryUtil.addBasicKnowledge(repository, this.getDefaultGraph(), this.importRdfAndRdfsVocabulary());
    }

    @Override
    public URI getDefaultGraph() {
        return URIs.createURI((String)"komma:default");
    }

    protected boolean importRdfAndRdfsVocabulary() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    static class RemoteRepositoryDataManager
    extends RDF4JRepositoryDataManager {
        @Inject
        public RemoteRepositoryDataManager(Repository repository, IDataChangeSupport changeSupport) {
            super(repository, changeSupport);
        }

        protected void setParameters(IDataManagerQuery<?> query, IReference subject, IReference predicate, IValue object) {
            if (subject != null) {
                query.setParameter("s", (IValue)subject);
            }
            if (predicate != null) {
                query.setParameter("p", (IValue)predicate);
            }
            if (object != null) {
                query.setParameter("o", object);
            }
        }

        protected IReference[] addNullContext(boolean includeInferred, IReference[] contexts) {
            if (includeInferred) {
                contexts = new IReference[]{};
            }
            return contexts;
        }

        public boolean hasMatch(IReference subject, IReference predicate, IValue object, boolean includeInferred, IReference ... contexts) {
            String query = contexts.length > 0 && !includeInferred ? "ASK { GRAPH ?g { ?s ?p ?o } }" : "ASK { ?s ?p ?o }";
            IDataManagerQuery dmQuery = this.createQuery(query, null, includeInferred, contexts);
            this.setParameters(dmQuery, subject, predicate, object);
            Object result = dmQuery.evaluate().next();
            return Boolean.TRUE.equals(result);
        }

        public IExtendedIterator<IStatement> match(IReference subject, IReference predicate, IValue object, boolean includeInferred, IReference ... contexts) {
            String query = contexts.length > 0 && !includeInferred ? "SELECT DISTINCT ?s ?p ?o ?g WHERE { GRAPH ?g { ?s ?p ?o } }" : "SELECT DISTINCT ?s ?p ?o WHERE { ?s ?p ?o }";
            IDataManagerQuery dmQuery = this.createQuery(query, null, includeInferred, contexts);
            this.setParameters(dmQuery, subject, predicate, object);
            return dmQuery.evaluate().mapWith((IMap)new IMap<Object, IStatement>(){

                public IStatement map(Object value) {
                    IBindings bindings = (IBindings)value;
                    return new Statement((IReference)bindings.get("s"), (IReference)bindings.get("p"), bindings.get("o"), (IReference)bindings.get("g"));
                }
            });
        }
    }

    static class RemoteRepositoryDataManagerFactory
    extends RDF4JDataManagerFactory {
        RemoteRepositoryDataManagerFactory() {
        }

        public IDataManager get() {
            return (IDataManager)this.injector.getInstance(RemoteRepositoryDataManager.class);
        }
    }
}

