/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.Statement;

public class GraphUtil {
    public static boolean equals(Iterable<? extends IStatement> graph1, Iterable<? extends IStatement> graph2) {
        LinkedHashSet<IStatement> set1 = new LinkedHashSet<IStatement>();
        for (IStatement iStatement : graph1) {
            set1.add(iStatement);
        }
        LinkedHashSet<IStatement> set2 = new LinkedHashSet<IStatement>();
        for (IStatement iStatement : graph2) {
            set2.add(iStatement);
        }
        return GraphUtil.equals(set1, set2);
    }

    public static boolean equals(Set<? extends IStatement> graph1, Set<? extends IStatement> graph2) {
        if (graph1.size() != graph2.size()) {
            return false;
        }
        return GraphUtil.isSubsetInternal(graph1, graph2);
    }

    public static boolean isSubset(Iterable<? extends IStatement> graph1, Iterable<? extends IStatement> graph2) {
        LinkedHashSet<IStatement> set1 = new LinkedHashSet<IStatement>();
        for (IStatement iStatement : graph1) {
            set1.add(iStatement);
        }
        LinkedHashSet<IStatement> set2 = new LinkedHashSet<IStatement>();
        for (IStatement iStatement : graph2) {
            set2.add(iStatement);
        }
        return GraphUtil.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> graph1, Set<? extends Statement> graph2) {
        if (graph1.size() > graph2.size()) {
            return false;
        }
        return GraphUtil.isSubsetInternal(graph1, graph2);
    }

    private static boolean isSubsetInternal(Set<? extends IStatement> graph1, Set<? extends IStatement> graph2) {
        return GraphUtil.matchModels(graph1, graph2);
    }

    private static boolean matchModels(Set<? extends IStatement> graph1, Set<? extends IStatement> graph2) {
        ArrayList<IStatement> graph1BNodes = new ArrayList<IStatement>(graph1.size());
        for (IStatement iStatement : graph1) {
            if (iStatement.getSubject().getURI() == null || iStatement.getObject() instanceof IReference && ((IReference)iStatement.getObject()).getURI() == null) {
                graph1BNodes.add(iStatement);
                continue;
            }
            if (graph2.contains(iStatement)) continue;
            return false;
        }
        return GraphUtil.matchModels(graph1BNodes, graph2, new HashMap<IReference, IReference>(), 0);
    }

    private static boolean matchModels(List<? extends IStatement> graph1, Iterable<? extends IStatement> graph2, Map<IReference, IReference> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < graph1.size()) {
            IStatement st1 = graph1.get(idx);
            List<IStatement> matchingStats = GraphUtil.findMatchingStatements(st1, graph2, bNodeMapping);
            for (IStatement st2 : matchingStats) {
                HashMap<IReference, IReference> newBNodeMapping = new HashMap<IReference, IReference>(bNodeMapping);
                if (st1.getSubject().getURI() == null && st2.getSubject().getURI() == null) {
                    newBNodeMapping.put(st1.getSubject(), st2.getSubject());
                }
                if (st1.getObject() instanceof IReference && ((IReference)st1.getObject()).getURI() == null && st2.getObject() instanceof IReference && ((IReference)st2.getObject()).getURI() == null) {
                    newBNodeMapping.put((IReference)st1.getObject(), (IReference)st2.getObject());
                }
                if (!(result = GraphUtil.matchModels(graph1, graph2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<IStatement> findMatchingStatements(IStatement st, Iterable<? extends IStatement> graph, Map<IReference, IReference> bNodeMapping) {
        ArrayList<IStatement> result = new ArrayList<IStatement>();
        for (IStatement iStatement : graph) {
            if (!GraphUtil.statementsMatch(st, iStatement, bNodeMapping)) continue;
            result.add(iStatement);
        }
        return result;
    }

    private static boolean statementsMatch(IStatement st1, IStatement st2, Map<IReference, IReference> bNodeMapping) {
        IReference mappedBNode;
        IReference mappedBNode2;
        IReference pred2;
        IReference pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        IReference subj1 = st1.getSubject();
        IReference subj2 = st2.getSubject();
        if (subj1.getURI() == null && subj2.getURI() == null ? ((mappedBNode2 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode2) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Object obj1 = st1.getObject();
        Object obj2 = st2.getObject();
        return !(obj1 instanceof IReference && ((IReference)obj1).getURI() == null && obj2 instanceof IReference && ((IReference)obj2).getURI() == null ? ((mappedBNode = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2));
    }
}

