/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.enilink.commons.iterator.Filter;
import net.enilink.commons.iterator.FilterIterator;
import net.enilink.komma.core.GraphUtil;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IStatementPattern;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.Statements;

public class LinkedHashGraph
extends AbstractSet<IStatement>
implements IGraph {
    private static final long serialVersionUID = -9161104123818983614L;
    static final IReference[] NULL_CTX = new IReference[]{null};
    transient Map<Object, GraphNode<Object>> values;
    transient Set<GraphStatement> statements;
    IGraph emptyGraph = new EmptyGraph();
    private static final IReference[] DEFAULT_CONTEXTS = new IReference[]{null};

    public LinkedHashGraph() {
        this.values = new HashMap<Object, GraphNode<Object>>();
        this.statements = new LinkedHashSet<GraphStatement>();
    }

    public LinkedHashGraph(Collection<? extends IStatement> c) {
        this.values = new HashMap<Object, GraphNode<Object>>(c.size() * 2);
        this.statements = new LinkedHashSet<GraphStatement>(c.size());
        this.addAll(c);
    }

    public LinkedHashGraph(int size) {
        this.values = new HashMap<Object, GraphNode<Object>>(size * 2);
        this.statements = new LinkedHashSet<GraphStatement>(size);
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    public boolean add(IStatement st) {
        return this.add(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
    }

    @Override
    public boolean add(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        IReference[] ctxs = LinkedHashGraph.notNull(contexts);
        if (ctxs.length == 0) {
            ctxs = NULL_CTX;
        }
        boolean changed = false;
        for (IReference ctx : ctxs) {
            GraphNode<IReference> s = this.asNode(subj);
            GraphNode<IReference> p = this.asNode(pred);
            GraphNode<Object> o = this.asNode(obj);
            GraphNode<IReference> c = this.asNode(ctx);
            GraphStatement st = new GraphStatement(s, p, o, c, false);
            changed |= this.addGraphStatement(st);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.values.clear();
        this.statements.clear();
    }

    @Override
    public boolean remove(Object o) {
        Iterator<?> iter;
        if (o instanceof Statement && (iter = this.find((Statement)o)).hasNext()) {
            iter.next();
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Statement) {
            return this.find((Statement)o).hasNext();
        }
        return false;
    }

    @Override
    public Iterator<IStatement> iterator() {
        return this.match(null, null, null, new IReference[0]);
    }

    @Override
    public boolean contains(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        return this.match(subj, pred, obj, contexts).hasNext();
    }

    @Override
    public boolean remove(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        GraphIterator iter = this.match(subj, pred, obj, contexts);
        if (!iter.hasNext()) {
            return false;
        }
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        return true;
    }

    @Override
    public boolean clear(IReference ... contexts) {
        return this.remove(null, null, null, contexts);
    }

    @Override
    public IGraph filter(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        return new FilteredGraph(subj, pred, obj, contexts);
    }

    @Override
    public Set<IReference> subjects() {
        return this.subjects(null, null, new IReference[0]);
    }

    @Override
    public Set<IReference> predicates() {
        return this.predicates(null, null, new IReference[0]);
    }

    @Override
    public Set<Object> objects() {
        return this.objects(null, null, new IReference[0]);
    }

    @Override
    public Set<IReference> contexts() {
        return this.contexts(null, null, null);
    }

    @Override
    public Object objectValue() throws KommaException {
        Iterator<Object> iter = this.objects().iterator();
        if (iter.hasNext()) {
            Object obj = iter.next();
            if (iter.hasNext()) {
                throw new KommaException();
            }
            return obj;
        }
        return null;
    }

    @Override
    public ILiteral objectLiteral() throws KommaException {
        Object obj = this.objectValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof ILiteral) {
            return (ILiteral)obj;
        }
        throw new KommaException();
    }

    @Override
    public IReference objectReference() throws KommaException {
        Object obj = this.objectValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof IReference) {
            return (IReference)obj;
        }
        throw new KommaException();
    }

    @Override
    public String objectString() throws KommaException {
        Object obj = this.objectValue();
        if (obj == null) {
            return null;
        }
        if (obj instanceof ILiteral) {
            return ((ILiteral)obj).getLabel();
        }
        return obj.toString();
    }

    @Override
    public void rename(IReference source, IReference target) {
        LinkedHashGraph.rename(this, source, target);
    }

    static void rename(IGraph graph, IReference source, IReference target) {
        Iterator it = graph.iterator();
        ArrayList<Statement> newStatements = new ArrayList<Statement>();
        while (it.hasNext()) {
            IStatement stmt = (IStatement)it.next();
            IReference s = stmt.getSubject();
            IReference p = stmt.getPredicate();
            Object o = stmt.getObject();
            boolean changed = false;
            if (source.equals(s)) {
                s = target;
                changed = true;
            }
            if (source.equals(p)) {
                p = target;
                changed = true;
            }
            if (source.equals(o)) {
                o = target;
                changed = true;
            }
            if (changed) {
                it.remove();
            }
            newStatements.add(new Statement(s, p, o, stmt.getContext()));
        }
        graph.addAll(newStatements);
    }

    @Override
    public int hashCode() {
        return this.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IGraph) {
            IGraph graph = (IGraph)o;
            return GraphUtil.equals(this, graph);
        }
        return false;
    }

    Set<IReference> contexts(final IReference subj, final IReference pred, final Object obj) {
        return new ObjectSet<IReference>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof IReference || o == null) {
                    return LinkedHashGraph.this.contains(subj, pred, obj, (IReference)o);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof IReference || o == null) {
                    return LinkedHashGraph.this.remove(subj, pred, obj, (IReference)o);
                }
                return false;
            }

            @Override
            public boolean add(IReference ctx) {
                if (subj == null || pred == null || obj == null) {
                    throw new UnsupportedOperationException("Incomplete statement");
                }
                if (this.contains(ctx)) {
                    return false;
                }
                return LinkedHashGraph.this.add(subj, pred, obj, ctx);
            }

            @Override
            public void clear() {
                LinkedHashGraph.this.remove(subj, pred, obj, new IReference[0]);
            }

            @Override
            protected GraphIterator statementIterator() {
                return LinkedHashGraph.this.match(subj, pred, obj, new IReference[0]);
            }

            @Override
            protected GraphNode<IReference> node(GraphStatement st) {
                return st.ctx;
            }

            @Override
            protected Set<GraphStatement> set(GraphNode<IReference> node) {
                return node.contexts;
            }
        };
    }

    Set<Object> objects(final IReference subj, final IReference pred, final IReference ... contexts) {
        return new ObjectSet<Object>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof Object) {
                    return LinkedHashGraph.this.contains(subj, pred, o, contexts);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Object) {
                    return LinkedHashGraph.this.remove(subj, pred, o, contexts);
                }
                return false;
            }

            @Override
            public boolean add(Object obj) {
                if (subj == null || pred == null) {
                    throw new UnsupportedOperationException("Incomplete statement");
                }
                if (this.contains(obj)) {
                    return false;
                }
                return LinkedHashGraph.this.add(subj, pred, obj, contexts);
            }

            @Override
            public void clear() {
                LinkedHashGraph.this.remove(subj, pred, null, contexts);
            }

            @Override
            protected GraphIterator statementIterator() {
                return LinkedHashGraph.this.match(subj, pred, null, contexts);
            }

            @Override
            protected GraphNode<Object> node(GraphStatement st) {
                return st.obj;
            }

            @Override
            protected Set<GraphStatement> set(GraphNode<Object> node) {
                return node.objects;
            }
        };
    }

    Set<IReference> predicates(final IReference subj, final Object obj, final IReference ... contexts) {
        return new ObjectSet<IReference>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof IReference) {
                    return LinkedHashGraph.this.contains(subj, (IReference)o, obj, contexts);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof IReference) {
                    return LinkedHashGraph.this.remove(subj, (IReference)o, obj, contexts);
                }
                return false;
            }

            @Override
            public boolean add(IReference pred) {
                if (subj == null || obj == null) {
                    throw new UnsupportedOperationException("Incomplete statement");
                }
                if (this.contains(pred)) {
                    return false;
                }
                return LinkedHashGraph.this.add(subj, pred, obj, contexts);
            }

            @Override
            public void clear() {
                LinkedHashGraph.this.remove(subj, null, obj, contexts);
            }

            @Override
            protected GraphIterator statementIterator() {
                return LinkedHashGraph.this.match(subj, null, obj, contexts);
            }

            @Override
            protected GraphNode<IReference> node(GraphStatement st) {
                return st.pred;
            }

            @Override
            protected Set<GraphStatement> set(GraphNode<IReference> node) {
                return node.predicates;
            }
        };
    }

    Set<IReference> subjects(final IReference pred, final Object obj, final IReference ... contexts) {
        return new ObjectSet<IReference>(){

            @Override
            public boolean contains(Object o) {
                if (o instanceof IReference) {
                    return LinkedHashGraph.this.contains((IReference)o, pred, obj, contexts);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof IReference) {
                    return LinkedHashGraph.this.remove((IReference)o, pred, obj, contexts);
                }
                return false;
            }

            @Override
            public boolean add(IReference subj) {
                if (pred == null || obj == null) {
                    throw new UnsupportedOperationException("Incomplete statement");
                }
                if (this.contains(subj)) {
                    return false;
                }
                return LinkedHashGraph.this.add(subj, pred, obj, contexts);
            }

            @Override
            public void clear() {
                LinkedHashGraph.this.remove(null, pred, obj, contexts);
            }

            @Override
            protected GraphIterator statementIterator() {
                return LinkedHashGraph.this.match(null, pred, obj, contexts);
            }

            @Override
            protected GraphNode<IReference> node(GraphStatement st) {
                return st.subj;
            }

            @Override
            protected Set<GraphStatement> set(GraphNode<IReference> node) {
                return node.subjects;
            }
        };
    }

    protected GraphIterator match(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        Set<GraphStatement> set;
        assert (contexts != null);
        Set<GraphStatement> s = null;
        Set<GraphStatement> p = null;
        Set<GraphStatement> o = null;
        if (subj != null) {
            if (!this.values.containsKey(subj)) {
                return this.emptyGraphIterator();
            }
            s = this.values.get((Object)subj).subjects;
        }
        if (pred != null) {
            if (!this.values.containsKey(pred)) {
                return this.emptyGraphIterator();
            }
            p = this.values.get((Object)pred).predicates;
        }
        if (obj != null) {
            if (!this.values.containsKey(obj)) {
                return this.emptyGraphIterator();
            }
            o = this.values.get((Object)obj).objects;
        }
        if ((contexts = LinkedHashGraph.notNull(contexts)).length == 1) {
            if (!this.values.containsKey(contexts[0])) {
                return this.emptyGraphIterator();
            }
            Set<GraphStatement> c = this.values.get((Object)contexts[0]).contexts;
            set = this.smallest(this.statements, s, p, o, c);
        } else {
            set = this.smallest(this.statements, s, p, o);
        }
        return new GraphIterator((Iterator<GraphStatement>)((Object)new PatternIterator(set.iterator(), subj, pred, obj, contexts)), set);
    }

    boolean matches(IStatement st, IReference subj, IReference pred, Object obj, IReference ... contexts) {
        if (subj != null && !subj.equals(st.getSubject())) {
            return false;
        }
        if (pred != null && !pred.equals(st.getPredicate())) {
            return false;
        }
        if (obj != null && !obj.equals(st.getObject())) {
            return false;
        }
        return this.matches(st.getContext(), contexts);
    }

    boolean matches(IReference[] stContext, IReference ... contexts) {
        if (stContext != null && stContext.length > 0) {
            for (IReference c : stContext) {
                if (this.matches(c, contexts)) continue;
                return false;
            }
        }
        return true;
    }

    boolean matches(IReference stContext, IReference ... contexts) {
        if (contexts != null && contexts.length == 0) {
            return true;
        }
        for (IReference context : LinkedHashGraph.notNull(contexts)) {
            if (context == null && stContext == null) {
                return true;
            }
            if (context == null || !context.equals(stContext)) continue;
            return true;
        }
        return false;
    }

    protected IGraph emptyGraph() {
        return this.emptyGraph;
    }

    GraphIterator emptyGraphIterator() {
        Set<GraphStatement> set = Collections.emptySet();
        return new GraphIterator(set.iterator(), set);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.statements.size());
        for (GraphStatement st : this.statements) {
            IReference subj = st.getSubject();
            IReference pred = st.getPredicate();
            Object obj = st.getObject();
            IReference ctx = st.getContext();
            s.writeObject(new Statement(subj, pred, obj, ctx));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.values = new HashMap<Object, GraphNode<Object>>(size * 2);
        this.statements = new LinkedHashSet<GraphStatement>(size);
        for (int i = 0; i < size; ++i) {
            Statement st = (Statement)s.readObject();
            this.add(st);
        }
    }

    private Iterator<?> find(Statement st) {
        IReference subj = st.getSubject();
        IReference pred = st.getPredicate();
        Object obj = st.getObject();
        IReference ctx = st.getContext();
        return this.match(subj, pred, obj, ctx);
    }

    private boolean addGraphStatement(GraphStatement st) {
        Set<GraphStatement> subj = st.subj.subjects;
        Set<GraphStatement> pred = st.pred.predicates;
        Set<GraphStatement> obj = st.obj.objects;
        Set<GraphStatement> ctx = st.ctx.contexts;
        if (this.smallest(subj, pred, obj, ctx).contains(st)) {
            return false;
        }
        this.statements.add(st);
        subj.add(st);
        pred.add(st);
        obj.add(st);
        ctx.add(st);
        return true;
    }

    @SafeVarargs
    private final <V> Set<V> smallest(Set<V> ... sets) {
        int minSize = Integer.MAX_VALUE;
        Set<V> minSet = null;
        for (Set<V> set : sets) {
            if (set == null || set.size() >= minSize) continue;
            minSet = set;
        }
        return minSet;
    }

    private <V> GraphNode<V> asNode(V value) {
        if (this.values.containsKey(value)) {
            return this.values.get(value);
        }
        GraphNode<V> node = new GraphNode<V>(value);
        this.values.put(value, node);
        return node;
    }

    public static IReference[] notNull(IReference ... contexts) {
        if (contexts == null) {
            return DEFAULT_CONTEXTS;
        }
        return contexts;
    }

    protected class PatternIterator<S extends IStatement>
    extends FilterIterator<S> {
        public PatternIterator(Iterator<S> iter, final IReference subj, final IReference pred, final Object obj, final IReference ... contexts) {
            super(new Filter<S>(){
                IReference[] ctxs;
                {
                    this.ctxs = LinkedHashGraph.notNull(contexts);
                }

                public boolean accept(S st) {
                    return LinkedHashGraph.this.matches((IStatement)st, subj, pred, obj, this.ctxs);
                }
            }, iter);
        }
    }

    protected class GraphStatement
    implements IStatement {
        GraphNode<IReference> subj;
        GraphNode<IReference> pred;
        GraphNode<Object> obj;
        GraphNode<IReference> ctx;
        boolean isInferred;

        public GraphStatement(GraphNode<IReference> subj, GraphNode<IReference> pred, GraphNode<Object> obj, GraphNode<IReference> ctx, boolean isInferred) {
            assert (subj != null);
            assert (pred != null);
            assert (obj != null);
            assert (ctx != null);
            this.subj = subj;
            this.pred = pred;
            this.obj = obj;
            this.ctx = ctx;
            this.isInferred = isInferred;
        }

        @Override
        public IReference getSubject() {
            return this.subj.getObject();
        }

        @Override
        public IReference getPredicate() {
            return this.pred.getObject();
        }

        @Override
        public Object getObject() {
            return this.obj.getObject();
        }

        @Override
        public IReference getContext() {
            return this.ctx.getObject();
        }

        @Override
        public boolean isInferred() {
            return this.isInferred;
        }

        @Override
        public boolean equalsIgnoreContext(IStatementPattern other) {
            return Statements.equalsIgnoreContext((IStatementPattern)this, other);
        }

        @Override
        public boolean equals(Object obj) {
            return Statements.equals((IStatementPattern)this, obj);
        }

        @Override
        public int hashCode() {
            return Statements.hashCode(this);
        }

        public String toString() {
            return Statements.toString(this);
        }

        @Override
        public Iterator<IStatement> iterator() {
            return Collections.singleton(this).iterator();
        }
    }

    protected class GraphNode<V>
    implements Serializable {
        private static final long serialVersionUID = -1205676084606998540L;
        Set<GraphStatement> subjects = new LinkedHashSet<GraphStatement>();
        Set<GraphStatement> predicates = new LinkedHashSet<GraphStatement>();
        Set<GraphStatement> objects = new LinkedHashSet<GraphStatement>();
        Set<GraphStatement> contexts = new LinkedHashSet<GraphStatement>();
        private V value;

        public GraphNode(V value) {
            this.value = value;
        }

        public V getObject() {
            return this.value;
        }

        public boolean isNull() {
            return this.value == null;
        }
    }

    protected class GraphIterator
    implements Iterator<IStatement> {
        private Iterator<GraphStatement> iter;
        private Set<GraphStatement> owner;
        private GraphStatement last;

        public GraphIterator(Iterator<GraphStatement> iter, Set<GraphStatement> owner) {
            this.iter = iter;
            this.owner = owner;
        }

        public Set<GraphStatement> getOwner() {
            return this.owner;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public GraphStatement next() {
            this.last = this.iter.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.removeIfNotOwner(LinkedHashGraph.this.statements);
            this.removeIfNotOwner(this.last.subj.subjects);
            this.removeIfNotOwner(this.last.pred.predicates);
            this.removeIfNotOwner(this.last.obj.objects);
            this.removeIfNotOwner(this.last.ctx.contexts);
            this.iter.remove();
        }

        private void removeIfNotOwner(Set<GraphStatement> subjects) {
            if (subjects != this.owner) {
                subjects.remove(this.last);
            }
        }
    }

    protected abstract class ObjectSet<V>
    extends AbstractSet<V> {
        protected ObjectSet() {
        }

        @Override
        public Iterator<V> iterator() {
            final LinkedHashSet set = new LinkedHashSet();
            final GraphIterator iter = this.statementIterator();
            return new Iterator<V>(){
                private GraphStatement current;
                private GraphStatement next;

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        this.next = this.findNext();
                    }
                    return this.next != null;
                }

                @Override
                public V next() {
                    if (this.next == null) {
                        this.next = this.findNext();
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                    }
                    this.current = this.next;
                    this.next = null;
                    Object value = this.convert(this.current);
                    set.add(value);
                    return value;
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    ObjectSet.this.removeAll(ObjectSet.this.set(ObjectSet.this.node(this.current)), iter.getOwner());
                    this.current = null;
                }

                private GraphStatement findNext() {
                    while (iter.hasNext()) {
                        GraphStatement st = iter.next();
                        if (!this.accept(st)) continue;
                        return st;
                    }
                    return null;
                }

                private boolean accept(GraphStatement st) {
                    return !set.contains(this.convert(st));
                }

                private V convert(GraphStatement st) {
                    return ObjectSet.this.node(st).getObject();
                }
            };
        }

        @Override
        public int size() {
            LinkedHashSet<V> set = new LinkedHashSet<V>();
            GraphIterator iter = this.statementIterator();
            while (iter.hasNext()) {
                set.add(this.node((GraphStatement)iter.next()).getObject());
            }
            return set.size();
        }

        @Override
        public boolean remove(Object o) {
            if (LinkedHashGraph.this.values.containsKey(o)) {
                return this.removeAll(this.set(LinkedHashGraph.this.values.get(o)), null);
            }
            return false;
        }

        protected abstract GraphIterator statementIterator();

        protected abstract GraphNode<V> node(GraphStatement var1);

        protected abstract Set<GraphStatement> set(GraphNode<V> var1);

        boolean removeAll(Set<GraphStatement> remove, Set<GraphStatement> owner) {
            if (remove.isEmpty()) {
                return false;
            }
            for (GraphStatement st : remove) {
                GraphNode<IReference> subj = st.subj;
                Set<GraphStatement> subjects = subj.subjects;
                if (subjects == owner) {
                    subj.subjects = new LinkedHashSet<GraphStatement>(owner);
                    subj.subjects.removeAll(remove);
                } else if (subjects != remove) {
                    subjects.remove(st);
                }
                GraphNode<IReference> pred = st.pred;
                Set<GraphStatement> predicates = pred.predicates;
                if (predicates == owner) {
                    pred.predicates = new LinkedHashSet<GraphStatement>(owner);
                    pred.predicates.removeAll(remove);
                } else if (predicates != remove) {
                    predicates.remove(st);
                }
                GraphNode<Object> obj = st.obj;
                Set<GraphStatement> objects = obj.objects;
                if (objects == owner) {
                    obj.objects = new LinkedHashSet<GraphStatement>(owner);
                    obj.objects.removeAll(remove);
                } else if (objects != remove) {
                    objects.remove(st);
                }
                GraphNode<IReference> ctx = st.ctx;
                Set<GraphStatement> contexts = ctx.contexts;
                if (contexts == owner) {
                    ctx.contexts = new LinkedHashSet<GraphStatement>(owner);
                    ctx.contexts.removeAll(remove);
                } else if (contexts != remove) {
                    contexts.remove(st);
                }
                if (LinkedHashGraph.this.statements == owner) {
                    LinkedHashGraph.this.statements = new LinkedHashSet<GraphStatement>(LinkedHashGraph.this.statements);
                    LinkedHashGraph.this.statements.removeAll(remove);
                    continue;
                }
                if (LinkedHashGraph.this.statements == remove || LinkedHashGraph.this.statements == owner) continue;
                LinkedHashGraph.this.statements.remove(st);
            }
            remove.clear();
            return true;
        }
    }

    protected class FilteredGraph
    extends AbstractSet<IStatement>
    implements IGraph {
        private static final long serialVersionUID = -2353344619836326934L;
        protected IReference subj;
        protected IReference pred;
        protected Object obj;
        protected IReference[] contexts;

        public FilteredGraph(IReference subj, IReference pred, Object obj, IReference ... contexts) {
            this.subj = subj;
            this.pred = pred;
            this.obj = obj;
            this.contexts = LinkedHashGraph.notNull(contexts);
        }

        @Override
        public Iterator<IStatement> iterator() {
            return LinkedHashGraph.this.match(this.subj, this.pred, this.obj, this.contexts);
        }

        @Override
        public int size() {
            int size = 0;
            Iterator<IStatement> iter = this.iterator();
            while (iter.hasNext()) {
                ++size;
                iter.next();
            }
            return size;
        }

        @Override
        public boolean contains(Object o) {
            Statement st;
            if (o instanceof Statement && this.accept(st = (Statement)o)) {
                return LinkedHashGraph.this.contains(o);
            }
            return false;
        }

        @Override
        public boolean add(IStatement st) {
            if (this.accept(st)) {
                return LinkedHashGraph.this.add(st);
            }
            throw new IllegalArgumentException("Statement is filtered out of view: " + st);
        }

        @Override
        public boolean add(IReference s, IReference p, Object o, IReference ... c) {
            if (!this.accept(s, p, o, c)) {
                throw new IllegalArgumentException("Statement is filtered out of view");
            }
            if (s == null) {
                s = this.subj;
            }
            if (p == null) {
                p = this.pred;
            }
            if (o == null) {
                o = this.obj;
            }
            if (c != null && c.length == 0) {
                c = this.contexts;
            }
            return LinkedHashGraph.this.add(s, p, o, c);
        }

        @Override
        public void clear() {
            LinkedHashGraph.this.remove(this.subj, this.pred, this.obj, this.contexts);
        }

        @Override
        public boolean clear(IReference ... c) {
            if ((c = LinkedHashGraph.notNull(c)).length == 0) {
                return this.remove(this.subj, this.pred, this.obj, this.contexts);
            }
            if (LinkedHashGraph.this.matches(c, this.contexts)) {
                return LinkedHashGraph.this.remove(this.subj, this.pred, this.obj, c);
            }
            return false;
        }

        @Override
        public boolean remove(IReference s, IReference p, Object o, IReference ... c) {
            if (!this.accept(s, p, o, c)) {
                return false;
            }
            if (s == null) {
                s = this.subj;
            }
            if (p == null) {
                p = this.pred;
            }
            if (o == null) {
                o = this.obj;
            }
            if (c != null && c.length == 0) {
                c = this.contexts;
            }
            return LinkedHashGraph.this.remove(s, p, o, c);
        }

        @Override
        public boolean contains(IReference s, IReference p, Object o, IReference ... c) {
            if (!this.accept(s, p, o, c)) {
                return false;
            }
            if (s == null) {
                s = this.subj;
            }
            if (p == null) {
                p = this.pred;
            }
            if (o == null) {
                o = this.obj;
            }
            if (c != null && c.length == 0) {
                c = this.contexts;
            }
            return LinkedHashGraph.this.contains(s, p, o, c);
        }

        @Override
        public IGraph filter(IReference s, IReference p, Object o, IReference ... c) {
            if (!this.accept(s, p, o, c)) {
                return LinkedHashGraph.this.emptyGraph();
            }
            if (s == null) {
                s = this.subj;
            }
            if (p == null) {
                p = this.pred;
            }
            if (o == null) {
                o = this.obj;
            }
            if (c != null && c.length == 0) {
                c = this.contexts;
            }
            return LinkedHashGraph.this.filter(s, p, o, c);
        }

        @Override
        public Set<IReference> contexts() {
            if (this.contexts != null && this.contexts.length > 0) {
                return Collections.unmodifiableSet(new LinkedHashSet<IReference>(Arrays.asList(this.contexts)));
            }
            return LinkedHashGraph.this.contexts(this.subj, this.pred, this.obj);
        }

        @Override
        public Set<Object> objects() {
            if (this.obj != null) {
                return Collections.singleton(this.obj);
            }
            return LinkedHashGraph.this.objects(this.subj, this.pred, this.contexts);
        }

        @Override
        public Set<IReference> predicates() {
            if (this.pred != null) {
                return Collections.singleton(this.pred);
            }
            return LinkedHashGraph.this.predicates(this.subj, this.obj, this.contexts);
        }

        @Override
        public Set<IReference> subjects() {
            if (this.subj != null) {
                return Collections.singleton(this.subj);
            }
            return LinkedHashGraph.this.subjects(this.pred, this.obj, this.contexts);
        }

        @Override
        public Object objectValue() throws KommaException {
            Iterator<Object> iter = this.objects().iterator();
            if (iter.hasNext()) {
                Object obj = iter.next();
                if (iter.hasNext()) {
                    throw new KommaException();
                }
                return obj;
            }
            return null;
        }

        @Override
        public ILiteral objectLiteral() throws KommaException {
            Object obj = this.objectValue();
            if (obj == null) {
                return null;
            }
            if (obj instanceof ILiteral) {
                return (ILiteral)obj;
            }
            throw new KommaException();
        }

        @Override
        public IReference objectReference() throws KommaException {
            Object obj = this.objectValue();
            if (obj == null) {
                return null;
            }
            if (obj instanceof IReference) {
                return (IReference)obj;
            }
            throw new KommaException();
        }

        @Override
        public String objectString() throws KommaException {
            Object obj = this.objectValue();
            if (obj == null) {
                return null;
            }
            if (obj instanceof ILiteral) {
                return ((ILiteral)obj).getLabel();
            }
            return obj.toString();
        }

        @Override
        public void rename(IReference source, IReference target) {
            LinkedHashGraph.rename(this, source, target);
        }

        @Override
        public int hashCode() {
            return this.size();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IGraph) {
                IGraph model = (IGraph)o;
                return GraphUtil.equals(this, model);
            }
            return false;
        }

        private boolean accept(IStatement st) {
            return LinkedHashGraph.this.matches(st, this.subj, this.pred, this.obj, this.contexts);
        }

        private boolean accept(IReference s, IReference p, Object o, IReference ... c) {
            if (this.subj != null && !this.subj.equals(s)) {
                return false;
            }
            if (this.pred != null && !this.pred.equals(p)) {
                return false;
            }
            if (this.obj != null && !this.obj.equals(o)) {
                return false;
            }
            return LinkedHashGraph.this.matches(LinkedHashGraph.notNull(c), this.contexts);
        }
    }

    protected class EmptyGraph
    extends AbstractSet<IStatement>
    implements IGraph {
        private static final long serialVersionUID = 3123007631452759092L;
        private Set<IStatement> emptySet = Collections.emptySet();

        protected EmptyGraph() {
        }

        @Override
        public Iterator<IStatement> iterator() {
            return this.emptySet.iterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean add(IStatement e) {
            throw new UnsupportedOperationException("All statements are filtered out of view");
        }

        @Override
        public boolean add(IReference subj, IReference pred, Object obj, IReference ... contexts) {
            throw new UnsupportedOperationException("All statements are filtered out of view");
        }

        @Override
        public boolean clear(IReference ... context) {
            return false;
        }

        @Override
        public boolean contains(IReference subj, IReference pred, Object obj, IReference ... contexts) {
            return false;
        }

        @Override
        public Set<IReference> contexts() {
            return Collections.emptySet();
        }

        @Override
        public IGraph filter(IReference subj, IReference pred, Object obj, IReference ... contexts) {
            return LinkedHashGraph.this.emptyGraph();
        }

        @Override
        public Set<Object> objects() {
            return Collections.emptySet();
        }

        @Override
        public Set<IReference> predicates() {
            return Collections.emptySet();
        }

        @Override
        public boolean remove(IReference subj, IReference pred, Object obj, IReference ... contexts) {
            return false;
        }

        @Override
        public Set<IReference> subjects() {
            return Collections.emptySet();
        }

        @Override
        public ILiteral objectLiteral() {
            return null;
        }

        @Override
        public Object objectValue() {
            return null;
        }

        @Override
        public IReference objectReference() {
            return null;
        }

        @Override
        public String objectString() {
            return null;
        }

        @Override
        public void rename(IReference source, IReference target) {
        }

        @Override
        public int hashCode() {
            return this.size();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IGraph) {
                IGraph model = (IGraph)o;
                return model.isEmpty();
            }
            return false;
        }
    }
}

