/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.Literals;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;

public class Literal
implements ILiteral {
    public static final URI RDF_NAMESPACE_URI = URIs.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    public static final URI XMLSCHEMA_NAMESPACE_URI = URIs.createURI("http://www.w3.org/2001/XMLSchema#");
    public static final URI TYPE_STRING = XMLSCHEMA_NAMESPACE_URI.appendFragment("string");
    public static final URI TYPE_LANGSTRING = RDF_NAMESPACE_URI.appendFragment("langString");
    protected URI datatype;
    protected String language;
    protected String label;

    public Literal(String label) {
        this(label, TYPE_STRING, null);
    }

    public Literal(String label, String language) {
        this(label, TYPE_LANGSTRING, language);
    }

    public Literal(String label, URI datatype) {
        this(label, datatype, null);
    }

    protected Literal(String label, URI datatype, String language) {
        assert (label != null);
        this.label = label;
        if (language != null) {
            this.language = language.toLowerCase();
        }
        if (datatype == null) {
            datatype = language == null ? TYPE_STRING : TYPE_LANGSTRING;
        }
        this.datatype = datatype;
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object obj) {
        return Literals.equals((ILiteral)this, obj);
    }

    public int hashCode() {
        return Literals.hashCode(this);
    }

    @Override
    public String toString() {
        return Literals.toString(this);
    }
}

