/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.util.Locale;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.URI;

public class Literals {
    public static boolean equals(ILiteral literal, ILiteral other) {
        URI datatype = literal.getDatatype();
        URI otherDatatype = other.getDatatype();
        if (datatype == null ? otherDatatype != null : !datatype.equals(otherDatatype)) {
            return false;
        }
        String language = literal.getLanguage();
        String otherLanguage = other.getLanguage();
        if (language == null ? otherLanguage != null : !language.equals(otherLanguage)) {
            return false;
        }
        return literal.getLabel().equals(other.getLabel());
    }

    public static boolean equals(ILiteral literal, Object obj) {
        if (literal == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ILiteral)) {
            return false;
        }
        return Literals.equals(literal, (ILiteral)obj);
    }

    public static int hashCode(ILiteral literal) {
        int prime = 31;
        int result = 1;
        URI datatype = literal.getDatatype();
        result = 31 * result + (datatype == null ? 0 : datatype.hashCode());
        String language = literal.getLanguage();
        result = 31 * result + (language == null ? 0 : language.hashCode());
        result = 31 * result + literal.getLabel().hashCode();
        return result;
    }

    public static String toString(ILiteral literal) {
        StringBuilder result = new StringBuilder("\"");
        Literals.escapeTurtle(result, literal.getLabel());
        result.append("\"");
        String language = literal.getLanguage();
        if (language != null) {
            result.append("@").append(language);
        } else {
            URI datatype = literal.getDatatype();
            if (datatype != null) {
                result.append("^^<").append(datatype.toString()).append(">");
            }
        }
        return result.toString();
    }

    public static String escapeTurtle(String str) {
        return Literals.escapeTurtle(new StringBuilder(), str).toString();
    }

    private static String toHex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    private static StringBuilder escapeTurtle(StringBuilder sb, String str) {
        if (str == null) {
            return sb;
        }
        int length = str.length();
        block11: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                sb.append("\\u" + Literals.toHex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                sb.append("\\u0" + Literals.toHex(ch));
                continue;
            }
            if (ch > '\u007f') {
                sb.append("\\u00" + Literals.toHex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        sb.append('\\');
                        sb.append('b');
                        break;
                    }
                    case '\n': {
                        sb.append('\\');
                        sb.append('n');
                        break;
                    }
                    case '\t': {
                        sb.append('\\');
                        sb.append('t');
                        break;
                    }
                    case '\f': {
                        sb.append('\\');
                        sb.append('f');
                        break;
                    }
                    case '\r': {
                        sb.append('\\');
                        sb.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            sb.append("\\u00" + Literals.toHex(ch));
                            break;
                        }
                        sb.append("\\u000" + Literals.toHex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    sb.append('\\');
                    sb.append('\"');
                    continue block11;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block11;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    private Literals() {
    }
}

