/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatementPattern;

public class Statements {
    private static boolean contextEquals(IStatementPattern stmt, IStatementPattern other) {
        if (stmt.getContext() == null) {
            return other.getContext() == null;
        }
        return stmt.getContext().equals(other.getContext());
    }

    public static boolean equals(IStatementPattern stmt, IStatementPattern other) {
        return stmt == other || stmt != null && other != null && Statements.spoEquals(stmt, other) && Statements.contextEquals(stmt, other);
    }

    public static boolean equals(IStatementPattern stmt, Object other) {
        if (other instanceof IStatementPattern) {
            return Statements.equals(stmt, (IStatementPattern)other);
        }
        return false;
    }

    public static boolean equalsIgnoreContext(IStatementPattern stmt, IStatementPattern other) {
        return stmt == other || stmt != null && other != null && Statements.spoEquals(stmt, other);
    }

    public static boolean equalsIgnoreContext(IStatementPattern stmt, Object other) {
        if (other instanceof IStatementPattern) {
            return Statements.equalsIgnoreContext(stmt, (IStatementPattern)other);
        }
        return false;
    }

    public static int hashCode(IStatementPattern stmt) {
        Object object;
        IReference predicate;
        int prime = 31;
        IReference ctx = stmt.getContext();
        int result = ctx == null ? 0 : ctx.hashCode();
        IReference subject = stmt.getSubject();
        if (subject != null) {
            result = 31 * result + subject.hashCode();
        }
        if ((predicate = stmt.getPredicate()) != null) {
            result = 31 * result + predicate.hashCode();
        }
        if ((object = stmt.getObject()) != null) {
            result = 31 * result + object.hashCode();
        }
        return result;
    }

    public static boolean matches(IStatementPattern stmt, IStatementPattern pattern) {
        IReference context;
        if (!Statements.matchesIgnoreContext(stmt, pattern)) {
            return false;
        }
        return stmt == null || pattern == null || (context = pattern.getContext()) == null || context.equals(pattern.getContext());
    }

    public static boolean matchesIgnoreContext(IStatementPattern stmt, IStatementPattern pattern) {
        if (stmt == pattern) {
            return true;
        }
        if (stmt == null || pattern == null) {
            return false;
        }
        Object o = pattern.getObject();
        if (o != null && !o.equals(pattern.getObject())) {
            return false;
        }
        IReference s = pattern.getSubject();
        if (s != null && !s.equals(pattern.getSubject())) {
            return false;
        }
        IReference p = pattern.getPredicate();
        return p == null || p.equals(pattern.getPredicate());
    }

    private static boolean spoEquals(IStatementPattern stmt, IStatementPattern other) {
        IReference otherPredicate;
        IReference otherSubject;
        Object otherObject;
        Object object = stmt.getObject();
        if (!(object == (otherObject = other.getObject()) || object != null && object.equals(otherObject))) {
            return false;
        }
        IReference subject = stmt.getSubject();
        if (!(subject == (otherSubject = other.getSubject()) || subject != null && subject.equals(otherSubject))) {
            return false;
        }
        IReference predicate = stmt.getPredicate();
        return predicate == (otherPredicate = other.getPredicate()) || predicate != null && predicate.equals(otherPredicate);
    }

    public static String toString(IStatementPattern stmt) {
        StringBuilder sb = new StringBuilder(256).append("(").append(stmt.getSubject()).append(", ").append(stmt.getPredicate()).append(", ").append(stmt.getObject()).append(")");
        IReference ctx = stmt.getContext();
        if (ctx != null) {
            sb.append(" [").append(ctx).append("]");
        }
        return sb.toString();
    }

    private Statements() {
    }
}

