/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;

final class URIImpl
implements URI {
    private final int hashCode;
    private final boolean hierarchical;
    private final String scheme;
    private final String authority;
    private final String fragment;
    private URIImpl cachedNamespace;
    private URIImpl cachedTrimFragment;
    private String cachedToString;
    private final String device;
    private final boolean absolutePath;
    private final String[] segments;
    private final String query;

    URIImpl(boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query, String fragment) {
        int hashCode = 0;
        if (hierarchical) {
            ++hashCode;
        }
        if (absolutePath) {
            hashCode += 2;
        }
        if (scheme != null) {
            hashCode ^= scheme.toLowerCase().hashCode();
        }
        if (authority != null) {
            hashCode ^= authority.hashCode();
        }
        if (device != null) {
            hashCode ^= device.hashCode();
        }
        if (query != null) {
            hashCode ^= query.hashCode();
        }
        if (fragment != null) {
            hashCode ^= fragment.hashCode();
        }
        int len = segments.length;
        for (int i = 0; i < len; ++i) {
            hashCode ^= segments[i].hashCode();
        }
        this.hashCode = hashCode;
        this.hierarchical = hierarchical;
        this.scheme = scheme == null ? null : scheme.intern();
        this.authority = authority;
        this.device = device;
        this.absolutePath = absolutePath;
        this.segments = segments;
        this.query = query;
        this.fragment = fragment;
    }

    @Override
    public boolean isRelative() {
        return this.scheme == null;
    }

    @Override
    public boolean isHierarchical() {
        return this.hierarchical;
    }

    @Override
    public boolean hasAuthority() {
        return this.hierarchical && this.authority != null;
    }

    @Override
    public boolean hasOpaquePart() {
        return !this.hierarchical;
    }

    @Override
    public boolean hasDevice() {
        return this.device != null;
    }

    @Override
    public boolean hasPath() {
        return this.absolutePath || this.authority == null && this.device == null;
    }

    @Override
    public boolean hasAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public boolean hasRelativePath() {
        return this.authority == null && this.device == null && !this.absolutePath;
    }

    @Override
    public boolean hasEmptyPath() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0;
    }

    @Override
    public boolean hasQuery() {
        return this.query != null;
    }

    @Override
    public boolean hasFragment() {
        return this.fragment != null;
    }

    @Override
    public boolean isCurrentDocumentReference() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0 && this.query == null;
    }

    @Override
    public boolean isEmpty() {
        return this.authority == null && this.device == null && !this.absolutePath && this.segments.length == 0 && this.query == null && this.fragment == null;
    }

    @Override
    public boolean isFile() {
        return this.isHierarchical() && (this.isRelative() && !this.hasQuery() || "file".equalsIgnoreCase(this.scheme));
    }

    @Override
    public boolean isPlatform() {
        return this.isHierarchical() && !this.hasAuthority() && this.segmentCount() >= 2 && "platform".equalsIgnoreCase(this.scheme);
    }

    @Override
    public boolean isPlatformResource() {
        return this.isPlatform() && "resource".equals(this.segments[0]);
    }

    @Override
    public boolean isPlatformPlugin() {
        return this.isPlatform() && "plugin".equals(this.segments[0]);
    }

    @Override
    public boolean isArchive() {
        return URIs.isArchiveScheme(this.scheme);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IReference) {
            object = ((IReference)object).getURI();
        }
        if (!(object instanceof URIImpl)) {
            return false;
        }
        URIImpl uri = (URIImpl)object;
        return this.hashCode == uri.hashCode() && this.hierarchical == uri.isHierarchical() && this.absolutePath == uri.hasAbsolutePath() && URIImpl.equals(this.scheme, uri.scheme(), true) && URIImpl.equals(this.authority, this.hierarchical ? uri.authority() : uri.opaquePart()) && URIImpl.equals(this.device, uri.device()) && URIImpl.equals(this.query, uri.query()) && URIImpl.equals(this.fragment, uri.fragment()) && this.segmentsEqual(uri);
    }

    private boolean segmentsEqual(URI uri) {
        if (this.segments.length != uri.segmentCount()) {
            return false;
        }
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            if (this.segments[i].equals(uri.segment(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean equals(String s1, String s2, boolean ignoreCase) {
        return s1 == null ? s2 == null : (ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2));
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String opaquePart() {
        return this.isHierarchical() ? null : this.authority;
    }

    @Override
    public String authority() {
        return this.isHierarchical() ? this.authority : null;
    }

    @Override
    public String userInfo() {
        if (!this.hasAuthority()) {
            return null;
        }
        int i = this.authority.indexOf(64);
        return i < 0 ? null : this.authority.substring(0, i);
    }

    @Override
    public String host() {
        if (!this.hasAuthority()) {
            return null;
        }
        int i = this.authority.indexOf(64);
        int j = this.authority.indexOf(58);
        return j < 0 ? this.authority.substring(i + 1) : this.authority.substring(i + 1, j);
    }

    @Override
    public String port() {
        if (!this.hasAuthority()) {
            return null;
        }
        int i = this.authority.indexOf(58);
        return i < 0 ? null : this.authority.substring(i + 1);
    }

    @Override
    public String device() {
        return this.device;
    }

    @Override
    public String[] segments() {
        return (String[])this.segments.clone();
    }

    @Override
    public List<String> segmentsList() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    @Override
    public int segmentCount() {
        return this.segments.length;
    }

    @Override
    public String segment(int i) {
        return this.segments[i];
    }

    @Override
    public String lastSegment() {
        int len = this.segments.length;
        if (len == 0) {
            return null;
        }
        return this.segments[len - 1];
    }

    @Override
    public String path() {
        if (!this.hasPath()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (this.hasAbsolutePath()) {
            result.append('/');
        }
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                result.append('/');
            }
            result.append(this.segments[i]);
        }
        return result.toString();
    }

    @Override
    public String devicePath() {
        if (!this.hasPath()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (this.hasAuthority()) {
            if (!this.isArchive()) {
                result.append("//");
            }
            result.append(this.authority);
            if (this.hasDevice()) {
                result.append('/');
            }
        }
        if (this.hasDevice()) {
            result.append(this.device);
        }
        if (this.hasAbsolutePath()) {
            result.append('/');
        }
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                result.append('/');
            }
            result.append(this.segments[i]);
        }
        return result.toString();
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public URI appendQuery(String query) {
        if (!URIs.validQuery(query)) {
            throw new IllegalArgumentException("invalid query portion: " + query);
        }
        return new URIImpl(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, query, this.fragment);
    }

    @Override
    public URI trimQuery() {
        if (this.query == null) {
            return this;
        }
        return new URIImpl(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, null, this.fragment);
    }

    @Override
    public String fragment() {
        return this.fragment;
    }

    @Override
    public URIImpl appendFragment(String fragment) {
        if (!URIs.validFragment(fragment)) {
            throw new IllegalArgumentException("invalid fragment portion: " + fragment);
        }
        URIImpl result = new URIImpl(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, URIs.encodeFragment(fragment, true));
        if (!this.hasFragment()) {
            result.cachedTrimFragment = this;
        }
        return result;
    }

    @Override
    public URIImpl trimFragment() {
        if (this.fragment == null) {
            return this;
        }
        if (this.cachedTrimFragment == null) {
            this.cachedTrimFragment = new URIImpl(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, null);
        }
        return this.cachedTrimFragment;
    }

    @Override
    public URIImpl namespace() {
        String opaquePart;
        int colonIndex;
        if (this.cachedNamespace != null) {
            return this.cachedNamespace;
        }
        this.cachedNamespace = this.fragment != null ? (this.fragment.length() == 0 ? this : new URIImpl(this.hierarchical, this.scheme, this.authority, this.device, this.absolutePath, this.segments, this.query, "")) : (this.opaquePart() != null ? ((colonIndex = (opaquePart = this.opaquePart()).lastIndexOf(58)) >= 0 ? new URIImpl(false, this.scheme, opaquePart.substring(0, colonIndex + 1), null, this.absolutePath, URIs.NO_SEGMENTS, null, null) : this) : this.trimSegments(1).appendSegment(""));
        return this.cachedNamespace;
    }

    @Override
    public URI appendLocalPart(String localPart) {
        if (!this.isHierarchical() && this.toString().endsWith(":")) {
            return URIs.createURI(this.toString() + localPart, true);
        }
        String last = this.lastSegment();
        if (last == null && !this.hasAbsolutePath() || last != null && last.length() > 0) {
            return this.appendFragment(localPart);
        }
        return this.trimSegments(1).appendSegment(URIs.encodeSegment(localPart, true));
    }

    @Override
    public String localPart() {
        String localName = this.fragment();
        if (localName != null) {
            return localName;
        }
        localName = this.lastSegment();
        if (localName != null) {
            return localName;
        }
        localName = this.toString();
        int separatorIndex = localName.lastIndexOf(58);
        if (separatorIndex >= 0) {
            localName = localName.substring(separatorIndex + 1);
        }
        return localName;
    }

    @Override
    public URIImpl resolve(URI base) {
        return this.resolve(base, true);
    }

    @Override
    public URIImpl resolve(URI base, boolean preserveRootParents) {
        if (!base.isHierarchical() || base.isRelative()) {
            throw new IllegalArgumentException("resolve against non-hierarchical or relative base");
        }
        if (!this.isRelative()) {
            return this;
        }
        String newAuthority = this.authority;
        String newDevice = this.device;
        boolean newAbsolutePath = this.absolutePath;
        String[] newSegments = this.segments;
        String newQuery = this.query;
        if (this.authority == null) {
            newAuthority = base.authority();
            if (this.device == null) {
                newDevice = base.device();
                if (this.hasEmptyPath() && this.query == null) {
                    newAbsolutePath = base.hasAbsolutePath();
                    newSegments = base.segments();
                    newQuery = base.query();
                } else if (this.hasRelativePath()) {
                    newAbsolutePath = base.hasAbsolutePath() || !this.hasEmptyPath();
                    newSegments = newAbsolutePath ? this.mergePath(base, preserveRootParents) : URIs.NO_SEGMENTS;
                }
            }
        }
        return new URIImpl(true, base.scheme(), newAuthority, newDevice, newAbsolutePath, newSegments, newQuery, this.fragment);
    }

    private String[] mergePath(URI base, boolean preserveRootParents) {
        int i;
        if (base.hasRelativePath()) {
            throw new IllegalArgumentException("merge against relative path");
        }
        if (!this.hasRelativePath()) {
            throw new IllegalStateException("merge non-relative path");
        }
        int baseSegmentCount = base.segmentCount();
        int segmentCount = this.segments.length;
        String[] stack = new String[baseSegmentCount + segmentCount];
        int sp = 0;
        for (i = 0; i < baseSegmentCount - 1; ++i) {
            sp = URIImpl.accumulate(stack, sp, base.segment(i), preserveRootParents);
        }
        for (i = 0; i < segmentCount; ++i) {
            sp = URIImpl.accumulate(stack, sp, this.segments[i], preserveRootParents);
        }
        if (sp > 0 && (segmentCount == 0 || "".equals(this.segments[segmentCount - 1]) || "..".equals(this.segments[segmentCount - 1]) || ".".equals(this.segments[segmentCount - 1]))) {
            stack[sp++] = "";
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    private static int accumulate(String[] stack, int sp, String segment, boolean preserveRootParents) {
        if ("..".equals(segment)) {
            if (sp == 0) {
                if (preserveRootParents) {
                    stack[sp++] = segment;
                }
            } else if ("..".equals(stack[sp - 1])) {
                stack[sp++] = segment;
            } else {
                --sp;
            }
        } else if (!"".equals(segment) && !".".equals(segment)) {
            stack[sp++] = segment;
        }
        return sp;
    }

    @Override
    public URI deresolve(URI base) {
        return this.deresolve(base, true, false, true);
    }

    @Override
    public URI deresolve(URI base, boolean preserveRootParents, boolean anyRelPath, boolean shorterRelPath) {
        if (!base.isHierarchical() || base.isRelative()) {
            throw new IllegalArgumentException("deresolve against non-hierarchical or relative base");
        }
        if (this.isRelative()) {
            throw new IllegalStateException("deresolve relative URI");
        }
        if (!this.scheme.equalsIgnoreCase(base.scheme())) {
            return this;
        }
        if (!this.isHierarchical()) {
            return this;
        }
        String newAuthority = this.authority;
        String newDevice = this.device;
        boolean newAbsolutePath = this.absolutePath;
        String[] newSegments = this.segments;
        String newQuery = this.query;
        if (URIImpl.equals(this.authority, base.authority()) && (this.hasDevice() || this.hasPath() || !base.hasDevice() && !base.hasPath())) {
            newAuthority = null;
            if (URIImpl.equals(this.device, base.device()) && (this.hasPath() || !base.hasPath())) {
                newDevice = null;
                if (anyRelPath || shorterRelPath) {
                    if (this.hasPath() == base.hasPath() && this.segmentsEqual(base) && URIImpl.equals(this.query, base.query())) {
                        newAbsolutePath = false;
                        newSegments = URIs.NO_SEGMENTS;
                        newQuery = null;
                    } else if (!this.hasPath() && !base.hasPath()) {
                        newAbsolutePath = false;
                        newSegments = URIs.NO_SEGMENTS;
                    } else if (!this.hasCollapsableSegments(preserveRootParents)) {
                        String[] rel = this.findRelativePath(base, preserveRootParents);
                        if (anyRelPath || this.segments.length > rel.length) {
                            newAbsolutePath = false;
                            newSegments = rel;
                        }
                    }
                }
            }
        }
        return new URIImpl(true, null, newAuthority, newDevice, newAbsolutePath, newSegments, newQuery, this.fragment);
    }

    private boolean hasCollapsableSegments(boolean preserveRootParents) {
        if (this.hasRelativePath()) {
            throw new IllegalStateException("test collapsability of relative path");
        }
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            String segment = this.segments[i];
            if ((i >= len - 1 || !"".equals(segment)) && !".".equals(segment) && (!"..".equals(segment) || preserveRootParents && (i == 0 || "..".equals(this.segments[i - 1])))) continue;
            return true;
        }
        return false;
    }

    private String[] findRelativePath(URI base, boolean preserveRootParents) {
        int diff;
        int count;
        if (base.hasRelativePath()) {
            throw new IllegalArgumentException("find relative path against base with relative path");
        }
        if (!this.hasAbsolutePath()) {
            throw new IllegalArgumentException("find relative path of non-absolute path");
        }
        String[] startPath = ((URIImpl)base).collapseSegments(preserveRootParents);
        String[] endPath = this.segments;
        int startCount = startPath.length > 0 ? startPath.length - 1 : 0;
        int endCount = endPath.length;
        int n = count = startCount < endCount ? startCount : endCount - 1;
        for (diff = 0; diff < count && startPath[diff].equals(endPath[diff]); ++diff) {
        }
        int upCount = startCount - diff;
        int downCount = endCount - diff;
        if (downCount == 1 && "".equals(endPath[endCount - 1])) {
            downCount = 0;
        }
        if (upCount + downCount == 0) {
            if (this.query == null) {
                return new String[]{"."};
            }
            return URIs.NO_SEGMENTS;
        }
        Object[] result = new String[upCount + downCount];
        Arrays.fill(result, 0, upCount, "..");
        System.arraycopy(endPath, diff, result, upCount, downCount);
        return result;
    }

    String[] collapseSegments(boolean preserveRootParents) {
        if (this.hasRelativePath()) {
            throw new IllegalStateException("collapse relative path");
        }
        if (!this.hasCollapsableSegments(preserveRootParents)) {
            return this.segments();
        }
        int segmentCount = this.segments.length;
        String[] stack = new String[segmentCount];
        int sp = 0;
        for (int i = 0; i < segmentCount; ++i) {
            sp = URIImpl.accumulate(stack, sp, this.segments[i], preserveRootParents);
        }
        if (sp > 0 && ("".equals(this.segments[segmentCount - 1]) || "..".equals(this.segments[segmentCount - 1]) || ".".equals(this.segments[segmentCount - 1]))) {
            stack[sp++] = "";
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer result = new StringBuffer();
            if (!this.isRelative()) {
                result.append(this.scheme);
                result.append(':');
            }
            if (this.isHierarchical()) {
                if (this.hasAuthority()) {
                    if (!this.isArchive()) {
                        result.append("//");
                    }
                    result.append(this.authority);
                }
                if (this.hasDevice()) {
                    result.append('/');
                    result.append(this.device);
                }
                if (this.hasAbsolutePath()) {
                    result.append('/');
                }
                int len = this.segments.length;
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        result.append('/');
                    }
                    result.append(this.segments[i]);
                }
                if (this.hasQuery()) {
                    result.append('?');
                    result.append(this.query);
                }
            } else {
                result.append(this.authority);
            }
            if (this.hasFragment()) {
                result.append('#');
                result.append(this.fragment);
            }
            this.cachedToString = result.toString();
        }
        return this.cachedToString;
    }

    String toString(boolean includeSimpleForm) {
        StringBuffer result = new StringBuffer();
        if (includeSimpleForm) {
            result.append(this.toString());
        }
        result.append("\n hierarchical: ");
        result.append(this.hierarchical);
        result.append("\n       scheme: ");
        result.append(this.scheme);
        result.append("\n    authority: ");
        result.append(this.authority);
        result.append("\n       device: ");
        result.append(this.device);
        result.append("\n absolutePath: ");
        result.append(this.absolutePath);
        result.append("\n     segments: ");
        if (this.segments.length == 0) {
            result.append("<empty>");
        }
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                result.append("\n               ");
            }
            result.append(this.segments[i]);
        }
        result.append("\n        query: ");
        result.append(this.query);
        result.append("\n     fragment: ");
        result.append(this.fragment);
        return result.toString();
    }

    @Override
    public String toFileString() {
        if (!this.isFile()) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        char separator = File.separatorChar;
        if (this.hasAuthority()) {
            result.append(separator);
            result.append(separator);
            result.append(this.authority);
            if (this.hasDevice()) {
                result.append(separator);
            }
        }
        if (this.hasDevice()) {
            result.append(this.device);
        }
        if (this.hasAbsolutePath()) {
            result.append(separator);
        }
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                result.append(separator);
            }
            result.append(this.segments[i]);
        }
        return URIs.decode(result.toString());
    }

    @Override
    public String toPlatformString(boolean decode) {
        if (this.isPlatform()) {
            StringBuffer result = new StringBuffer();
            int len = this.segments.length;
            for (int i = 1; i < len; ++i) {
                result.append('/').append(decode ? URIs.decode(this.segments[i]) : this.segments[i]);
            }
            return result.toString();
        }
        return null;
    }

    @Override
    public URIImpl appendSegment(String segment) {
        if (!URIs.validSegment(segment)) {
            throw new IllegalArgumentException("invalid segment: " + segment);
        }
        if (!this.isHierarchical()) {
            return this;
        }
        boolean newAbsolutePath = !this.hasRelativePath();
        int len = this.segments.length;
        String[] newSegments = new String[len + 1];
        System.arraycopy(this.segments, 0, newSegments, 0, len);
        newSegments[len] = segment;
        return new URIImpl(true, this.scheme, this.authority, this.device, newAbsolutePath, newSegments, this.query, this.fragment);
    }

    @Override
    public URIImpl appendSegments(String[] segments) {
        if (!URIs.validSegments(segments)) {
            String s = segments == null ? "invalid segments: null" : "invalid segment: " + URIs.firstInvalidSegment(segments);
            throw new IllegalArgumentException(s);
        }
        if (!this.isHierarchical()) {
            return this;
        }
        boolean newAbsolutePath = !this.hasRelativePath();
        int len = this.segments.length;
        int segmentsCount = segments.length;
        String[] newSegments = new String[len + segmentsCount];
        System.arraycopy(this.segments, 0, newSegments, 0, len);
        System.arraycopy(segments, 0, newSegments, len, segmentsCount);
        return new URIImpl(true, this.scheme, this.authority, this.device, newAbsolutePath, newSegments, this.query, this.fragment);
    }

    @Override
    public URIImpl trimSegments(int i) {
        if (!this.isHierarchical() || i < 1) {
            return this;
        }
        String[] newSegments = URIs.NO_SEGMENTS;
        int len = this.segments.length - i;
        if (len > 0) {
            newSegments = new String[len];
            System.arraycopy(this.segments, 0, newSegments, 0, len);
        }
        return new URIImpl(true, this.scheme, this.authority, this.device, this.absolutePath, newSegments, this.query, this.fragment);
    }

    @Override
    public boolean hasTrailingPathSeparator() {
        return this.segments.length > 0 && "".equals(this.segments[this.segments.length - 1]);
    }

    @Override
    public String fileExtension() {
        int len = this.segments.length;
        if (len == 0) {
            return null;
        }
        String lastSegment = this.segments[len - 1];
        int i = lastSegment.lastIndexOf(46);
        return i < 0 ? null : lastSegment.substring(i + 1);
    }

    @Override
    public URI appendFileExtension(String fileExtension) {
        if (!URIs.validSegment(fileExtension)) {
            throw new IllegalArgumentException("invalid segment portion: " + fileExtension);
        }
        int len = this.segments.length;
        if (len == 0) {
            return this;
        }
        String lastSegment = this.segments[len - 1];
        if ("".equals(lastSegment)) {
            return this;
        }
        StringBuffer newLastSegment = new StringBuffer(lastSegment);
        newLastSegment.append('.');
        newLastSegment.append(fileExtension);
        String[] newSegments = new String[len];
        System.arraycopy(this.segments, 0, newSegments, 0, len - 1);
        newSegments[len - 1] = newLastSegment.toString();
        return new URIImpl(true, this.scheme, this.authority, this.device, this.absolutePath, newSegments, this.query, this.fragment);
    }

    @Override
    public URI trimFileExtension() {
        int len = this.segments.length;
        if (len == 0) {
            return this;
        }
        String lastSegment = this.segments[len - 1];
        int i = lastSegment.lastIndexOf(46);
        if (i < 0) {
            return this;
        }
        String newLastSegment = lastSegment.substring(0, i);
        String[] newSegments = new String[len];
        System.arraycopy(this.segments, 0, newSegments, 0, len - 1);
        newSegments[len - 1] = newLastSegment;
        return new URIImpl(true, this.scheme, this.authority, this.device, this.absolutePath, newSegments, this.query, this.fragment);
    }

    @Override
    public boolean isPrefix() {
        return this.hierarchical && this.query == null && this.fragment == null && (this.hasTrailingPathSeparator() || this.absolutePath && this.segments.length == 0);
    }

    @Override
    public URI replacePrefix(URI oldPrefix, URI newPrefix) {
        if (!oldPrefix.isPrefix() || !newPrefix.isPrefix()) {
            String which = oldPrefix.isPrefix() ? "new" : "old";
            throw new IllegalArgumentException("non-prefix " + which + " value");
        }
        String[] tailSegments = this.getTailSegments(oldPrefix);
        if (tailSegments == null) {
            return null;
        }
        String[] mergedSegments = tailSegments;
        if (newPrefix.segmentCount() != 0) {
            int segmentsToKeep = newPrefix.segmentCount() - 1;
            mergedSegments = new String[segmentsToKeep + tailSegments.length];
            System.arraycopy(newPrefix.segments(), 0, mergedSegments, 0, segmentsToKeep);
            if (tailSegments.length != 0) {
                System.arraycopy(tailSegments, 0, mergedSegments, segmentsToKeep, tailSegments.length);
            }
        }
        return new URIImpl(true, newPrefix.scheme(), newPrefix.authority(), newPrefix.device(), newPrefix.hasAbsolutePath(), mergedSegments, this.query, this.fragment);
    }

    private String[] getTailSegments(URI prefix) {
        int i;
        if (!prefix.isPrefix()) {
            throw new IllegalArgumentException("non-prefix trim");
        }
        if (!(this.hierarchical && URIImpl.equals(this.scheme, prefix.scheme(), true) && URIImpl.equals(this.authority, prefix.authority()) && URIImpl.equals(this.device, prefix.device()) && this.absolutePath == prefix.hasAbsolutePath())) {
            return null;
        }
        if (prefix.segmentCount() == 0) {
            return this.segments;
        }
        int segmentsToCompare = prefix.segmentCount() - 1;
        if (this.segments.length <= segmentsToCompare) {
            return null;
        }
        for (i = 0; i < segmentsToCompare; ++i) {
            if (this.segments[i].equals(prefix.segment(i))) continue;
            return null;
        }
        if (i == this.segments.length - 1 && "".equals(this.segments[i])) {
            return URIs.NO_SEGMENTS;
        }
        String[] newSegments = new String[this.segments.length - i];
        System.arraycopy(this.segments, i, newSegments, 0, newSegments.length);
        return newSegments;
    }

    @Override
    public URI getURI() {
        return this;
    }
}

