/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.core;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIImpl;

public final class URIs {
    private static final URICache uriCache = new URICache();
    private static final Set<String> archiveSchemes;
    static final String SCHEME_ARCHIVE = "archive";
    static final String SCHEME_FILE = "file";
    static final String SCHEME_JAR = "jar";
    static final String SCHEME_PLATFORM = "platform";
    static final String SCHEME_ZIP = "zip";
    static final String SEGMENT_EMPTY = "";
    static final String SEGMENT_SELF = ".";
    static final String SEGMENT_PARENT = "..";
    static final String[] NO_SEGMENTS;
    static final char SCHEME_SEPARATOR = ':';
    static final String AUTHORITY_SEPARATOR = "//";
    static final char DEVICE_IDENTIFIER = ':';
    static final char SEGMENT_SEPARATOR = '/';
    static final char QUERY_SEPARATOR = '?';
    static final char FRAGMENT_SEPARATOR = '#';
    static final char USER_INFO_SEPARATOR = '@';
    static final char PORT_SEPARATOR = ':';
    static final char FILE_EXTENSION_SEPARATOR = '.';
    static final char ARCHIVE_IDENTIFIER = '!';
    static final String ARCHIVE_SEPARATOR = "!/";
    private static final char ESCAPE = '%';
    private static final char[] HEX_DIGITS;
    private static final long ALPHA_HI;
    private static final long ALPHA_LO;
    private static final long DIGIT_HI;
    private static final long DIGIT_LO;
    private static final long ALPHANUM_HI;
    private static final long ALPHANUM_LO;
    private static final long HEX_HI;
    private static final long HEX_LO;
    private static final long UNRESERVED_HI;
    private static final long UNRESERVED_LO;
    private static final long RESERVED_HI;
    private static final long RESERVED_LO;
    private static final long URIC_HI;
    private static final long URIC_LO;
    private static final long SEGMENT_CHAR_HI;
    private static final long SEGMENT_CHAR_LO;
    private static final long PATH_CHAR_HI;
    private static final long PATH_CHAR_LO;
    private static final long MAJOR_SEPARATOR_HI;
    private static final long MAJOR_SEPARATOR_LO;
    private static final long SEGMENT_END_HI;
    private static final long SEGMENT_END_LO;

    private static long lowBitmask(char c) {
        return c < '@' ? 1L << c : 0L;
    }

    private static long highBitmask(char c) {
        return c >= '@' && c < '\u0080' ? 1L << c - 64 : 0L;
    }

    private static long lowBitmask(char from, char to) {
        long result = 0L;
        if (from < '@' && from <= to) {
            to = to < '@' ? to : (char)'?';
            for (char c = from; c <= to; c = (char)(c + '\u0001')) {
                result |= 1L << c;
            }
        }
        return result;
    }

    private static long highBitmask(char from, char to) {
        return to < '@' ? 0L : URIs.lowBitmask((char)(from < '@' ? 0 : from - 64), (char)(to - 64));
    }

    private static long lowBitmask(String chars) {
        long result = 0L;
        int len = chars.length();
        for (int i = 0; i < len; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            result |= 1L << c;
        }
        return result;
    }

    private static long highBitmask(String chars) {
        long result = 0L;
        int len = chars.length();
        for (int i = 0; i < len; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            result |= 1L << c - 64;
        }
        return result;
    }

    private static boolean matches(char c, long highBitmask, long lowBitmask) {
        if (c >= '\u0080') {
            return false;
        }
        return c < '@' ? (1L << c & lowBitmask) != 0L : (1L << c - 64 & highBitmask) != 0L;
    }

    public static URI createGenericURI(String scheme, String opaquePart, String fragment) {
        if (scheme == null) {
            throw new IllegalArgumentException("relative non-hierarchical URI");
        }
        if (URIs.isArchiveScheme(scheme)) {
            throw new IllegalArgumentException("non-hierarchical archive URI");
        }
        URIs.validateURI(false, scheme, opaquePart, null, false, NO_SEGMENTS, null, fragment);
        return new URIImpl(false, scheme, opaquePart, null, false, NO_SEGMENTS, null, fragment);
    }

    public static URI createHierarchicalURI(String scheme, String authority, String device, String query, String fragment) {
        if (scheme != null && authority == null && device == null) {
            throw new IllegalArgumentException("absolute hierarchical URI without authority, device, path");
        }
        if (URIs.isArchiveScheme(scheme)) {
            throw new IllegalArgumentException("archive URI with no path");
        }
        URIs.validateURI(true, scheme, authority, device, false, NO_SEGMENTS, query, fragment);
        return new URIImpl(true, scheme, authority, device, false, NO_SEGMENTS, query, fragment);
    }

    public static URI createHierarchicalURI(String scheme, String authority, String device, String[] segments, String query, String fragment) {
        if (URIs.isArchiveScheme(scheme) && device != null) {
            throw new IllegalArgumentException("archive URI with device");
        }
        segments = URIs.fix(segments);
        URIs.validateURI(true, scheme, authority, device, true, segments, query, fragment);
        return new URIImpl(true, scheme, authority, device, true, segments, query, fragment);
    }

    public static URI createHierarchicalURI(String[] segments, String query, String fragment) {
        segments = URIs.fix(segments);
        URIs.validateURI(true, null, null, null, false, segments, query, fragment);
        return new URIImpl(true, null, null, null, false, segments, query, fragment);
    }

    private static String[] fix(String[] segments) {
        return segments == null ? NO_SEGMENTS : (String[])segments.clone();
    }

    public static URI createURI(String uri) {
        return URIs.createURIWithCache(uri);
    }

    public static URI createURI(String uri, boolean ignoreEscaped) {
        return URIs.createURIWithCache(URIs.encodeURI(uri, ignoreEscaped, 2));
    }

    public static URI createURI(String uri, boolean ignoreEscaped, int fragmentLocationStyle) {
        return URIs.createURIWithCache(URIs.encodeURI(uri, ignoreEscaped, fragmentLocationStyle));
    }

    private static URI createURIWithCache(String uri) {
        int i = uri.indexOf(35);
        String base = i == -1 ? uri : uri.substring(0, i);
        String fragment = i == -1 ? null : uri.substring(i + 1);
        URI result = uriCache.get(base);
        if (result == null) {
            result = URIs.parseIntoURI(base);
            uriCache.put(base, result);
        }
        if (fragment != null) {
            result = result.appendFragment(fragment);
        }
        return result;
    }

    private static URI parseIntoURI(String uri) {
        String s;
        boolean archiveScheme;
        boolean hierarchical = true;
        String scheme = null;
        String authority = null;
        String device = null;
        boolean absolutePath = false;
        String[] segments = NO_SEGMENTS;
        String query = null;
        String fragment = null;
        int i = 0;
        int j = URIs.find(uri, i, MAJOR_SEPARATOR_HI, MAJOR_SEPARATOR_LO);
        if (j < uri.length() && uri.charAt(j) == ':') {
            scheme = uri.substring(i, j);
            i = j + 1;
        }
        if (archiveScheme = URIs.isArchiveScheme(scheme)) {
            j = uri.lastIndexOf(ARCHIVE_SEPARATOR);
            if (j == -1) {
                throw new IllegalArgumentException("no archive separator");
            }
            hierarchical = true;
            authority = uri.substring(i, ++j);
            i = j;
        } else if (uri.startsWith(AUTHORITY_SEPARATOR, i)) {
            j = URIs.find(uri, i += AUTHORITY_SEPARATOR.length(), SEGMENT_END_HI, SEGMENT_END_LO);
            authority = uri.substring(i, j);
            i = j;
        } else if (scheme != null && (i == uri.length() || uri.charAt(i) != '/')) {
            hierarchical = false;
            j = uri.indexOf(35, i);
            if (j == -1) {
                j = uri.length();
            }
            authority = uri.substring(i, j);
            i = j;
        }
        if (!archiveScheme && i < uri.length() && uri.charAt(i) == '/' && (s = uri.substring(i + 1, j = URIs.find(uri, i + 1, SEGMENT_END_HI, SEGMENT_END_LO))).length() > 0 && s.charAt(s.length() - 1) == ':') {
            device = s;
            i = j;
        }
        if (i < uri.length() && uri.charAt(i) == '/') {
            ++i;
            absolutePath = true;
        }
        if (URIs.segmentsRemain(uri, i)) {
            ArrayList<String> segmentList = new ArrayList<String>();
            while (URIs.segmentsRemain(uri, i)) {
                j = URIs.find(uri, i, SEGMENT_END_HI, SEGMENT_END_LO);
                segmentList.add(uri.substring(i, j));
                i = j;
                if (i >= uri.length() || uri.charAt(i) != '/' || URIs.segmentsRemain(uri, ++i)) continue;
                segmentList.add(SEGMENT_EMPTY);
            }
            segments = new String[segmentList.size()];
            segmentList.toArray(segments);
        }
        if (i < uri.length() && uri.charAt(i) == '?') {
            if ((j = uri.indexOf(35, ++i)) == -1) {
                j = uri.length();
            }
            query = uri.substring(i, j);
            i = j;
        }
        if (i < uri.length()) {
            fragment = uri.substring(++i);
        }
        URIs.validateURI(hierarchical, scheme, authority, device, absolutePath, segments, query, fragment);
        return new URIImpl(hierarchical, scheme, authority, device, absolutePath, segments, query, fragment);
    }

    private static boolean segmentsRemain(String uri, int i) {
        return i < uri.length() && uri.charAt(i) != '?' && uri.charAt(i) != '#';
    }

    private static int find(String s, int i, long highBitmask, long lowBitmask) {
        int len = s.length();
        if (i >= len) {
            return len;
        }
        int n = i = i > 0 ? i : 0;
        while (i < len && !URIs.matches(s.charAt(i), highBitmask, lowBitmask)) {
            ++i;
        }
        return i;
    }

    public static URI createFileURI(String pathName) {
        File file = new File(pathName);
        String uri = File.separatorChar != '/' ? pathName.replace(File.separatorChar, '/') : pathName;
        uri = URIs.encode(uri, PATH_CHAR_HI, PATH_CHAR_LO, false);
        if (file.isAbsolute()) {
            URI result = URIs.createURI((uri.charAt(0) == '/' ? "file:" : "file:/") + uri);
            return result;
        }
        URI result = URIs.createURI(uri);
        if (result.scheme() != null) {
            throw new IllegalArgumentException("invalid relative pathName: " + pathName);
        }
        return result;
    }

    public static URI createPlatformResourceURI(String pathName, boolean encode) {
        return URIs.createPlatformURI("platform:/resource", "platform:/resource/", pathName, encode);
    }

    public static URI createPlatformPluginURI(String pathName, boolean encode) {
        return URIs.createPlatformURI("platform:/plugin", "platform:/plugin/", pathName, encode);
    }

    private static URI createPlatformURI(String unrootedBase, String rootedBase, String pathName, boolean encode) {
        if (File.separatorChar != '/') {
            pathName = pathName.replace(File.separatorChar, '/');
        }
        if (encode) {
            pathName = URIs.encode(pathName, PATH_CHAR_HI, PATH_CHAR_LO, false);
        }
        URI result = URIs.createURI((pathName.charAt(0) == '/' ? unrootedBase : rootedBase) + pathName);
        return result;
    }

    private static void validateURI(boolean hierarchical, String scheme, String authority, String device, boolean absolutePath, String[] segments, String query, String fragment) {
        if (!URIs.validScheme(scheme)) {
            throw new IllegalArgumentException("invalid scheme: " + scheme);
        }
        if (!hierarchical && !URIs.validOpaquePart(authority)) {
            throw new IllegalArgumentException("invalid opaquePart: " + authority);
        }
        if (hierarchical && !URIs.isArchiveScheme(scheme) && !URIs.validAuthority(authority)) {
            throw new IllegalArgumentException("invalid authority: " + authority);
        }
        if (hierarchical && URIs.isArchiveScheme(scheme) && !URIs.validArchiveAuthority(authority)) {
            throw new IllegalArgumentException("invalid authority: " + authority);
        }
        if (!URIs.validDevice(device)) {
            throw new IllegalArgumentException("invalid device: " + device);
        }
        if (!URIs.validSegments(segments)) {
            String s = segments == null ? "invalid segments: null" : "invalid segment: " + URIs.firstInvalidSegment(segments);
            throw new IllegalArgumentException(s);
        }
        if (!URIs.validQuery(query)) {
            throw new IllegalArgumentException("invalid query: " + query);
        }
        if (!URIs.validFragment(fragment)) {
            throw new IllegalArgumentException("invalid fragment: " + fragment);
        }
    }

    static String firstInvalidSegment(String[] value) {
        if (value == null) {
            return null;
        }
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            if (URIs.validSegment(value[i])) continue;
            return value[i];
        }
        return null;
    }

    public static boolean validScheme(String value) {
        return value == null || !URIs.contains(value, MAJOR_SEPARATOR_HI, MAJOR_SEPARATOR_LO);
    }

    public static boolean validOpaquePart(String value) {
        return value != null && value.indexOf(35) == -1 && value.length() > 0 && value.charAt(0) != '/';
    }

    public static boolean validAuthority(String value) {
        return value == null || !URIs.contains(value, SEGMENT_END_HI, SEGMENT_END_LO);
    }

    public static boolean validArchiveAuthority(String value) {
        if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '!') {
            try {
                URI archiveURI = URIs.createURI(value.substring(0, value.length() - 1));
                return !archiveURI.hasFragment();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean validDevice(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        return len > 0 && value.charAt(len - 1) == ':' && !URIs.contains(value, SEGMENT_END_HI, SEGMENT_END_LO);
    }

    public static boolean validSegment(String value) {
        return value != null && !URIs.contains(value, SEGMENT_END_HI, SEGMENT_END_LO);
    }

    public static boolean validSegments(String[] value) {
        if (value == null) {
            return false;
        }
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            if (URIs.validSegment(value[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean validQuery(String value) {
        return value == null || value.indexOf(35) == -1;
    }

    public static boolean validFragment(String value) {
        return true;
    }

    private static boolean contains(String s, long highBitmask, long lowBitmask) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (!URIs.matches(s.charAt(i), highBitmask, lowBitmask)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArchiveScheme(String value) {
        return value != null && archiveSchemes.contains(value.toLowerCase());
    }

    public static String encodeOpaquePart(String value, boolean ignoreEscaped) {
        String result = URIs.encode(value, URIC_HI, URIC_LO, ignoreEscaped);
        return result != null && result.length() > 0 && result.charAt(0) == '/' ? "%2F" + result.substring(1) : result;
    }

    public static String encodeAuthority(String value, boolean ignoreEscaped) {
        return URIs.encode(value, SEGMENT_CHAR_HI, SEGMENT_CHAR_LO, ignoreEscaped);
    }

    public static String encodeSegment(String value, boolean ignoreEscaped) {
        return URIs.encode(value, SEGMENT_CHAR_HI, SEGMENT_CHAR_LO, ignoreEscaped);
    }

    public static String encodeQuery(String value, boolean ignoreEscaped) {
        return URIs.encode(value, URIC_HI, URIC_LO, ignoreEscaped);
    }

    public static String encodeFragment(String value, boolean ignoreEscaped) {
        return URIs.encode(value, URIC_HI, URIC_LO, ignoreEscaped);
    }

    private static String encodeURI(String uri, boolean ignoreEscaped, int fragmentLocationStyle) {
        int j;
        if (uri == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = uri.indexOf(58);
        if (i != -1) {
            String scheme = uri.substring(0, i);
            result.append(scheme);
            result.append(':');
        }
        int n = fragmentLocationStyle == 1 ? uri.indexOf(35) : (j = fragmentLocationStyle == 2 ? uri.lastIndexOf(35) : -1);
        if (j != -1) {
            String sspart = uri.substring(++i, j);
            result.append(URIs.encode(sspart, URIC_HI, URIC_LO, ignoreEscaped));
            result.append('#');
            String fragment = uri.substring(++j);
            result.append(URIs.encode(fragment, URIC_HI, URIC_LO, ignoreEscaped));
        } else {
            String sspart = uri.substring(++i);
            result.append(URIs.encode(sspart, URIC_HI, URIC_LO, ignoreEscaped));
        }
        return result.toString();
    }

    private static String encode(String value, long highBitmask, long lowBitmask, boolean ignoreEscaped) {
        if (value == null) {
            return null;
        }
        StringBuffer result = null;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (!(URIs.matches(c, highBitmask, lowBitmask) || c >= '\u00a0' || ignoreEscaped && URIs.isEscaped(value, i))) {
                if (result == null) {
                    result = new StringBuffer(value.substring(0, i));
                }
                URIs.appendEscaped(result, (byte)c);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        return result == null ? value : result.toString();
    }

    private static boolean isEscaped(String s, int i) {
        return s.charAt(i) == '%' && s.length() > i + 2 && URIs.matches(s.charAt(i + 1), HEX_HI, HEX_LO) && URIs.matches(s.charAt(i + 2), HEX_HI, HEX_LO);
    }

    private static void appendEscaped(StringBuffer result, byte b) {
        result.append('%');
        result.append(HEX_DIGITS[b >> 4 & 0xF]);
        result.append(HEX_DIGITS[b & 0xF]);
    }

    public static String decode(String value) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(37);
        if (i < 0) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.substring(0, i));
        byte[] bytes = new byte[4];
        int receivedBytes = 0;
        int expectedBytes = 0;
        int len = value.length();
        while (i < len) {
            if (URIs.isEscaped(value, i)) {
                char character = URIs.unescape(value.charAt(i + 1), value.charAt(i + 2));
                i += 2;
                if (expectedBytes > 0) {
                    if ((character & 0xC0) == 128) {
                        bytes[receivedBytes++] = (byte)character;
                    } else {
                        expectedBytes = 0;
                    }
                } else if (character >= '\u0080') {
                    if ((character & 0xE0) == 192) {
                        bytes[receivedBytes++] = (byte)character;
                        expectedBytes = 2;
                    } else if ((character & 0xF0) == 224) {
                        bytes[receivedBytes++] = (byte)character;
                        expectedBytes = 3;
                    } else if ((character & 0xF8) == 240) {
                        bytes[receivedBytes++] = (byte)character;
                        expectedBytes = 4;
                    }
                }
                if (expectedBytes > 0) {
                    if (receivedBytes == expectedBytes) {
                        switch (receivedBytes) {
                            case 2: {
                                result.append((char)((bytes[0] & 0x1F) << 6 | bytes[1] & 0x3F));
                                break;
                            }
                            case 3: {
                                result.append((char)((bytes[0] & 0xF) << 12 | (bytes[1] & 0x3F) << 6 | bytes[2] & 0x3F));
                                break;
                            }
                            case 4: {
                                result.appendCodePoint((bytes[0] & 7) << 18 | (bytes[1] & 0x3F) << 12 | (bytes[2] & 0x3F) << 6 | bytes[3] & 0x3F);
                            }
                        }
                        receivedBytes = 0;
                        expectedBytes = 0;
                    }
                } else {
                    for (int j = 0; j < receivedBytes; ++j) {
                        result.append((char)bytes[j]);
                    }
                    receivedBytes = 0;
                    result.append(character);
                }
            } else {
                for (int j = 0; j < receivedBytes; ++j) {
                    result.append((char)bytes[j]);
                }
                receivedBytes = 0;
                result.append(value.charAt(i));
            }
            ++i;
        }
        return result.toString();
    }

    private static char unescape(char highHexDigit, char lowHexDigit) {
        return (char)(URIs.valueOf(highHexDigit) << 4 | URIs.valueOf(lowHexDigit));
    }

    private static int valueOf(char hexDigit) {
        if (hexDigit >= 'A' && hexDigit <= 'F') {
            return hexDigit - 65 + 10;
        }
        if (hexDigit >= 'a' && hexDigit <= 'f') {
            return hexDigit - 97 + 10;
        }
        if (hexDigit >= '0' && hexDigit <= '9') {
            return hexDigit - 48;
        }
        return 0;
    }

    static {
        NO_SEGMENTS = new String[0];
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        ALPHA_HI = URIs.highBitmask('a', 'z') | URIs.highBitmask('A', 'Z');
        ALPHA_LO = URIs.lowBitmask('a', 'z') | URIs.lowBitmask('A', 'Z');
        DIGIT_HI = URIs.highBitmask('0', '9');
        DIGIT_LO = URIs.lowBitmask('0', '9');
        ALPHANUM_HI = ALPHA_HI | DIGIT_HI;
        ALPHANUM_LO = ALPHA_LO | DIGIT_LO;
        HEX_HI = DIGIT_HI | URIs.highBitmask('A', 'F') | URIs.highBitmask('a', 'f');
        HEX_LO = DIGIT_LO | URIs.lowBitmask('A', 'F') | URIs.lowBitmask('a', 'f');
        UNRESERVED_HI = ALPHANUM_HI | URIs.highBitmask("-_.!~*'()");
        UNRESERVED_LO = ALPHANUM_LO | URIs.lowBitmask("-_.!~*'()");
        RESERVED_HI = URIs.highBitmask(";/?:@&=+$,");
        RESERVED_LO = URIs.lowBitmask(";/?:@&=+$,");
        URIC_HI = RESERVED_HI | UNRESERVED_HI;
        URIC_LO = RESERVED_LO | UNRESERVED_LO;
        SEGMENT_CHAR_HI = UNRESERVED_HI | URIs.highBitmask(";:@&=+$,");
        SEGMENT_CHAR_LO = UNRESERVED_LO | URIs.lowBitmask(";:@&=+$,");
        PATH_CHAR_HI = SEGMENT_CHAR_HI | URIs.highBitmask('/');
        PATH_CHAR_LO = SEGMENT_CHAR_LO | URIs.lowBitmask('/');
        MAJOR_SEPARATOR_HI = URIs.highBitmask(":/?#");
        MAJOR_SEPARATOR_LO = URIs.lowBitmask(":/?#");
        SEGMENT_END_HI = URIs.highBitmask("/?#");
        SEGMENT_END_LO = URIs.lowBitmask("/?#");
        HashSet<String> set = new HashSet<String>();
        String propertyValue = System.getProperty("net.enilink.komma.core.URIs.archiveSchemes");
        if (propertyValue == null) {
            set.add(SCHEME_JAR);
            set.add(SCHEME_ZIP);
            set.add(SCHEME_ARCHIVE);
        } else {
            StringTokenizer t = new StringTokenizer(propertyValue);
            while (t.hasMoreTokens()) {
                set.add(t.nextToken().toLowerCase());
            }
        }
        archiveSchemes = Collections.unmodifiableSet(set);
    }

    private static class URICache
    extends HashMap<String, WeakReference<URI>> {
        private static final long serialVersionUID = 1L;
        static final int MIN_LIMIT = 1000;
        int count;
        int limit = 1000;

        private URICache() {
        }

        public synchronized URI get(String key) {
            WeakReference reference = (WeakReference)super.get(key);
            return reference == null ? null : (URI)reference.get();
        }

        @Override
        public synchronized void put(String key, URI value) {
            super.put(key, new WeakReference<URI>(value));
            if (++this.count > this.limit) {
                this.cleanGCedValues();
            }
        }

        private void cleanGCedValues() {
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                WeakReference reference = (WeakReference)entry.getValue();
                if (reference.get() != null) continue;
                i.remove();
            }
            this.count = 0;
            this.limit = Math.max(1000, this.size() / 2);
        }
    }
}

