/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.lucene.spin;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.lucene.spin.LuceneSpinSailConnection;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchIndexQueryContextInitializer;
import org.eclipse.rdf4j.sail.lucene.util.SearchIndexUtils;
import org.eclipse.rdf4j.sail.spin.SpinSail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Experimental
public class LuceneSpinSail
extends NotifyingSailWrapper {
    private final Logger log = LoggerFactory.getLogger(LuceneSpinSail.class);
    private SearchIndex si;
    private Properties parameters = new Properties();
    private Set<IRI> indexedFields;
    private Map<IRI, IRI> indexedFieldsMapping;

    public LuceneSpinSail() {
    }

    public LuceneSpinSail(SpinSail baseSail) {
        super(baseSail);
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public void setParameters(Properties parameters) {
        this.parameters = parameters;
    }

    public void addAbsentParameters(Properties parameters) {
        parameters.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.parameters.putIfAbsent(k, v)));
    }

    private Path getAbsoluteLuceneIndexDir() {
        Path parametersIndexDir = Paths.get(this.parameters.getProperty("lucenedir", "index/"), new String[0]);
        if (!parametersIndexDir.isAbsolute()) {
            parametersIndexDir = Paths.get(this.getDataDir().getAbsolutePath(), new String[0]).resolve(parametersIndexDir);
        }
        return parametersIndexDir;
    }

    @Override
    public void initialize() throws SailException {
        if (this.parameters.containsKey("indexedfields")) {
            String indexedfieldsString = this.parameters.getProperty("indexedfields");
            Properties prop = new Properties();
            try {
                StringReader reader = new StringReader(indexedfieldsString);
                Object object = null;
                try {
                    prop.load(reader);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new SailException("Could read indexedfields: " + indexedfieldsString, e);
            }
            ValueFactory vf = this.getValueFactory();
            this.indexedFields = new HashSet<IRI>();
            this.indexedFieldsMapping = new HashMap<IRI, IRI>();
            for (Object e : prop.keySet()) {
                String keyStr = e.toString();
                if (keyStr.startsWith("index.")) {
                    this.indexedFields.add(vf.createIRI(prop.getProperty(keyStr)));
                    continue;
                }
                this.indexedFieldsMapping.put(vf.createIRI(keyStr), vf.createIRI(prop.getProperty(keyStr)));
            }
        }
        ((SpinSail)this.getBaseSail()).setEvaluationMode(TupleFunctionEvaluationMode.TRIPLE_SOURCE);
        this.parameters.setProperty("index", this.getParameters().getProperty("index", "org.eclipse.rdf4j.sail.lucene.LuceneIndex"));
        Path indexLocation = this.getAbsoluteLuceneIndexDir();
        this.log.debug("index location: {}", (Object)indexLocation);
        Properties newParameters = (Properties)this.parameters.clone();
        newParameters.setProperty("lucenedir", indexLocation.toString());
        try {
            this.si = SearchIndexUtils.createSearchIndex(newParameters);
            ((SpinSail)this.getBaseSail()).addQueryContextInitializer(new SearchIndexQueryContextInitializer(this.si));
        }
        catch (Exception ex) {
            this.log.warn("error occured during set up of the search index. It might affect functionality.");
            throw new SailException(ex);
        }
        super.initialize();
    }

    @Override
    public NotifyingSailConnection getConnection() throws SailException {
        if (this.si == null) {
            throw new SailException("Index is not created");
        }
        return new LuceneSpinSailConnection(super.getConnection(), this.si, this);
    }

    public Statement mapStatement(Statement statement) {
        Set<IRI> nextIndexedFields;
        IRI res;
        IRI p = statement.getPredicate();
        boolean predicateChanged = false;
        Map<IRI, IRI> nextIndexedFieldsMapping = this.indexedFieldsMapping;
        if (nextIndexedFieldsMapping != null && (res = nextIndexedFieldsMapping.get(p)) != null) {
            p = res;
            predicateChanged = true;
        }
        if ((nextIndexedFields = this.indexedFields) != null && !nextIndexedFields.contains(p)) {
            return null;
        }
        if (predicateChanged) {
            return this.getValueFactory().createStatement(statement.getSubject(), p, statement.getObject(), statement.getContext());
        }
        return statement;
    }
}

