/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.NamespaceAware;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

class JSONLDInternalRDFParser
implements RDFParser {
    JSONLDInternalRDFParser() {
    }

    public void setPrefix(RDFDataset result, String fullUri, String prefix) {
        result.setNamespace(fullUri, prefix);
    }

    public void handleStatement(RDFDataset result, Statement nextStatement) {
        String subject = this.getResourceValue(nextStatement.getSubject());
        String predicate = this.getResourceValue(nextStatement.getPredicate());
        Value object = nextStatement.getObject();
        String graphName = this.getResourceValue(nextStatement.getContext());
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            String value = literal.getLabel();
            String datatype = this.getResourceValue(literal.getDatatype());
            if (literal.getLanguage().isPresent() && datatype == null) {
                datatype = RDF.LANGSTRING.stringValue();
            }
            if (!literal.getLanguage().isPresent() && datatype == null) {
                datatype = XMLSchema.STRING.stringValue();
            }
            result.addQuad(subject, predicate, value, datatype, (String)literal.getLanguage().orElse(null), graphName);
        } else {
            result.addQuad(subject, predicate, this.getResourceValue((Resource)object), graphName);
        }
    }

    private String getResourceValue(Resource subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof IRI) {
            return subject.stringValue();
        }
        if (subject instanceof BNode) {
            return "_:" + subject.stringValue();
        }
        throw new IllegalStateException("Did not recognise resource type: " + subject.getClass().getName());
    }

    public RDFDataset parse(Object input) throws JsonLdError {
        RDFDataset result = new RDFDataset();
        if (input instanceof Statement) {
            this.handleStatement(result, (Statement)input);
        } else if (input instanceof Model) {
            if (input instanceof NamespaceAware) {
                Set<Namespace> namespaces = ((NamespaceAware)input).getNamespaces();
                for (Namespace nextNs : namespaces) {
                    result.setNamespace(nextNs.getName(), nextNs.getPrefix());
                }
            }
            for (Statement nextStatement : (Model)input) {
                this.handleStatement(result, nextStatement);
            }
        }
        return result;
    }
}

