/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.AndPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.AggregateIteratorTypeOverride;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedSplitter;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.EqualsJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrPropertyShape
extends PathPropertyShape {
    private final List<List<PathPropertyShape>> or;
    private static final Logger logger = LoggerFactory.getLogger(OrPropertyShape.class);

    OrPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource or) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.or = OrPropertyShape.toList(connection, or).stream().map(v -> PropertyShape.Factory.getPropertyShapesInner(connection, nodeShape, (Resource)v, this)).collect(Collectors.toList());
    }

    OrPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, List<List<PathPropertyShape>> or) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.or = or;
    }

    public OrPropertyShape(Resource id, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Path path, List<List<PathPropertyShape>> or) {
        super(id, nodeShape, deactivated, parent, path);
        this.or = or;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        PlanNode ret;
        PlanNodeProvider targetNodesToValidate;
        if (this.deactivated) {
            return null;
        }
        if (negateThisPlan) {
            AndPropertyShape orPropertyShape = new AndPropertyShape(this.getId(), this.nodeShape, this.deactivated, this, null, this.or);
            EnrichWithShape plan = (EnrichWithShape)orPropertyShape.getPlan(connectionsGroup, printPlans, overrideTargetNode, false, true);
            return new EnrichWithShape(plan.getParent(), this);
        }
        if (this.or.stream().mapToLong(List::size).sum() == 1L) {
            PlanNode plan = this.or.get(0).get(0).getPlan(connectionsGroup, false, overrideTargetNode, negateSubPlans, false);
            return new EnrichWithShape(plan, this);
        }
        List initialPlanNodes = this.or.stream().map(shapes -> shapes.stream().map(shape -> shape.getPlan(connectionsGroup, false, null, negateSubPlans, false)).filter(Objects::nonNull).collect(Collectors.toList())).filter(list -> !list.isEmpty()).collect(Collectors.toList());
        if (overrideTargetNode == null) {
            List<PlanNode> collect = initialPlanNodes.stream().flatMap(Collection::stream).map(p -> new TrimTuple((PlanNode)p, 0, 1)).collect(Collectors.toList());
            targetNodesToValidate = new BufferedSplitter(new Unique(this.unionAll(collect)));
        } else {
            targetNodesToValidate = connectionsGroup.getSail().isCacheSelectNodes() ? new BufferedSplitter(overrideTargetNode.getPlanNode()) : overrideTargetNode;
        }
        List plannodes = this.or.stream().map(shapes -> shapes.stream().map(shape -> {
            if (connectionsGroup.getStats().isBaseSailEmpty() && overrideTargetNode == null) {
                return shape.getPlan(connectionsGroup, false, null, negateSubPlans, false);
            }
            return shape.getPlan(connectionsGroup, false, targetNodesToValidate, negateSubPlans, false);
        }).filter(Objects::nonNull).collect(Collectors.toList())).filter(list -> !list.isEmpty()).collect(Collectors.toList());
        List iteratorDataTypes = plannodes.stream().flatMap(shapes -> shapes.stream().map(PlanNode::getIteratorDataType)).distinct().collect(Collectors.toList());
        IteratorData iteratorData = (IteratorData)((Object)iteratorDataTypes.get(0));
        if (iteratorDataTypes.size() > 1) {
            iteratorData = IteratorData.aggregated;
        }
        if (iteratorData == IteratorData.tripleBased && this.childrenHasOwnPath()) {
            iteratorData = IteratorData.aggregated;
        }
        if (plannodes.size() == 1) {
            if (iteratorData == IteratorData.tripleBased) {
                ret = this.unionAll((List)plannodes.get(0));
            } else {
                if (iteratorData != IteratorData.aggregated) throw new IllegalStateException("Should not get here!");
                ret = new Unique(new TrimTuple(this.unionAll((List)plannodes.get(0)), 0, 1));
            }
        } else if (iteratorData == IteratorData.tripleBased) {
            EqualsJoin equalsJoin = new EqualsJoin(this.unionAll((List)plannodes.get(0)), this.unionAll((List)plannodes.get(1)), true);
            for (int i = 2; i < plannodes.size(); ++i) {
                equalsJoin = new EqualsJoin(equalsJoin, this.unionAll((List)plannodes.get(i)), true);
            }
            ret = equalsJoin;
        } else {
            if (iteratorData != IteratorData.aggregated) throw new IllegalStateException("Should not get here!");
            PlanNode innerJoin = new InnerJoin(new Unique(new TrimTuple(this.unionAll((List)plannodes.get(0)), 0, 1)), new Unique(new TrimTuple(this.unionAll((List)plannodes.get(1)), 0, 1))).getJoined(BufferedPlanNode.class);
            for (int i = 2; i < plannodes.size(); ++i) {
                innerJoin = new InnerJoin(innerJoin, new Unique(new TrimTuple(this.unionAll((List)plannodes.get(i)), 0, 1))).getJoined(BufferedPlanNode.class);
            }
            ret = innerJoin;
        }
        if (printPlans) {
            String planAsGraphiz = this.getPlanAsGraphvizDot(ret, connectionsGroup);
            logger.info(planAsGraphiz);
        }
        if (iteratorData != IteratorData.aggregated) return new EnrichWithShape(ret, this);
        ret = new AggregateIteratorTypeOverride(ret);
        return new EnrichWithShape(ret, this);
    }

    public boolean childrenHasOwnPath() {
        return this.or.stream().flatMap(a -> a.stream().map(PathPropertyShape::hasOwnPath)).anyMatch(a -> a);
    }

    private PlanNode unionAll(List<PlanNode> planNodes) {
        return new Unique(new UnionNode(planNodes.toArray(new PlanNode[0])));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        if (this.deactivated) {
            return false;
        }
        return super.requiresEvaluation(addedStatements, removedStatements) || this.or.stream().flatMap(Collection::stream).map(p -> p.requiresEvaluation(addedStatements, removedStatements)).reduce((a, b) -> a != false || b != false).orElse(false) != false;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.OrConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrPropertyShape that = (OrPropertyShape)o;
        return this.or.equals(that.or);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.or);
    }

    public String toString() {
        return "OrPropertyShape{or=" + OrPropertyShape.toString(this.or) + '}';
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        Optional<PlanNode> reduce = this.or.stream().flatMap(Collection::stream).map(a -> a.getAllTargetsPlan(connectionsGroup, negated)).reduce((a, b) -> new UnionNode((PlanNode)a, (PlanNode)b));
        return new Unique(reduce.get());
    }
}

