/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.security.auth;

import java.security.MessageDigest;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.platform.security.auth.EnilinkPrincipal;
import net.enilink.vocab.auth.AUTH;
import net.enilink.vocab.foaf.FOAF;
import org.apache.commons.codec.binary.Base64;

public class AccountHelper {
    public static synchronized IEntity createUser(IEntityManager em, String username, String emailAddress) throws IllegalArgumentException {
        return AccountHelper.createUser(em, username, emailAddress, null);
    }

    public static synchronized IEntity createUser(IEntityManager em, String username, String emailAddress, String encodedPassword) throws IllegalArgumentException {
        if (AccountHelper.hasUserWithName(em, username)) {
            throw new IllegalArgumentException("A user with this name already exists.");
        }
        if (emailAddress != null && AccountHelper.hasUserWithEmail(em, emailAddress)) {
            throw new IllegalArgumentException("A user with this email address already exists.");
        }
        URI userId = AccountHelper.getUserURI(username);
        IResource user = (IResource)em.createNamed(userId, new IReference[]{FOAF.TYPE_AGENT}).as(IResource.class);
        user.addProperty((IReference)FOAF.PROPERTY_NICK, (Object)username);
        if (emailAddress != null) {
            user.addProperty((IReference)FOAF.PROPERTY_MBOX, (Object)AccountHelper.getMailboxURI(emailAddress));
        }
        if (encodedPassword != null) {
            user.addProperty((IReference)AUTH.PROPERTY_PASSWORD, (Object)encodedPassword);
        }
        return user;
    }

    public static String encodePassword(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(new String(password).getBytes("UTF-8"));
            return new String(new Base64().encode(digest));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to encode the password: " + e.getMessage() + " due to missing hash algorithm.");
        }
    }

    public static synchronized IEntity findUser(IEntityManager em, String username, String encodedPassword) {
        URI userId = AccountHelper.getUserURI(username);
        try (IExtendedIterator users = ((IQuery)((IQuery)((IQuery)em.createQuery("select ?user where { ?user ?property ?password filter isIRI(?user) }").setParameter("property", (Object)AUTH.PROPERTY_PASSWORD)).setParameter("user", (Object)userId)).setParameter("password", (Object)encodedPassword)).evaluate(IEntity.class, new Class[0]);){
            if (users.hasNext()) {
                IEntity iEntity = (IEntity)users.next();
                return iEntity;
            }
        }
        return null;
    }

    public static synchronized IEntity findUser(IEntityManager em, List<URI> externalIds) {
        StringBuilder querySb = new StringBuilder("select ?user where {\n");
        for (int i = 0; i < externalIds.size(); ++i) {
            querySb.append("\t{ ?user ?externalIdProp ?id").append(i).append(" }\n");
            if (i >= externalIds.size() - 1) continue;
            querySb.append("\tunion\n");
        }
        querySb.append("\tfilter isIRI(?user)\n");
        querySb.append("} limit 1");
        IQuery query = em.createQuery(querySb.toString());
        int i = 0;
        Iterator<URI> it = externalIds.iterator();
        while (it.hasNext()) {
            query.setParameter("id" + i, (Object)it.next());
            ++i;
        }
        query.setParameter("externalIdProp", (Object)AUTH.PROPERTY_EXTERNALID);
        IExtendedIterator result = query.evaluate(IEntity.class, new Class[0]);
        if (result.hasNext()) {
            return (IEntity)result.next();
        }
        return null;
    }

    public static List<URI> getExternalIds(Subject subject) {
        ArrayList<URI> externalIds = new ArrayList<URI>();
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof Group || principal instanceof EnilinkPrincipal) continue;
            URI externalId = URIs.createURI((String)("enilink:jaas:principal:" + principal.getClass().getName() + ":" + URIs.encodeOpaquePart((String)principal.toString(), (boolean)false)));
            externalIds.add(externalId);
        }
        return externalIds;
    }

    public static URI getMailboxURI(String emailAddress) {
        return URIs.createURI((String)("mailto:" + emailAddress));
    }

    public static URI getUserURI(String username) {
        return URIs.createURI((String)"enilink:user:").appendLocalPart(URIs.encodeOpaquePart((String)username, (boolean)false));
    }

    public static synchronized boolean hasUserWithEmail(IEntityManager em, String emailAddress) {
        URI mbox = AccountHelper.getMailboxURI(emailAddress);
        return ((IQuery)em.createQuery("prefix foaf: <http://xmlns.com/foaf/0.1/> ask { ?user foaf:mbox ?mbox }").setParameter("mbox", (Object)mbox)).getBooleanResult();
    }

    public static synchronized boolean hasUserWithName(IEntityManager em, String username) {
        URI userId = AccountHelper.getUserURI(username);
        return ((IQuery)em.createQuery("ask { ?user ?p ?o }").setParameter("user", (Object)userId)).getBooleanResult();
    }

    public static synchronized void linkExternalIds(IEntityManager em, final IReference userId, List<URI> externalIds) {
        em.add((Iterable)WrappedIterator.create(externalIds.iterator()).mapWith((IMap)new IMap<URI, IStatement>(){

            public IStatement map(URI externalId) {
                return new Statement(userId, (IReference)AUTH.PROPERTY_EXTERNALID, (Object)externalId);
            }
        }));
    }
}

