/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.security.modules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.enilink.platform.security.auth.BasicPrincipal;

public class UserMapLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, char[]> userMap;
    private BasicPrincipal simplePrincipal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.userMap = new HashMap<String, char[]>();
        String mapStr = String.valueOf(options.get("userMap"));
        if (null != mapStr && mapStr.startsWith("[") && mapStr.endsWith("]")) {
            String[] mapParts;
            mapStr = mapStr.substring(1, mapStr.length() - 1);
            for (String mapPart : mapParts = mapStr.trim().split(",")) {
                String[] userPw = mapPart.trim().split(":");
                if (userPw.length != 2) continue;
                this.userMap.put(userPw[0].trim(), userPw[1].trim().toCharArray());
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        callbacks.add(new NameCallback("Username: ", "<name>"));
        callbacks.add(new PasswordCallback("Password:", false));
        try {
            this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to garner  authentication information from the user");
        }
        String username = ((NameCallback)callbacks.get(0)).getName();
        char[] password = ((PasswordCallback)callbacks.get(1)).getPassword();
        if (this.userMap.containsKey(username) && Arrays.equals(this.userMap.get(username), password)) {
            this.simplePrincipal = new BasicPrincipal(username);
            return true;
        }
        throw new LoginException("Unknown user or wrong password.");
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.simplePrincipal != null) {
            this.subject.getPrincipals().add(this.simplePrincipal);
            this.simplePrincipal = null;
            return true;
        }
        throw new LoginException("Unknown user or wrong password.");
    }

    @Override
    public boolean abort() throws LoginException {
        this.simplePrincipal = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        for (BasicPrincipal p : this.subject.getPrincipals(BasicPrincipal.class)) {
            this.subject.getPrincipals().remove(p);
        }
        this.simplePrincipal = null;
        return true;
    }
}

