/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core;

import com.google.inject.AbstractModule;
import net.enilink.platform.core.Activator;
import net.enilink.platform.core.IContext;
import net.enilink.platform.core.IContextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ContextProviderModule
extends AbstractModule {
    static IContextProvider contextProvider = new IContextProvider(){

        @Override
        public IContext get() {
            try {
                BundleContext bundleContext = Activator.getContext();
                for (ServiceReference spRef : bundleContext.getServiceReferences(IContextProvider.class, null)) {
                    IContext userCtx = ((IContextProvider)bundleContext.getService(spRef)).get();
                    bundleContext.ungetService(spRef);
                    if (userCtx == null) continue;
                    return userCtx;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            return null;
        }
    };

    protected void configure() {
        this.bind(IContextProvider.class).toInstance((Object)contextProvider);
    }
}

