/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.util.Modules;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import net.enilink.commons.iterator.IMap;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.composition.properties.PropertySetFactory;
import net.enilink.komma.core.BlankNode;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.IProvider;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IUnitOfWork;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.LinkedHashGraph;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.CacheModule;
import net.enilink.komma.em.CachingEntityManagerModule;
import net.enilink.komma.em.util.UnitOfWork;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IModelSetFactory;
import net.enilink.komma.model.MODELS;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.ModelSetModule;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.base.IURIMapRule;
import net.enilink.komma.model.base.IURIMapRuleSet;
import net.enilink.komma.model.base.SimpleURIMapRule;
import net.enilink.platform.core.Config;
import net.enilink.platform.core.ContextProviderModule;
import net.enilink.platform.core.IContext;
import net.enilink.platform.core.LazyModelSupport;
import net.enilink.platform.core.OwlimSeModelSetSupport;
import net.enilink.platform.core.SessionModelSetSupport;
import net.enilink.platform.core.UseService;
import net.enilink.platform.core.security.ISecureEntity;
import net.enilink.platform.core.security.SecureEntitySupport;
import net.enilink.platform.core.security.SecureModelSetSupport;
import net.enilink.platform.core.security.SecureModelSupport;
import net.enilink.platform.core.security.SecurePropertySetFactory;
import net.enilink.platform.core.security.SecurityUtil;
import net.enilink.platform.security.auth.AccountHelper;
import net.enilink.platform.security.auth.AuthModule;
import net.enilink.vocab.acl.Authorization;
import net.enilink.vocab.acl.ENILINKACL;
import net.enilink.vocab.acl.WEBACL;
import net.enilink.vocab.auth.AUTH;
import net.enilink.vocab.foaf.FOAF;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.RDFS;
import net.enilink.vocab.rdfs.Resource;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelSetManager {
    private static final Logger log = LoggerFactory.getLogger(ModelSetManager.class);
    public static final ModelSetManager INSTANCE = new ModelSetManager();
    private static final URI META_MODELSET = URIs.createURI((String)"urn:enilink:metadata");
    private static final URI DATA_MODELSET = URIs.createURI((String)"urn:enilink:data");
    private UnitOfWork uow = new UnitOfWork();
    private IModelSet modelSet;

    ModelSetManager() {
    }

    protected void overwriteProperty(IGraph data, URI s, URI property, Object value) {
        if (value != null) {
            data.remove((IReference)s, (IReference)property, null, new IReference[0]);
            data.add((IReference)s, (IReference)property, value, new IReference[0]);
        }
    }

    protected void addSystemProperties(URI modelSet, IGraph config) {
        String target = modelSet.localPart();
        this.overwriteProperty(config, modelSet, MODELS.NAMESPACE_URI.appendLocalPart("server"), System.getProperty("net.enilink." + target + ".server"));
        this.overwriteProperty(config, modelSet, MODELS.NAMESPACE_URI.appendLocalPart("username"), System.getProperty("net.enilink." + target + ".username"));
        this.overwriteProperty(config, modelSet, MODELS.NAMESPACE_URI.appendLocalPart("password"), System.getProperty("net.enilink." + target + ".password"));
    }

    protected Module createModelSetGuiceModule(KommaModule module) {
        return Modules.override((Module[])new Module[]{new ModelSetModule(module){

            protected IProvider<Locale> getLocaleProvider() {
                return new IProvider<Locale>(){

                    public Locale get() {
                        IContext context = ContextProviderModule.contextProvider.get();
                        return context != null ? context.getLocale() : Locale.getDefault();
                    }
                };
            }

            protected Module getEntityManagerModule() {
                return new CachingEntityManagerModule(){

                    protected Class<? extends PropertySetFactory> getPropertySetFactoryClass() {
                        return SecurePropertySetFactory.class;
                    }
                };
            }

            protected List<? extends Module> createFactoryModules(KommaModule kommaModule) {
                ArrayList<CacheModule> modules = new ArrayList<CacheModule>(super.createFactoryModules(kommaModule));
                modules.add(new CacheModule(BlankNode.generateId()));
                return modules;
            }
        }}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(UnitOfWork.class).toInstance((Object)ModelSetManager.this.uow);
                this.bind(IUnitOfWork.class).toInstance((Object)ModelSetManager.this.uow);
            }

            @Provides
            @Named(value="net.enilink.komma.properties")
            Map<String, Object> provideProperties() {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("net.enilink.komma.query.timeout", 20000);
                return properties;
            }
        }});
    }

    protected KommaModule createDataModelSetModule() {
        KommaModule module = ModelPlugin.createModelSetModule((ClassLoader)this.getClass().getClassLoader());
        module.addBehaviour(OwlimSeModelSetSupport.class);
        module.addBehaviour(SessionModelSetSupport.class);
        module.addBehaviour(LazyModelSupport.class);
        module.addBehaviour(SecureModelSetSupport.class);
        module.addBehaviour(SecureModelSupport.class);
        module.addConcept(ISecureEntity.class);
        module.addBehaviour(SecureEntitySupport.class);
        return module;
    }

    protected IGraph createModelSetConfig(Config config, URI modelSet) {
        LinkedHashGraph graph = new LinkedHashGraph();
        graph.add((IReference)modelSet, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.TYPE_MODELSET, new IReference[0]);
        HashSet<IReference> seen = new HashSet<IReference>();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(modelSet);
        while (!queue.isEmpty()) {
            IReference s = (IReference)queue.remove();
            if (!seen.add(s)) continue;
            Config about = config.filter(s, null, null, new IReference[0]);
            graph.addAll((Collection)((Object)about));
            for (Object o : about.objects()) {
                if (!(o instanceof IReference) || seen.contains(o)) continue;
                queue.add((IReference)o);
            }
        }
        this.addSystemProperties(modelSet, (IGraph)graph);
        return graph;
    }

    protected IModelSet createMetaModelSet(Config config) {
        KommaModule module = ModelPlugin.createModelSetModule((ClassLoader)this.getClass().getClassLoader());
        module.addBehaviour(OwlimSeModelSetSupport.class);
        module.addBehaviour(SessionModelSetSupport.class);
        module.addConcept(ISecureEntity.class);
        module.addBehaviour(SecureEntitySupport.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModelSetGuiceModule(module), new ContextProviderModule()});
        URI msUri = META_MODELSET;
        IGraph graph = this.createModelSetConfig(config, msUri);
        if (!graph.contains((IReference)msUri, (IReference)MODELS.NAMESPACE_URI.appendLocalPart("repository"), null, new IReference[0])) {
            graph.add((IReference)msUri, (IReference)MODELS.NAMESPACE_URI.appendLocalPart("repository"), (Object)"enilink-meta", new IReference[0]);
        }
        IModelSetFactory factory = (IModelSetFactory)injector.getInstance(IModelSetFactory.class);
        IModelSet metaModelSet = factory.createModelSet(msUri, graph);
        metaModelSet.getModule().includeModule(this.createDataModelSetModule());
        return metaModelSet;
    }

    protected IModelSet createModelSet(Config config, IModel metaDataModel) {
        URI msUri = DATA_MODELSET;
        IGraph graph = this.createModelSetConfig(config, msUri);
        metaDataModel.getManager().remove((Iterable)WrappedIterator.create((Iterator)graph.filter((IReference)msUri, null, null, new IReference[0]).iterator()).mapWith((IMap)new IMap<IStatement, IStatement>(){

            public IStatement map(IStatement stmt) {
                return new Statement(stmt.getSubject(), stmt.getPredicate(), null);
            }
        }));
        graph.add((IReference)msUri, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.NAMESPACE_URI.appendLocalPart("ProjectModelSet"), new IReference[0]);
        metaDataModel.getManager().add((Iterable)graph);
        IModelSet.Internal modelSet = (IModelSet.Internal)metaDataModel.getManager().find((IReference)msUri);
        modelSet = modelSet.create();
        return modelSet;
    }

    protected IModelSet createModelSet(Config config) {
        KommaModule module = this.createDataModelSetModule();
        module.includeModule((KommaModule)new AuthModule());
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModelSetGuiceModule(module), new ContextProviderModule()});
        IModelSetFactory factory = (IModelSetFactory)injector.getInstance(IModelSetFactory.class);
        URI msUri = DATA_MODELSET;
        boolean hasConfig = config.contains((IReference)msUri, null, null, new IReference[0]);
        IGraph graph = this.createModelSetConfig(config, msUri);
        if (!hasConfig) {
            graph.add((IReference)msUri, (IReference)MODELS.NAMESPACE_URI.appendFragment("inference"), (Object)false, new IReference[0]);
            graph.add((IReference)msUri, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.NAMESPACE_URI.appendLocalPart("MemoryModelSet"), new IReference[0]);
        }
        graph.add((IReference)msUri, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.NAMESPACE_URI.appendLocalPart("ProjectModelSet"), new IReference[0]);
        IModelSet modelSet = factory.createModelSet(msUri, graph);
        return modelSet;
    }

    protected void createModels(IModelSet modelSet) {
        modelSet.createModel(SecurityUtil.USERS_MODEL);
        IEntityManager em = modelSet.getMetaDataManager();
        Authorization auth = (Authorization)em.createNamed(URIs.createURI((String)"urn:auth:usersModelRestricted"), Authorization.class, new Class[0]);
        auth.setAclAccessTo((Resource)em.find((IReference)SecurityUtil.USERS_MODEL, Resource.class, new Class[0]));
        auth.setAclAgentClass((net.enilink.vocab.rdfs.Class)em.find((IReference)FOAF.TYPE_AGENT, net.enilink.vocab.rdfs.Class.class, new Class[0]));
        auth.getAclMode().clear();
        auth.getAclMode().add(em.find((IReference)ENILINKACL.MODE_WRITERESTRICTED, net.enilink.vocab.rdfs.Class.class, new Class[0]));
        String modelsLookupDir = FrameworkUtil.getBundle(this.getClass()).getBundleContext().getProperty("net.enilink.models.dir");
        if (modelsLookupDir != null) {
            log.info("Looking for models in: {}", (Object)modelsLookupDir);
            try {
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**/*.{ttl,owl}");
                List modelFiles = Files.walk(Paths.get(modelsLookupDir, new String[0]), new FileVisitOption[0]).filter(matcher::matches).collect(Collectors.toList());
                IURIMapRuleSet mapRules = modelSet.getURIConverter().getURIMapRules();
                for (Path modelFile : modelFiles) {
                    String modelUri;
                    URI fileUri = URIs.createFileURI((String)modelFile.toString());
                    try (InputStream in = Files.newInputStream(modelFile, new OpenOption[0]);){
                        String mimeType = ModelUtil.mimeType((String)modelFile.toString());
                        modelUri = ModelUtil.findOntology((InputStream)in, (String)fileUri.toString(), (String)mimeType);
                    }
                    if (modelUri != null) {
                        mapRules.addRule((IURIMapRule)new SimpleURIMapRule(modelUri, modelFile.toString()));
                    } else {
                        modelUri = modelFile.toString();
                    }
                    log.info("Creating model <{}>", (Object)modelUri);
                    modelSet.createModel(URIs.createURI((String)modelUri));
                }
            }
            catch (Exception e) {
                log.error("Error while loading models", (Throwable)e);
            }
        }
    }

    public synchronized IUnitOfWork getUnitOfWork() {
        return this.uow;
    }

    public synchronized IModelSet getModelSet() {
        if (this.modelSet == null) {
            this.modelSet = (IModelSet)new UseService<Config, IModelSet>(Config.class){

                @Override
                protected IModelSet withService(final Config config) {
                    return Subject.doAs(SecurityUtil.SYSTEM_USER_SUBJECT, new PrivilegedAction<IModelSet>(){

                        @Override
                        public IModelSet run() {
                            IModelSet modelSet;
                            if (!config.contains((IReference)META_MODELSET, null, null, new IReference[0])) {
                                modelSet = ModelSetManager.this.createModelSet(config);
                            } else {
                                IModelSet metaModelSet = ModelSetManager.this.createMetaModelSet(config);
                                IModel metaDataModel = metaModelSet.createModel(URIs.createURI((String)"urn:enilink:metadata"));
                                modelSet = ModelSetManager.this.createModelSet(config, metaDataModel);
                            }
                            modelSet.getModule().addReadableGraph(SecurityUtil.USERS_MODEL);
                            modelSet.getModule().addNamespace("foaf", FOAF.NAMESPACE_URI);
                            modelSet.getMetaDataManager().createNamed(FOAF.TYPE_AGENT, new IReference[]{RDFS.TYPE_CLASS});
                            modelSet.getMetaDataManager().createNamed(SecurityUtil.UNKNOWN_USER, new IReference[]{FOAF.TYPE_AGENT});
                            ModelSetManager.this.loadUsersAndGroups(modelSet.getMetaDataManager(), config);
                            ModelSetManager.this.loadAcls(modelSet.getMetaDataManager(), config);
                            ModelSetManager.this.createModels(modelSet);
                            return modelSet;
                        }
                    });
                }
            }.getResult();
            this.getUnitOfWork().end();
        }
        return this.modelSet;
    }

    protected void loadUsersAndGroups(IEntityManager em, Config config) {
        HashSet<IReference> seenAgents = new HashSet<IReference>();
        for (IReference iReference : Arrays.asList(FOAF.TYPE_AGENT, FOAF.TYPE_PERSON)) {
            for (IReference agent : config.filter(null, (IReference)RDF.PROPERTY_TYPE, iReference, new IReference[0]).subjects()) {
                if (!seenAgents.add(agent)) continue;
                HashSet<Object> toAdd = new HashSet<Object>();
                Config about = config.filter(agent, null, null, new IReference[0]);
                Iterator iterator = about.iterator();
                while (iterator.hasNext()) {
                    IStatement stmt = (IStatement)iterator.next();
                    if (AUTH.PROPERTY_PASSWORD.equals((Object)stmt.getPredicate())) {
                        if (!(stmt.getObject() instanceof ILiteral)) continue;
                        toAdd.add(new Statement(stmt.getSubject(), stmt.getPredicate(), (Object)AccountHelper.encodePassword((String)((ILiteral)stmt.getObject()).getLabel())));
                        continue;
                    }
                    toAdd.add(stmt);
                }
                if (config.filter(agent, (IReference)FOAF.PROPERTY_NICK, null, new IReference[0]).isEmpty()) {
                    toAdd.add(new Statement(agent, (IReference)FOAF.PROPERTY_NICK, (Object)agent.getURI().localPart()));
                }
                em.add(toAdd);
                HashSet<IReference> seen = new HashSet<IReference>();
                for (IStatement iStatement : toAdd) {
                    if (!(iStatement.getObject() instanceof IReference) || !seen.add((IReference)iStatement.getObject())) continue;
                    this.copyFromGraph(em, (IReference)iStatement.getObject(), config);
                }
            }
        }
        for (IReference iReference : Arrays.asList(FOAF.TYPE_GROUP, FOAF.TYPE_ORGANIZATION)) {
            for (IReference group : config.filter(null, (IReference)RDF.PROPERTY_TYPE, iReference, new IReference[0]).subjects()) {
                if (!seenAgents.add(group)) continue;
                this.copyFromGraph(em, group, config);
            }
        }
    }

    protected void loadAcls(IEntityManager em, Config config) {
        for (IReference aclAuth : config.filter(null, (IReference)RDF.PROPERTY_TYPE, WEBACL.TYPE_AUTHORIZATION, new IReference[0]).subjects()) {
            this.copyFromGraph(em, aclAuth, config);
        }
    }

    protected void copyFromGraph(IEntityManager em, IReference subject, IGraph graph) {
        HashSet<IReference> seen = new HashSet<IReference>();
        LinkedList<IReference> queue = new LinkedList<IReference>();
        queue.add(subject);
        while (!queue.isEmpty()) {
            IReference s = (IReference)queue.remove();
            if (!seen.add(s)) continue;
            IGraph about = graph.filter(s, null, null, new IReference[0]);
            em.add((Iterable)about);
            for (Object o : about.objects()) {
                if (!(o instanceof IReference) || seen.contains(o)) continue;
                queue.add((IReference)o);
            }
        }
    }

    public synchronized void shutdown() {
        if (this.modelSet != null) {
            this.modelSet.dispose();
            this.modelSet = null;
        }
    }
}

