/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.enilink.komma.core.BlankNode;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IUnitOfWork;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.LinkedHashGraph;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.CacheModule;
import net.enilink.komma.em.util.UnitOfWork;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IModelSetFactory;
import net.enilink.komma.model.MODELS;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.ModelSetModule;
import net.enilink.platform.core.Config;
import net.enilink.platform.core.ContextProviderModule;
import net.enilink.platform.core.PluginConfigModel;
import net.enilink.platform.core.PluginConfigModelSupport;
import net.enilink.vocab.rdf.RDF;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class PluginConfigManager {
    private static final Logger log = LoggerFactory.getLogger(PluginConfigManager.class);
    private final UnitOfWork uow = new UnitOfWork();
    private IModelSet modelSet;
    private BundleContext context;
    private Config config;
    private List<Path> pluginConfigPaths = null;
    private ServiceRegistration<PluginConfigModel> configModelServiceReg = null;
    private Thread watcher;

    @Activate
    public void activate() throws InvalidSyntaxException, URISyntaxException {
        this.modelSet = this.createModelSet();
        this.getUnitOfWork().end();
        this.context = FrameworkUtil.getBundle(PluginConfigManager.class).getBundleContext();
        this.pluginConfigPaths = new ArrayList<Path>();
        for (String locationType : new String[]{Location.INSTANCE_FILTER, Location.ECLIPSE_HOME_FILTER}) {
            Path path;
            Path configPath;
            Location location;
            Collection locServices = this.context.getServiceReferences(Location.class, locationType);
            if (locServices.isEmpty() || (location = (Location)this.context.getService((ServiceReference)locServices.iterator().next())) == null || !Files.exists(configPath = (path = Paths.get(location.getURL().toURI())).resolve("config"), new LinkOption[0])) continue;
            this.pluginConfigPaths.add(configPath);
        }
        log.info("Config file directories: {}", this.pluginConfigPaths);
        this.watchForChanges();
        this.context.addBundleListener(new BundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent evt) {
                if (evt.getType() == 16 || evt.getType() == 64) {
                    URI modelUri = URIs.createURI((String)("plugin://" + evt.getBundle().getSymbolicName() + "/"));
                    PluginConfigManager.this.uow.begin();
                    try {
                        IModel configModel = PluginConfigManager.this.modelSet.getModel(modelUri, false);
                        if (configModel != null) {
                            log.info("Unloading plugin config model: {}", (Object)configModel.getURI());
                            PluginConfigManager.this.modelSet.getDataChangeSupport().setEnabled(null, false);
                            configModel.unloadManager();
                            configModel.getManager().clear();
                            configModel.unload();
                            PluginConfigManager.this.modelSet.getModels().remove(configModel);
                        }
                    }
                    finally {
                        PluginConfigManager.this.uow.end();
                    }
                }
            }
        });
        this.configModelServiceReg = this.context.registerService(PluginConfigModel.class, (ServiceFactory)new ServiceFactory<PluginConfigModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public PluginConfigModel getService(Bundle bundle, ServiceRegistration<PluginConfigModel> r) {
                try {
                    PluginConfigManager.this.uow.begin();
                    URI modelUri = URIs.createURI((String)("plugin://" + bundle.getSymbolicName() + "/"));
                    IModel configModel = PluginConfigManager.this.modelSet.getModel(modelUri, false);
                    if (configModel == null || !configModel.isLoaded()) {
                        configModel = PluginConfigManager.this.modelSet.createModel(modelUri);
                        PluginConfigManager.this.loadConfig(bundle, configModel);
                    }
                    PluginConfigModel pluginConfigModel = (PluginConfigModel)configModel;
                    return pluginConfigModel;
                }
                finally {
                    PluginConfigManager.this.uow.end();
                }
            }

            public void ungetService(Bundle bundle, ServiceRegistration<PluginConfigModel> r, PluginConfigModel cm) {
            }
        }, null);
    }

    private void watchForChanges() {
        if (this.pluginConfigPaths.isEmpty()) {
            return;
        }
        try {
            final WatchService watchService = FileSystems.getDefault().newWatchService();
            for (Path path : this.pluginConfigPaths) {
                path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            this.watcher = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            WatchKey wk;
                            if ((wk = watchService.take()) == null) {
                                continue;
                            }
                            List<WatchEvent<?>> events = wk.pollEvents();
                            if (!events.isEmpty()) {
                                for (WatchEvent<?> event : events) {
                                    Path path;
                                    WatchEvent.Kind<?> kind = event.kind();
                                    if (kind == StandardWatchEventKinds.OVERFLOW || !(path = (Path)event.context()).getFileName().toString().endsWith(".ttl")) continue;
                                    String filename = path.getFileName().toString();
                                    String bundleName = filename.substring(0, filename.lastIndexOf(46));
                                    URI modelUri = URIs.createURI((String)("plugin://" + bundleName + "/"));
                                    ArrayList<Bundle> affectedBundles = new ArrayList<Bundle>();
                                    PluginConfigManager.this.uow.begin();
                                    try {
                                        IModel model = PluginConfigManager.this.modelSet.getModel(modelUri, false);
                                        if (model != null) {
                                            for (Bundle b : PluginConfigManager.this.context.getBundles()) {
                                                if (!b.getSymbolicName().startsWith(bundleName) || b.getState() != 32) continue;
                                                affectedBundles.add(b);
                                            }
                                            for (Bundle b : affectedBundles) {
                                                try {
                                                    b.stop(1);
                                                }
                                                catch (BundleException e) {
                                                    log.error("Unable to stop bundle " + b.getSymbolicName() + " after configuration change.", (Throwable)e);
                                                }
                                            }
                                            PluginConfigManager.this.modelSet.getDataChangeSupport().setEnabled(null, false);
                                            model.getManager().clear();
                                            model.unload();
                                            Path basePath = (Path)wk.watchable();
                                            Path fullPath = basePath.resolve(path);
                                            if (Files.exists(fullPath, new LinkOption[0])) {
                                                try {
                                                    URI configFileUri = URIs.createURI((String)fullPath.toUri().toString());
                                                    InputStream in = PluginConfigManager.this.modelSet.getURIConverter().createInputStream(configFileUri);
                                                    log.debug("Loading config file " + configFileUri);
                                                    HashMap<String, String> options = new HashMap<String, String>();
                                                    options.put("MIME_TYPE", "text/turtle");
                                                    model.load(in, options);
                                                    model.setLoaded(true);
                                                }
                                                catch (IOException e) {
                                                    log.error("Unable to load config file " + fullPath, (Throwable)e);
                                                }
                                            }
                                        }
                                    }
                                    finally {
                                        PluginConfigManager.this.uow.end();
                                    }
                                    for (Bundle b : affectedBundles) {
                                        try {
                                            b.start(1);
                                        }
                                        catch (BundleException e) {
                                            log.error("Unable to restart bundle " + b.getSymbolicName() + " after configuration change.", (Throwable)e);
                                        }
                                    }
                                }
                                log.debug("Change of plugin configuration detected");
                            }
                            if (!wk.reset()) break;
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            });
            this.watcher.setName("Configuration updater");
            this.watcher.start();
        }
        catch (IOException e) {
            log.error("Unable to create watcher for configuration directories: " + this.pluginConfigPaths, (Throwable)e);
        }
    }

    private void loadConfig(Bundle bundle, IModel configModel) {
        URL defaultConfigUrl;
        String pluginName = configModel.getURI().authority();
        URI configFileUri = null;
        for (Path path : this.pluginConfigPaths) {
            Path configFilePath = path.resolve(pluginName + ".ttl");
            if (!Files.exists(configFilePath, new LinkOption[0])) continue;
            configFileUri = URIs.createURI((String)configFilePath.toUri().toString());
            break;
        }
        URI copyFileUri = null;
        if (configFileUri == null && (defaultConfigUrl = bundle.getResource("OSGI-INF/" + pluginName + "-default.ttl")) != null) {
            try {
                copyFileUri = configFileUri = URIs.createURI((String)defaultConfigUrl.toURI().toString());
            }
            catch (URISyntaxException e) {
                log.error("Invalid URI for config file " + defaultConfigUrl, (Throwable)e);
            }
        }
        try {
            InputStream in = configModel.getModelSet().getURIConverter().createInputStream(configFileUri);
            log.debug("Loading config file " + configFileUri);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("MIME_TYPE", "text/turtle");
            configModel.load(in, options);
            configModel.setLoaded(true);
        }
        catch (IOException e) {
            log.error("Unable to load config file " + configFileUri, (Throwable)e);
        }
        if (!this.pluginConfigPaths.isEmpty()) {
            URL templateConfigUrl;
            if (configFileUri == null && (templateConfigUrl = bundle.getResource("OSGI-INF/" + pluginName + "-template.ttl")) != null) {
                try {
                    copyFileUri = URIs.createURI((String)templateConfigUrl.toURI().toString());
                }
                catch (URISyntaxException e) {
                    log.error("Invalid URI for config file " + templateConfigUrl, (Throwable)e);
                }
            }
            if (copyFileUri != null) {
                Path targetPath = this.pluginConfigPaths.get(0);
                Path targetFile = targetPath.resolve(copyFileUri.lastSegment());
                this.copyToFile(copyFileUri, targetFile);
            }
        }
    }

    protected void copyToFile(URI resoureUri, Path targetFile) {
        if (!Files.exists(targetFile, new LinkOption[0])) {
            try {
                InputStream in = this.modelSet.getURIConverter().createInputStream(resoureUri);
                Files.copy(in, targetFile, new CopyOption[0]);
            }
            catch (IOException ioe) {
                log.info("Failed to copy config file to path {}", (Object)targetFile);
            }
        }
    }

    protected Module createModelSetGuiceModule(KommaModule module) {
        return Modules.override((Module[])new Module[]{new ModelSetModule(module){

            protected List<? extends Module> createFactoryModules(KommaModule kommaModule) {
                ArrayList<CacheModule> modules = new ArrayList<CacheModule>(super.createFactoryModules(kommaModule));
                modules.add(new CacheModule(BlankNode.generateId()));
                return modules;
            }
        }}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(UnitOfWork.class).toInstance((Object)PluginConfigManager.this.uow);
                this.bind(IUnitOfWork.class).toInstance((Object)PluginConfigManager.this.uow);
            }
        }});
    }

    protected IModelSet createModelSet() {
        KommaModule module = ModelPlugin.createModelSetModule((ClassLoader)this.getClass().getClassLoader());
        module.addConcept(PluginConfigModel.class);
        module.addBehaviour(PluginConfigModelSupport.class);
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModelSetGuiceModule(module), new ContextProviderModule()});
        IModelSetFactory factory = (IModelSetFactory)injector.getInstance(IModelSetFactory.class);
        URI msUri = URIs.createURI((String)"urn:enilink:config");
        LinkedHashGraph graph = new LinkedHashGraph();
        graph.add((IReference)msUri, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.TYPE_MODELSET, new IReference[0]);
        graph.add((IReference)msUri, (IReference)MODELS.NAMESPACE_URI.appendFragment("inference"), (Object)false, new IReference[0]);
        graph.add((IReference)msUri, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.NAMESPACE_URI.appendLocalPart("MemoryModelSet"), new IReference[0]);
        IModelSet modelSet = factory.createModelSet(msUri, (IGraph)graph);
        return modelSet;
    }

    public synchronized IUnitOfWork getUnitOfWork() {
        return this.uow;
    }

    @Reference
    public void setConfig(Config config) {
        this.config = config;
    }

    @Deactivate
    public void deactivate() {
        if (this.watcher != null) {
            this.watcher.interrupt();
            this.watcher = null;
        }
        if (this.configModelServiceReg != null) {
            this.configModelServiceReg.unregister();
            this.configModelServiceReg = null;
        }
        if (this.modelSet != null) {
            this.modelSet.dispose();
            this.modelSet = null;
        }
    }
}

