/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.enilink.composition.annotations.Precedes;
import net.enilink.composition.properties.PropertySetFactory;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.common.adapter.AdapterSet;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.adapter.IAdapterSet;
import net.enilink.komma.common.command.ICommandStack;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.EntityVar;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.EditingDomainCommandStack;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.provider.ComposedAdapterFactory;
import net.enilink.komma.edit.provider.ReflectiveItemProviderAdapterFactory;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelSet;
import net.enilink.platform.core.IContext;
import net.enilink.platform.core.IContextProvider;
import net.enilink.platform.core.ISession;
import net.enilink.platform.core.security.ISecureModelSet;
import net.enilink.platform.core.security.SecurePropertySetFactory;
import net.enilink.platform.core.security.SecurityUtil;

@Precedes(value={IModelSet.class})
public abstract class SessionModelSetSupport
implements IModelSet.Internal,
Behaviour<IModelSet> {
    private EntityVar<Map<Object, IAdapterSet>> sessionScopedAdapterSets;
    @Inject
    protected IContextProvider contextProvider;

    private ComposedAdapterFactory createAdapterFactory() {
        return new ComposedAdapterFactory(ComposedAdapterFactory.IDescriptor.IRegistry.INSTANCE){
            DefaultItemProviderAdapterFactory defaultAdapterFactory;
            {
                this.defaultAdapterFactory = new DefaultItemProviderAdapterFactory();
                this.defaultAdapterFactory.setParentAdapterFactory(this);
            }

            protected IAdapterFactory getDefaultAdapterFactory(Object type) {
                return this.defaultAdapterFactory;
            }

            class DefaultItemProviderAdapterFactory
            extends ReflectiveItemProviderAdapterFactory {
                public DefaultItemProviderAdapterFactory() {
                    super((IResourceLocator)KommaEditPlugin.getPlugin(), new URI[0]);
                }

                public Object adapt(Object object, Object type) {
                    if (object instanceof IClass) {
                        return null;
                    }
                    return super.adapt(object, type);
                }

                public boolean isFactoryForType(Object type) {
                    return type instanceof URI || this.supportedTypes.contains(type);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAdapterSet adapters() {
        IAdapterSet adapterSet;
        Map<Key, IAdapterSet> adapterSets;
        IContext context = this.contextProvider.get();
        ISession session = context.getSession();
        Key key = (Key)session.getAttribute(Key.class.getName());
        if (key == null) {
            key = new Key();
            session.setAttribute(Key.class.getName(), key);
        }
        if ((adapterSets = (Map<Key, IAdapterSet>)this.sessionScopedAdapterSets.get()) == null) {
            EntityVar<Map<Object, IAdapterSet>> entityVar = this.sessionScopedAdapterSets;
            synchronized (entityVar) {
                adapterSets = (Map)this.sessionScopedAdapterSets.get();
                if (adapterSets == null) {
                    adapterSets = Collections.synchronizedMap(new WeakHashMap());
                    this.sessionScopedAdapterSets.set(adapterSets);
                }
            }
        }
        if ((adapterSet = (IAdapterSet)adapterSets.get(key)) == null) {
            Map<Key, IAdapterSet> map = adapterSets;
            synchronized (map) {
                adapterSet = (IAdapterSet)adapterSets.get(key);
                if (adapterSet == null) {
                    adapterSet = new AdapterSet(this.getBehaviourDelegate());
                    adapterSets.put(key, adapterSet);
                    this.initializeAdapters();
                }
            }
        }
        return adapterSet;
    }

    protected void initializeAdapters() {
        EditingDomainCommandStack commandStack = new EditingDomainCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((IAdapterFactory)this.createAdapterFactory(), (ICommandStack)commandStack, (IModelSet)this.getBehaviourDelegate()){

            public boolean isReadOnly(IModel model) {
                URI user = SecurityUtil.getUser();
                if (user != null && model.getModelSet() instanceof ISecureModelSet && ((ISecureModelSet)model.getModelSet()).writeModeFor((IReference)model, (IReference)user) == null) {
                    return true;
                }
                return super.isReadOnly(model);
            }
        };
        commandStack.setEditingDomain((IEditingDomain)editingDomain);
    }

    public Class<? extends PropertySetFactory> getPropertySetFactoryClass() {
        return SecurePropertySetFactory.class;
    }

    public static class Key {
    }
}

