/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core.jaas;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.model.IModelSet;
import net.enilink.platform.core.Activator;
import net.enilink.platform.security.auth.AccountHelper;
import net.enilink.platform.security.auth.EnilinkPrincipal;
import net.enilink.platform.security.callbacks.RegisterCallback;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnilinkLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean standalone;
    private boolean autoRegister;
    private String principalFilterRegex;
    private EnilinkPrincipal enilinkPrincipal;
    private IEntityManager entityManager;
    private ServiceReference<IModelSet> modelSetRef;
    private static final Logger logger = LoggerFactory.getLogger(EnilinkLoginModule.class);

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.standalone = "standalone".equalsIgnoreCase(String.valueOf(options.get("mode")));
        this.autoRegister = Boolean.parseBoolean(String.valueOf(options.get("autoRegister")));
        if (this.autoRegister && !this.standalone) {
            this.principalFilterRegex = options.containsKey("principalFilter") ? String.valueOf(options.get("principalFilter")) : "[^@]{1,}[@][^@]{1,}";
            logger.trace("principalFilter set to '" + this.principalFilterRegex + "'");
        }
    }

    private boolean isRegister() {
        RegisterCallback registerCallback = new RegisterCallback();
        try {
            this.callbackHandler.handle(new Callback[]{registerCallback});
        }
        catch (Exception e) {
            return false;
        }
        return registerCallback.isRegister();
    }

    protected void releaseEntityManager() {
        if (this.entityManager != null) {
            Activator.getContext().ungetService(this.modelSetRef);
            this.entityManager = null;
            this.modelSetRef = null;
        }
    }

    protected IEntityManager getEntityManager() throws LoginException {
        IModelSet modelSet;
        if (this.entityManager != null) {
            return this.entityManager;
        }
        this.modelSetRef = Activator.getContext().getServiceReference(IModelSet.class);
        if (this.modelSetRef != null && (modelSet = (IModelSet)Activator.getContext().getService(this.modelSetRef)) != null) {
            this.entityManager = modelSet.getMetaDataManager();
            return this.entityManager;
        }
        throw new LoginException("Unable to connect to the user database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        if (this.standalone) {
            URI userId;
            ArrayList<Callback> callbacks = new ArrayList<Callback>();
            callbacks.add(new NameCallback("Username: ", "<name>"));
            callbacks.add(new PasswordCallback("Password:", false));
            try {
                this.callbackHandler.handle(callbacks.toArray(new Callback[callbacks.size()]));
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.getMessage());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException(uce.getMessage() + " not available to garner  authentication information from the user");
            }
            String username = ((NameCallback)callbacks.get(0)).getName();
            char[] password = ((PasswordCallback)callbacks.get(1)).getPassword();
            String encodedPassword = AccountHelper.encodePassword((String)new String(password));
            IEntityManager em = this.getEntityManager();
            try {
                IEntity user = AccountHelper.findUser((IEntityManager)em, (String)username, (String)encodedPassword);
                if (user == null) {
                    throw new LoginException("Unknown user or wrong password.");
                }
                userId = user.getURI();
            }
            finally {
                this.releaseEntityManager();
            }
            this.enilinkPrincipal = new EnilinkPrincipal(userId);
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() throws LoginException {
        try {
            List externalIds;
            if (this.enilinkPrincipal == null && !(externalIds = AccountHelper.getExternalIds((Subject)this.subject)).isEmpty()) {
                boolean isRegister;
                IEntity user;
                URI userId = null;
                Iterator<EnilinkPrincipal> principals = this.subject.getPrincipals(EnilinkPrincipal.class).iterator();
                if (principals.hasNext()) {
                    userId = principals.next().getId();
                }
                if (userId == null && (user = AccountHelper.findUser((IEntityManager)this.getEntityManager(), (List)externalIds)) != null) {
                    userId = user.getURI();
                }
                if (this.autoRegister && userId == null) {
                    String username = null;
                    for (Principal basePrincipal : this.subject.getPrincipals()) {
                        if (basePrincipal instanceof Group || this.principalFilterRegex != null && !this.principalFilterRegex.isEmpty() && !Pattern.matches(this.principalFilterRegex, basePrincipal.getName())) continue;
                        username = basePrincipal.getName();
                    }
                    if (username != null) {
                        IEntity user2 = AccountHelper.createUser((IEntityManager)this.getEntityManager(), username, null, null);
                        if (user2 != null) {
                            userId = user2.getURI();
                            AccountHelper.linkExternalIds((IEntityManager)this.getEntityManager(), (IReference)userId, (List)externalIds);
                            logger.info("auto-registered user '{}' as {}", (Object)username, (Object)userId);
                        }
                    } else {
                        logger.error("cannot auto-register user: no suitable username found from principals");
                    }
                }
                if (!(isRegister = this.isRegister()) && userId == null) {
                    throw new LoginException("Unknown user.");
                }
                if (userId != null) {
                    this.enilinkPrincipal = new EnilinkPrincipal(userId);
                }
            }
            if (this.enilinkPrincipal == null) {
                throw new LoginException("Unknown user.");
            }
            this.subject.getPrincipals().add((Principal)this.enilinkPrincipal);
            this.enilinkPrincipal = null;
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseEntityManager();
        }
    }

    @Override
    public boolean abort() throws LoginException {
        this.enilinkPrincipal = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        for (EnilinkPrincipal p : this.subject.getPrincipals(EnilinkPrincipal.class)) {
            this.subject.getPrincipals().remove(p);
        }
        this.enilinkPrincipal = null;
        return true;
    }
}

