/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.platform.core.security.ISecureEntity;
import net.enilink.platform.core.security.SecurityUtil;
import net.enilink.vocab.acl.ENILINKACL;
import net.enilink.vocab.acl.WEBACL;

public abstract class SecureEntitySupport
implements ISecureEntity,
Behaviour<ISecureEntity> {
    private static Set<IReference> systemUserModes = new HashSet<IReference>(Arrays.asList(WEBACL.MODE_CONTROL, WEBACL.MODE_READ, WEBACL.MODE_WRITE, ENILINKACL.MODE_CREATE));

    @Override
    public Set<IReference> getAclModes(IReference agent) {
        if (SecurityUtil.SYSTEM_USER.equals((Object)agent)) {
            return systemUserModes;
        }
        return this.queryModes(agent, null).toSet();
    }

    @Override
    public boolean hasAclMode(IReference agent, IReference mode) {
        if (SecurityUtil.SYSTEM_USER.equals((Object)agent)) {
            return systemUserModes.contains(mode);
        }
        try (IExtendedIterator<IReference> modes = this.queryModes(agent, mode);){
            boolean bl = modes.iterator().hasNext();
            return bl;
        }
    }

    protected IExtendedIterator<IReference> queryModes(IReference agent, IReference mode) {
        IQuery query = this.getEntityManager().createQuery("prefix acl: <http://www.w3.org/ns/auth/acl#> prefix foaf: <http://xmlns.com/foaf/0.1/> select ?mode where { { ?target acl:owner ?agent . bind (acl:Control as ?mode) } union {{ ?acl acl:accessTo ?target } union { ?target a [ rdfs:subClassOf* ?class ] . ?acl acl:accessToClass ?class } . { ?acl acl:agent [ foaf:member* ?agent ] } union { ?agent a [ rdfs:subClassOf* ?agentClass ] . ?acl acl:agentClass ?agentClass } . ?acl acl:mode ?mode }}", false);
        query.setParameter("target", (Object)this);
        if (agent != null) {
            query.setParameter("agent", (Object)agent);
        }
        if (mode != null) {
            query.setParameter("mode", (Object)mode);
        }
        return query.evaluateRestricted(IReference.class, new Class[0]);
    }
}

