/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core.security;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.util.Modules;
import java.util.Collection;
import java.util.Set;
import net.enilink.composition.annotations.ParameterTypes;
import net.enilink.composition.cache.annotations.Cacheable;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.em.ThreadLocalDataManager;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelSet;
import net.enilink.platform.core.security.ISecureEntity;
import net.enilink.platform.core.security.ISecureModelSet;
import net.enilink.platform.core.security.SecureDataManager;
import net.enilink.platform.core.security.SecurityUtil;
import net.enilink.vocab.acl.ENILINKACL;
import net.enilink.vocab.acl.WEBACL;
import org.aopalliance.intercept.MethodInvocation;

public abstract class SecureModelSetSupport
implements ISecureModelSet,
Behaviour<ISecureModelSet> {
    @ParameterTypes(value={Collection.class})
    public void collectInjectionModules(MethodInvocation invocation) throws Throwable {
        invocation.proceed();
        Collection modules = (Collection)invocation.getArguments()[0];
        Module compoundModule = Modules.override((Iterable)modules).with(new Module[]{new AbstractModule(){
            final ISecureModelSet self;
            {
                this.self = (ISecureModelSet)SecureModelSetSupport.this.getBehaviourDelegate();
            }

            protected void configure() {
                this.bind(IDataManager.class).to(SecureThreadLocalDataManager.class).in(Singleton.class);
            }

            @Provides
            ISecureModelSet provideModelSet() {
                return this.self;
            }
        }});
        modules.clear();
        modules.add(compoundModule);
    }

    @ParameterTypes(value={URI.class, String.class})
    public IModel createModel(MethodInvocation invocation) throws Throwable {
        URI user;
        IModel model = (IModel)invocation.proceed();
        if (model != null && !SecurityUtil.UNKNOWN_USER.equals((Object)(user = SecurityUtil.getUser())) && !SecurityUtil.SYSTEM_USER.equals((Object)user) && ((ISecureEntity)model).getAclOwner() == null) {
            ((ISecureEntity)model).setAclOwner((IReference)user);
        }
        return model;
    }

    @Override
    @Cacheable
    public boolean isReadableBy(IReference model, IReference agent) {
        if (model == null || model.equals(((IModelSet.Internal)this.getBehaviourDelegate()).getDefaultGraph())) {
            return true;
        }
        ISecureEntity secureEntity = (ISecureEntity)this.getMetaDataManager().findRestricted(model, ISecureEntity.class, new Class[0]);
        if (agent.equals(secureEntity.getAclOwner())) {
            return true;
        }
        Set<IReference> modes = secureEntity.getAclModes(agent);
        return modes.contains(WEBACL.MODE_READ) || modes.contains(ENILINKACL.MODE_WRITERESTRICTED) || modes.contains(WEBACL.MODE_CONTROL);
    }

    @Override
    @Cacheable
    public IReference writeModeFor(IReference model, IReference agent) {
        if (model == null || model.equals(((IModelSet.Internal)this.getBehaviourDelegate()).getDefaultGraph())) {
            return null;
        }
        ISecureEntity secureEntity = (ISecureEntity)this.getMetaDataManager().findRestricted(model, ISecureEntity.class, new Class[0]);
        if (agent.equals(secureEntity.getAclOwner())) {
            return WEBACL.MODE_CONTROL;
        }
        Set<IReference> modes = secureEntity.getAclModes(agent);
        URI mode = null;
        if (modes.contains(WEBACL.MODE_CONTROL)) {
            mode = WEBACL.MODE_CONTROL;
        } else if (modes.contains(WEBACL.MODE_WRITE)) {
            mode = WEBACL.MODE_WRITE;
        } else if (modes.contains(ENILINKACL.MODE_WRITERESTRICTED)) {
            mode = ENILINKACL.MODE_WRITERESTRICTED;
        } else if (modes.contains(WEBACL.MODE_APPEND)) {
            mode = WEBACL.MODE_APPEND;
        }
        return mode;
    }

    static class SecureThreadLocalDataManager
    extends ThreadLocalDataManager {
        @Inject
        ISecureModelSet modelSet;

        SecureThreadLocalDataManager() {
        }

        protected IDataManager initialValue() {
            return new SecureDataManager(this.modelSet, super.initialValue());
        }
    }
}

